/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.resources;

import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.FontStylesChangeListener;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.resources.DisposableFontRegistry;
import com.onpositive.richtexteditor.model.resources.SaveableFontStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FontStyleManager {
    protected DisposableFontRegistry fontRegistry;
    protected HashMap<String, FontStyle> styleMap = new HashMap();
    protected ArrayList<FontStyle> fontStyles = new ArrayList(3);
    public static String FONT_NORMAL_DISPLAY_NAME = "Normal";
    public static String FONT_H1_DISPLAY_NAME = "Header 1";
    public static String FONT_H2_DISPLAY_NAME = "Header 2";
    public static final String FONT_H3_DISPLAY_NAME = "Header 3";
    public static String NORMAL_FONT_NAME = FONT_NORMAL_DISPLAY_NAME;
    public static String FONT_H1_NAME = FONT_H1_DISPLAY_NAME;
    public static String FONT_H2_NAME = FONT_H2_DISPLAY_NAME;
    public static final String FONT_H3_NAME = "Header 3";
    protected FontStyle normFontStyle = new FontStyle(0, NORMAL_FONT_NAME, FONT_NORMAL_DISPLAY_NAME);
    protected FontStyle h1FontStyle = new FontStyle(0, FONT_H1_NAME, FONT_H1_DISPLAY_NAME);
    protected FontStyle h2FontStyle = new FontStyle(0, FONT_H2_NAME, FONT_H2_DISPLAY_NAME);
    protected FontStyle h3FontStyle = new FontStyle(0, "Header 3", "Header 3");
    protected ArrayList<FontStylesChangeListener> listeners = new ArrayList();

    public void addFontStyle(FontStyle style) {
        String fontDataName = style.getFontDataName();
        if (this.styleMap.containsKey(fontDataName)) {
            throw new IllegalArgumentException("Style with a given font data name already exists");
        }
        this.fontStyles.add(style);
        this.styleMap.put(fontDataName, style);
    }

    public void dispose() {
        this.fontRegistry.dispose();
    }

    public FontStyleManager(Display display) {
        this.initializeByDefault(display);
    }

    protected void initializeByDefault(Display display) {
        this.fontRegistry = new DisposableFontRegistry(display);
        this.addFontStyle(this.normFontStyle);
        this.addFontStyle(this.h1FontStyle);
        this.addFontStyle(this.h2FontStyle);
        this.addFontStyle(this.h3FontStyle);
        this.fontRegistry.put(FONT_H1_NAME, new FontData[]{new FontData("Times new Roman", 24, 0)});
        this.fontRegistry.put(FONT_H2_NAME, new FontData[]{new FontData("Times New Roman", 18, 0)});
        this.fontRegistry.put("Header 3", new FontData[]{new FontData("Times New Roman", 14, 0)});
        this.fontRegistry.put(NORMAL_FONT_NAME, new FontData[]{new FontData("Times New Roman", 12, 0)});
    }

    public String[] getFontStyleDataNames() {
        String[] result = new String[this.fontStyles.size()];
        int a = 0;
        for (FontStyle s : this.fontStyles) {
            result[a++] = s.getFontDataName();
        }
        return result;
    }

    public String[] getFontStyleDisplayNames() {
        String[] result = new String[this.fontStyles.size()];
        int a = 0;
        for (FontStyle s : this.fontStyles) {
            result[a++] = s.getDisplayName();
        }
        return result;
    }

    public FontStyle[] getFontStyles() {
        return this.fontStyles.toArray(new FontStyle[this.fontStyles.size()]);
    }

    public ArrayList<FontStyle> getFontStylesList() {
        return this.fontStyles;
    }

    public FontStyle getFontStyle(String fontStyleDisplayName) {
        for (FontStyle fs : this.fontStyles) {
            if (!fs.getDisplayName().equals(fontStyleDisplayName)) continue;
            return fs;
        }
        return null;
    }

    public FontStyle getFontStyleByFontDataName(String fontDataName) {
        for (FontStyle fs : this.fontStyles) {
            if (!fs.getFontDataName().equals(fontDataName)) continue;
            return fs;
        }
        return null;
    }

    public String getNameForStyleString(String fontDataName) {
        if (fontDataName.indexOf("font-family:") == -1 && fontDataName.indexOf("font-size:") == -1) {
            return FontStyle.NORMAL_FONT_NAME;
        }
        if (fontDataName.indexOf("font-family:") == -1) {
            this.fontRegistry.get(FontStyle.NORMAL_FONT_NAME).getFontData()[0].getName();
        }
        String faceTail = fontDataName.substring(fontDataName.indexOf("font-family:") + String.valueOf("font-family:").length());
        String faceName = faceTail.substring(0, faceTail.indexOf(";")).toLowerCase().trim();
        String heightTail = fontDataName.substring(fontDataName.indexOf("font-size:") + String.valueOf("font-size:").length()).trim();
        String heightValue = "";
        int i = 0;
        while (i < heightTail.length() && heightTail.charAt(i) >= '0' && heightTail.charAt(i) <= '9') {
            heightValue = String.valueOf(heightValue) + heightTail.charAt(i);
            ++i;
        }
        int height = this.fontRegistry.get(FontStyle.NORMAL_FONT_NAME).getFontData()[0].getHeight();
        try {
            height = Integer.parseInt(heightValue);
        }
        catch (Exception exception) {}
        for (String name : this.fontRegistry.getKeySet()) {
            FontData fd = this.fontRegistry.get(name).getFontData()[0];
            if (!fd.getName().toLowerCase().equals(faceName) || fd.getHeight() != height) continue;
            return name;
        }
        String newFontName = String.valueOf(faceName) + "_" + heightValue;
        this.fontRegistry.put(newFontName, new FontData[]{new FontData(faceName, height, 0)});
        return newFontName;
    }

    public Font getFontForPartition(BasePartition partition) {
        String preffix = "";
        if (partition.isBold()) {
            preffix = String.valueOf(preffix) + "bold_";
        }
        if (partition.isItalic()) {
            preffix = String.valueOf(preffix) + "italic_";
        }
        Font basicFont = this.fontRegistry.get(partition.getFontDataName());
        if (preffix.equals("")) {
            return basicFont;
        }
        String preffixName = String.valueOf(preffix) + partition.getFontDataName();
        Font newFont = this.fontRegistry.get(preffixName);
        if (newFont == null || newFont == this.fontRegistry.defaultFont()) {
            int fontStyle = 0;
            if (partition.isBold()) {
                fontStyle = 1;
            }
            if (partition.isItalic()) {
                fontStyle |= 2;
            }
            this.fontRegistry.put(preffixName, new FontData[]{new FontData(basicFont.getFontData()[0].getName(), basicFont.getFontData()[0].getHeight(), fontStyle)});
            newFont = this.fontRegistry.get(preffixName);
        }
        return newFont;
    }

    public FontRegistry getFontRegistry() {
        return this.fontRegistry;
    }

    public FontStyle getDefaultStyle() {
        return this.styleMap.get(NORMAL_FONT_NAME);
    }

    public HashMap<String, FontStyle> getStyleMap() {
        return this.styleMap;
    }

    public ArrayList<SaveableFontStyle> getSavebaleFontStylesList() {
        ArrayList<SaveableFontStyle> styles = new ArrayList<SaveableFontStyle>();
        for (FontStyle style : this.fontStyles) {
            SaveableFontStyle saveableFontStyle = new SaveableFontStyle(this, style);
            styles.add(saveableFontStyle);
        }
        return styles;
    }

    public void setStylesFromSaveableFontStylesList(Collection<SaveableFontStyle> list, Display display) {
        DisposableFontRegistry newRegistry = new DisposableFontRegistry(display);
        ArrayList<FontStyle> newFontStyles = new ArrayList<FontStyle>();
        for (SaveableFontStyle style : list) {
            String fontDataName = style.getFontDataName();
            String fdString = style.getFontDataString();
            FontData[] fontData = new FontData[]{new FontData(fdString)};
            newRegistry.put(fontDataName, fontData);
            FontStyle newStyle = new FontStyle(fontData[0].getStyle(), fontDataName, style.getDisplayName());
            newStyle.setColor(style.getColor());
            newStyle.setBgColor(style.getBgColor());
            newFontStyles.add(newStyle);
        }
        this.reinit(newFontStyles, newRegistry, newFontStyles);
    }

    public void reinit(ArrayList<FontStyle> newStyles, DisposableFontRegistry newRegistry, ArrayList<FontStyle> changedStyles) {
        this.fontStyles = newStyles;
        this.styleMap.clear();
        for (FontStyle fontStyle : newStyles) {
            this.styleMap.put(fontStyle.getFontDataName(), fontStyle);
        }
        this.fontRegistry.dispose();
        this.fontRegistry = newRegistry;
        this.stylesChanged(changedStyles);
    }

    public void addFontStyleChangeListener(FontStylesChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeFontStyleChangeListener(FontStylesChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void stylesChanged(ArrayList<FontStyle> changedStyles) {
        for (FontStylesChangeListener listener : this.listeners) {
            listener.stylesChanged(changedStyles);
        }
    }
}

