/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.CompositeChange;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PartitionDelta {
    private CompositeChange undoChange;
    private boolean optimizeParitions = true;
    private HashSet<BasePartition> changed = new HashSet();
    private HashSet<BasePartition> added = new HashSet();
    private HashSet<BasePartition> removed = new HashSet();

    public boolean isOptimizeParitions() {
        return this.optimizeParitions;
    }

    public void setOptimizeParitions(boolean optimizeParitions) {
        this.optimizeParitions = optimizeParitions;
    }

    public PartitionDelta(PartitionStorage storage) {
        this.undoChange = new CompositeChange(storage);
    }

    public void added(BasePartition partition) {
        this.removed.remove(partition);
        this.changed.add(partition);
        this.added.add(partition);
    }

    public void changed(BasePartition partition) {
        this.removed.remove(partition);
        this.changed.add(partition);
        this.added.add(partition);
    }

    public void removed(BasePartition partition) {
        this.removed.add(partition);
        this.changed.remove(partition);
        this.added.remove(partition);
    }

    public CompositeChange getUndoChange() {
        return this.undoChange;
    }

    public Set<BasePartition> getAdded() {
        return new HashSet<BasePartition>(this.added);
    }

    public void clearAdded() {
        this.added.clear();
    }

    public void clearChanged() {
        this.changed.clear();
    }

    public Set<BasePartition> getChanged() {
        return new HashSet<BasePartition>(this.changed);
    }

    public Set<BasePartition> getRemoved() {
        return new HashSet<BasePartition>(this.removed);
    }

    public void merge(PartitionDelta delta) {
        this.added.addAll(delta.added);
        this.changed.addAll(delta.changed);
        this.removed.addAll(delta.removed);
        this.added.removeAll(delta.removed);
        this.changed.removeAll(delta.removed);
        List<Change> parts = delta.getUndoChange().getParts();
        this.undoChange.addAll(0, parts);
    }

    public PartitionStorage getStorage() {
        return this.undoChange.getStorage();
    }
}

