/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLMemory
extends RowStoreAVL
implements PersistentStore {
    Table table;
    private IntKeyHashMapConcurrent rowIdMap;
    int rowIdSequence = 0;

    public RowStoreAVLMemory(PersistentStoreCollection manager, Table table) {
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.rowIdMap = new IntKeyHashMapConcurrent();
        manager.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return true;
    }

    @Override
    public int getAccessCount() {
        return 0;
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(int i) {
        return (CachedObject)this.rowIdMap.get(i);
    }

    @Override
    public CachedObject getKeep(int i) {
        return (CachedObject)this.rowIdMap.get(i);
    }

    @Override
    public CachedObject get(int i, boolean keep) {
        return (CachedObject)this.rowIdMap.get(i);
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        return (CachedObject)this.rowIdMap.get(object.getPos());
    }

    @Override
    public int getStorageSize(int i) {
        return 0;
    }

    @Override
    public void add(CachedObject object) {
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedObject getNewCachedObject(Session session, Object object) {
        RowAVL row = new RowAVL(this.table, (Object[])object);
        if (session != null) {
            RowAction.addAction(session, (byte)1, this.table, row);
        }
        RowStoreAVLMemory rowStoreAVLMemory = this;
        synchronized (rowStoreAVLMemory) {
            int id = this.rowIdSequence++;
            row.setPos(id);
            this.rowIdMap.put(id, row);
        }
        return row;
    }

    @Override
    public void removeAll() {
        this.rowIdMap.clear();
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int i) {
        this.rowIdMap.remove(i);
    }

    @Override
    public void removePersistence(int i) {
    }

    @Override
    public void release(int i) {
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public DataFileCache getCache() {
        return null;
    }

    @Override
    public void setCache(DataFileCache cache) {
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.rowIdMap.clear();
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
        Index index = key;
        this.accessorList[index.getPosition()] = accessor;
    }

    @Override
    public void setAccessor(Index key, int accessor) {
    }

    @Override
    public void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.indexList[0] == null || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        CachedObject[] oldAccessors = this.accessorList;
        Index[] oldIndexList = this.indexList;
        int limit = this.indexList.length;
        int diff = 1;
        int position = 0;
        if (keys.length < this.indexList.length) {
            diff = -1;
            limit = keys.length;
        }
        while (position < limit && this.indexList[position] == keys[position]) {
            ++position;
        }
        this.accessorList = (CachedObject[])ArrayUtil.toAdjustedArray(this.accessorList, null, position, diff);
        this.indexList = keys;
        try {
            if (diff > 0) {
                this.insertIndexNodes(this.indexList[0], this.indexList[position]);
            } else {
                this.dropIndexFromRows(this.indexList[0], oldIndexList[position]);
            }
        }
        catch (HsqlException e) {
            this.accessorList = oldAccessors;
            this.indexList = oldIndexList;
            throw e;
        }
    }

    @Override
    public CachedObject getNewInstance(int size) {
        return null;
    }

    void dropIndexFromRows(Index primaryIndex, Index oldIndex) {
        RowIterator it = primaryIndex.firstRow(this);
        int position = oldIndex.getPosition() - 1;
        while (it.hasNext()) {
            Row row = it.getNextRow();
            int i = position - 1;
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            while (i-- > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
    }

    boolean insertIndexNodes(Index primaryIndex, Index newIndex) {
        int position = newIndex.getPosition();
        RowIterator it = primaryIndex.firstRow(this);
        int rowCount = 0;
        HsqlException error = null;
        try {
            while (it.hasNext()) {
                Row row = it.getNextRow();
                ((RowAVL)row).insertNode(position);
                ++rowCount;
                newIndex.insert(null, this, row);
            }
            return true;
        }
        catch (OutOfMemoryError e) {
            error = Error.error(72);
        }
        catch (HsqlException e) {
            error = e;
        }
        it = primaryIndex.firstRow(this);
        for (int i = 0; i < rowCount; ++i) {
            Row row = it.getNextRow();
            NodeAVL backnode = ((RowAVL)row).getNode(0);
            int j = position;
            while (--j > 0) {
                backnode = backnode.nNext;
            }
            backnode.nNext = backnode.nNext.nNext;
        }
        throw error;
    }

    void reindex(Session session, Index index) {
        this.setAccessor(index, null);
        RowIterator it = this.table.rowIterator(session);
        while (it.hasNext()) {
            Row row = it.getNextRow();
            index.insert(session, this, row);
        }
    }
}

