/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.store.BaseHashMap;

public class Cache
extends BaseHashMap {
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private CachedObject[] rowTable;
    long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int saveRowCount = 0;

    Cache(DataFileCache dfc) {
        super(dfc.capacity(), 1, 3, true);
        this.maxCapacity = dfc.capacity();
        this.dataFileCache = dfc;
        this.capacity = dfc.capacity();
        this.bytesCapacity = dfc.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheBytesLength = 0L;
    }

    void init(int capacity, long bytesCapacity) {
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    public synchronized CachedObject get(int pos) {
        int lookup;
        if (this.accessCount == Integer.MAX_VALUE) {
            this.resetAccessCount();
        }
        if ((lookup = this.getLookup(pos)) == -1) {
            return null;
        }
        ++this.accessCount;
        return (CachedObject)this.objectValueTable[lookup];
    }

    synchronized void put(int key, CachedObject row) {
        int storageSize = row.getStorageSize();
        if (this.size() >= this.capacity || (long)storageSize + this.cacheBytesLength > this.bytesCapacity) {
            this.cleanUp();
        }
        if (this.accessCount == Integer.MAX_VALUE) {
            super.resetAccessCount();
        }
        super.addOrRemove(key, row, false);
        row.setInMemory(true);
        this.cacheBytesLength += (long)storageSize;
    }

    synchronized CachedObject release(int i) {
        CachedObject r = (CachedObject)super.addOrRemove(i, null, true);
        if (r == null) {
            return null;
        }
        this.cacheBytesLength -= (long)r.getStorageSize();
        r.setInMemory(false);
        return r;
    }

    private void updateAccessCounts() {
        for (int i = 0; i < this.objectValueTable.length; ++i) {
            int count;
            CachedObject r = (CachedObject)this.objectValueTable[i];
            if (r == null || (count = r.getAccessCount()) <= this.accessTable[i]) continue;
            this.accessTable[i] = count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void cleanUp() {
        this.updateAccessCounts();
        int removeCount = this.size() / 2;
        int accessTarget = this.getAccessCountCeiling(removeCount, removeCount / 8);
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this);
        int savecount = 0;
        while (it.hasNext()) {
            CachedObject row = (CachedObject)it.next();
            if (it.getAccessCount() > accessTarget) continue;
            CachedObject cachedObject = row;
            synchronized (cachedObject) {
                if (!row.isKeepInMemory()) {
                    row.setInMemory(false);
                    if (row.hasChanged()) {
                        this.rowTable[savecount++] = row;
                    }
                    it.remove();
                    this.cacheBytesLength -= (long)row.getStorageSize();
                    --removeCount;
                }
            }
        }
        if (removeCount > 50) {
            it = new BaseHashMap.BaseHashIterator(this);
            while (removeCount >= 0 && it.hasNext()) {
                CachedObject r = (CachedObject)it.next();
                if (r.isKeepInMemory()) continue;
                r.setInMemory(false);
                if (r.hasChanged()) {
                    this.rowTable[savecount++] = r;
                }
                it.remove();
                this.cacheBytesLength -= (long)r.getStorageSize();
                --removeCount;
            }
        }
        super.setAccessCountFloor(accessTarget);
        this.saveRows(savecount);
    }

    private synchronized void saveRows(int count) {
        if (count == 0) {
            return;
        }
        this.rowComparator.setType(1);
        this.sortTimer.start();
        Sort.sort(this.rowTable, this.rowComparator, 0, count - 1);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        this.dataFileCache.saveRows(this.rowTable, 0, count);
        this.saveRowCount += count;
        this.saveAllTimer.stop();
    }

    synchronized void saveAll() {
        BaseHashMap.BaseHashIterator it = new BaseHashMap.BaseHashIterator(this);
        int savecount = 0;
        while (it.hasNext()) {
            CachedObject r = (CachedObject)it.next();
            if (!r.hasChanged()) continue;
            this.rowTable[savecount++] = r;
        }
        this.saveRows(savecount);
        Error.printSystemOut(this.saveAllTimer.elapsedTimeToMessage("Cache.saveRows() total row save time"));
        Error.printSystemOut("Cache.saveRow() total row save count = " + this.saveRowCount);
        Error.printSystemOut(this.sortTimer.elapsedTimeToMessage("Cache.sort() total time"));
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.cacheBytesLength = 0L;
    }

    static final class CachedObjectComparator
    implements ObjectComparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType;

        CachedObjectComparator() {
        }

        void setType(int type) {
            this.compareType = type;
        }

        @Override
        public int compare(Object a, Object b) {
            switch (this.compareType) {
                case 1: {
                    return ((CachedObject)a).getPos() - ((CachedObject)b).getPos();
                }
                case 2: {
                    return ((CachedObject)a).getStorageSize() - ((CachedObject)b).getStorageSize();
                }
            }
            return 0;
        }
    }
}

