/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntLookup;

public class DoubleIntIndex
implements IntLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = true;
    private boolean hasChanged;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public DoubleIntIndex(int capacity, boolean fixedSize) {
        this.capacity = capacity;
        this.keys = new int[capacity];
        this.values = new int[capacity];
        this.fixedSize = fixedSize;
        this.hasChanged = true;
    }

    public synchronized int getKey(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[i];
    }

    public synchronized int getValue(int i) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[i];
    }

    public synchronized void setKey(int i, int key) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[i] = key;
    }

    public synchronized void setValue(int i, int value) {
        if (i < 0 || i >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[i] = value;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public synchronized boolean addUnsorted(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0) {
            if (this.sortOnValues) {
                if (value < this.values[this.count - 1]) {
                    this.sorted = false;
                }
            } else if (value < this.keys[this.count - 1]) {
                this.sorted = false;
            }
        }
        this.hasChanged = true;
        this.keys[this.count] = key;
        this.values[this.count] = value;
        ++this.count;
        return true;
    }

    public synchronized boolean addSorted(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0 && value < this.values[this.count - 1]) {
            return false;
        }
        this.hasChanged = true;
        this.keys[this.count] = key;
        this.values[this.count] = value;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? value : key;
        int i = this.binaryEmptySlotSearch();
        if (i == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != i) {
            this.moveRows(i, i + 1, this.count - i);
        }
        this.keys[i] = key;
        this.values[i] = value;
        ++this.count;
        return true;
    }

    @Override
    public synchronized boolean add(int key, int value) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? value : key;
        int i = this.binarySlotSearch();
        if (i == -1) {
            return false;
        }
        this.hasChanged = true;
        if (this.count != i) {
            this.moveRows(i, i + 1, this.count - i);
        }
        this.keys[i] = key;
        this.values[i] = value;
        ++this.count;
        return true;
    }

    @Override
    public int lookupFirstEqual(int key) throws NoSuchElementException {
        int i;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((i = this.findFirstEqualKeyIndex(key)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(i);
    }

    @Override
    public int lookupFirstGreaterEqual(int key) throws NoSuchElementException {
        int i;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((i = this.findFirstGreaterEqualKeyIndex(key)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(i);
    }

    public synchronized void setValuesSearchTarget() {
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = true;
    }

    public synchronized void setKeysSearchTarget() {
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = false;
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int value) {
        int index = this.findFirstGreaterEqualSlotIndex(value);
        return index == this.count ? -1 : index;
    }

    public synchronized int findFirstEqualKeyIndex(int value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binaryFirstSearch();
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int value) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = value;
        return this.binarySlotSearch();
    }

    private int binaryFirstSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        int found = this.count;
        while (low < high) {
            mid = (low + high) / 2;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
            found = mid;
        }
        return found == this.count ? -1 : found;
    }

    private int binaryGreaterSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = (low + high) / 2;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low == this.count ? -1 : low;
    }

    private int binarySlotSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = (low + high) / 2;
            compare = this.compare(mid);
            if (compare <= 0) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    private int binaryEmptySlotSearch() {
        int low = 0;
        int high = this.count;
        int mid = 0;
        int compare = 0;
        while (low < high) {
            mid = (low + high) / 2;
            compare = this.compare(mid);
            if (compare < 0) {
                high = mid;
                continue;
            }
            if (compare > 0) {
                low = mid + 1;
                continue;
            }
            return -1;
        }
        return low;
    }

    private synchronized void fastQuickSort() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int l, int r) {
        int M = 4;
        if (r - l > M) {
            int i = (r + l) / 2;
            if (this.lessThan(i, l)) {
                this.swap(l, i);
            }
            if (this.lessThan(r, l)) {
                this.swap(l, r);
            }
            if (this.lessThan(r, i)) {
                this.swap(i, r);
            }
            int j = r - 1;
            this.swap(i, j);
            i = l;
            int v = j;
            while (true) {
                if (this.lessThan(++i, v)) {
                    continue;
                }
                while (this.lessThan(v, --j)) {
                }
                if (j < i) break;
                this.swap(i, j);
            }
            this.swap(i, r - 1);
            this.quickSort(l, j);
            this.quickSort(i + 1, r);
        }
    }

    private void insertionSort(int lo0, int hi0) {
        for (int i = lo0 + 1; i <= hi0; ++i) {
            int j;
            for (j = i; j > lo0 && this.lessThan(i, j - 1); --j) {
            }
            if (i == j) continue;
            this.moveAndInsertRow(i, j);
        }
    }

    private void moveAndInsertRow(int i, int j) {
        int col1 = this.keys[i];
        int col2 = this.values[i];
        this.moveRows(j, j + 1, i - j);
        this.keys[j] = col1;
        this.values[j] = col2;
    }

    private void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (int[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    private void swap(int i1, int i2) {
        int col1 = this.keys[i1];
        int col2 = this.values[i1];
        this.keys[i1] = this.keys[i2];
        this.values[i1] = this.values[i2];
        this.keys[i2] = col1;
        this.values[i2] = col2;
    }

    private void moveRows(int fromIndex, int toIndex, int rows) {
        System.arraycopy(this.keys, fromIndex, this.keys, toIndex, rows);
        System.arraycopy(this.values, fromIndex, this.values, toIndex, rows);
    }

    public void removeRange(int start, int limit) {
        this.moveRows(limit, start, this.count - limit);
        this.count -= limit - start;
    }

    public void removeAll() {
        this.hasChanged = true;
        ArrayUtil.clearArray(73, this.keys, 0, this.count);
        ArrayUtil.clearArray(73, this.values, 0, this.count);
        this.count = 0;
    }

    private int compare(int i) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[i]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[i]) {
                return -1;
            }
        } else {
            if (this.targetSearchValue > this.keys[i]) {
                return 1;
            }
            if (this.targetSearchValue < this.keys[i]) {
                return -1;
            }
        }
        return 0;
    }

    public final synchronized void remove(int position) {
        this.hasChanged = true;
        this.moveRows(position + 1, position, this.count - position - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    private boolean lessThan(int i, int j) {
        return this.sortOnValues ? this.values[i] < this.values[j] : this.keys[i] < this.keys[j];
    }
}

