/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class IndexAVL
implements Index {
    private final long persistenceId;
    private final HsqlNameManager.HsqlName name;
    private final boolean[] colCheck;
    private final int[] colIndex;
    private final int[] defaultColMap;
    private final Type[] colTypes;
    private final boolean[] colDesc;
    private final boolean[] nullsLast;
    private final int[] pkCols;
    private final Type[] pkTypes;
    private final boolean isUnique;
    private final boolean useRowId;
    private final boolean isConstraint;
    private final boolean isForward;
    private int depth;
    private static final IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null, null, false);
    private final TableBase table;
    private int position;
    ReadWriteLock lock = new ReentrantReadWriteLock();
    Lock readLock = this.lock.readLock();
    Lock writeLock = this.lock.writeLock();
    public static final Index[] emptyArray = new Index[0];

    private static NodeAVL set(PersistentStore store, NodeAVL x, boolean isleft, NodeAVL n) {
        x = isleft ? x.setLeft(store, n) : x.setRight(store, n);
        if (n != null) {
            n.setParent(store, x);
        }
        return x;
    }

    private static NodeAVL child(PersistentStore store, NodeAVL x, boolean isleft) {
        return isleft ? x.getLeft(store) : x.getRight(store);
    }

    private static void getColumnList(Table t, int[] col, int len, StringBuffer a) {
        a.append('(');
        for (int i = 0; i < len; ++i) {
            a.append(t.getColumn((int)col[i]).getName().statementName);
            if (i >= len - 1) continue;
            a.append(',');
        }
        a.append(')');
    }

    public static int compareRows(Session session, Object[] a, Object[] b, int[] cols, Type[] coltypes) {
        int fieldcount = cols.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = coltypes[cols[j]].compare(session, a[cols[j]], b[cols[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public IndexAVL(HsqlNameManager.HsqlName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        this.persistenceId = id;
        this.name = name;
        this.colIndex = columns;
        this.colTypes = colTypes;
        this.colDesc = descending == null ? new boolean[columns.length] : descending;
        this.nullsLast = nullsLast == null ? new boolean[columns.length] : nullsLast;
        this.isUnique = unique;
        this.isConstraint = constraint;
        this.isForward = forward;
        this.table = table;
        this.pkCols = table.getPrimaryKey();
        this.pkTypes = table.getPrimaryKeyTypes();
        this.useRowId = !this.isUnique && this.pkCols.length == 0 || this.colIndex.length == 0;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.defaultColMap = new int[columns.length];
        ArrayUtil.fillSequence(this.defaultColMap);
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer(64);
        sb.append("CREATE").append(' ');
        if (this.isUnique()) {
            sb.append("UNIQUE").append(' ');
        }
        sb.append("INDEX").append(' ');
        sb.append(this.getName().statementName);
        sb.append(' ').append("ON").append(' ');
        sb.append(((Table)this.table).getName().getSchemaQualifiedStatementName());
        int[] col = this.getColumns();
        int len = this.getVisibleColumns();
        IndexAVL.getColumnList((Table)this.table, col, len, sb);
        return sb.toString();
    }

    @Override
    public RowIterator emptyIterator() {
        return emptyIterator;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public long getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public int getVisibleColumns() {
        return this.colIndex.length;
    }

    @Override
    public int getColumnCount() {
        return this.colIndex.length;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public int[] getColumns() {
        return this.colIndex;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    @Override
    public boolean[] getColumnDesc() {
        return this.colDesc;
    }

    @Override
    public int getIndexOrderValue() {
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size(PersistentStore store) {
        int count = 0;
        this.readLock.lock();
        try {
            RowIterator it = this.firstRow(null, store);
            while (it.hasNext()) {
                it.getNextRow();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int sizeEstimate(PersistentStore store) {
        return (int)(1L << this.depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(PersistentStore store) {
        this.readLock.lock();
        try {
            boolean bl = this.getAccessor(store) == null;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIndex(PersistentStore store) {
        this.readLock.lock();
        try {
            NodeAVL p;
            NodeAVL f = null;
            for (p = this.getAccessor(store); p != null; p = p.getLeft(store)) {
                f = p;
                this.checkNodes(store, p);
            }
            p = f;
            while (f != null) {
                this.checkNodes(store, f);
                f = this.next(store, f);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void checkNodes(PersistentStore store, NodeAVL p) {
        NodeAVL l = p.getLeft(store);
        NodeAVL r = p.getRight(store);
        if (l != null && l.getBalance(store) == -2) {
            System.out.print("broken index - deleted");
        }
        if (r != null && r.getBalance(store) == -2) {
            System.out.print("broken index -deleted");
        }
        if (l != null && !p.equals(l.getParent(store))) {
            System.out.print("broken index - no parent");
        }
        if (r != null && !p.equals(r.getParent(store))) {
            System.out.print("broken index - no parent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(Session session, PersistentStore store, Row row) {
        boolean isleft = true;
        int compare = -1;
        this.writeLock.lock();
        store.lock();
        try {
            NodeAVL n;
            NodeAVL x = n = this.getAccessor(store);
            if (n == null) {
                store.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
                return;
            }
            do {
                Row currentRow;
                if ((compare = this.compareRowForInsertOrDelete(session, row, currentRow = n.getRow(store))) != 0) continue;
                throw Error.error(104);
            } while ((n = IndexAVL.child(store, x = n, isleft = compare < 0)) != null);
            x = x.set(store, isleft, ((RowAVL)row).getNode(this.position));
            this.balance(store, x, isleft);
        }
        finally {
            store.unlock();
            this.writeLock.unlock();
        }
    }

    @Override
    public void delete(PersistentStore store, Row row) {
        if (!row.isInMemory()) {
            row = (Row)store.get(row, false);
        }
        NodeAVL node = ((RowAVL)row).getNode(this.position);
        this.delete(store, node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(PersistentStore store, NodeAVL x) {
        if (x == null) {
            return;
        }
        this.writeLock.lock();
        store.lock();
        try {
            NodeAVL n;
            if (x.getLeft(store) == null) {
                n = x.getRight(store);
            } else if (x.getRight(store) == null) {
                n = x.getLeft(store);
            } else {
                NodeAVL dl;
                NodeAVL temp;
                NodeAVL d = x;
                x = x.getLeft(store);
                while ((temp = x.getRight(store)) != null) {
                    x = temp;
                }
                n = x.getLeft(store);
                int b = x.getBalance(store);
                x = x.setBalance(store, d.getBalance(store));
                d = d.setBalance(store, b);
                NodeAVL xp = x.getParent(store);
                NodeAVL dp = d.getParent(store);
                if (d.isRoot(store)) {
                    store.setAccessor((Index)this, x);
                }
                x = x.setParent(store, dp);
                if (dp != null) {
                    dp = dp.isRight(d) ? dp.setRight(store, x) : dp.setLeft(store, x);
                }
                if (d.equals(xp)) {
                    if ((d = d.setParent(store, x)).isLeft(x)) {
                        x = x.setLeft(store, d);
                        NodeAVL dr = d.getRight(store);
                        x = x.setRight(store, dr);
                    } else {
                        x = x.setRight(store, d);
                        dl = d.getLeft(store);
                        x = x.setLeft(store, dl);
                    }
                } else {
                    d = d.setParent(store, xp);
                    xp = xp.setRight(store, d);
                    dl = d.getLeft(store);
                    NodeAVL dr = d.getRight(store);
                    x = x.setLeft(store, dl);
                    x = x.setRight(store, dr);
                }
                x.getRight(store).setParent(store, x);
                x.getLeft(store).setParent(store, x);
                d = d.setLeft(store, n);
                if (n != null) {
                    n = n.setParent(store, d);
                }
                x = d = d.setRight(store, null);
            }
            boolean isleft = x.isFromLeft(store);
            x.replace(store, this, n);
            n = x.getParent(store);
            x.delete();
            while (n != null) {
                x = n;
                int sign = isleft ? 1 : -1;
                switch (x.getBalance(store) * sign) {
                    case -1: {
                        x = x.setBalance(store, 0);
                        break;
                    }
                    case 0: {
                        x = x.setBalance(store, sign);
                        return;
                    }
                    case 1: {
                        NodeAVL r = IndexAVL.child(store, x, !isleft);
                        int b = r.getBalance(store);
                        if (b * sign >= 0) {
                            x.replace(store, this, r);
                            NodeAVL child = IndexAVL.child(store, r, isleft);
                            x = x.set(store, !isleft, child);
                            r = r.set(store, isleft, x);
                            if (b == 0) {
                                x = x.setBalance(store, sign);
                                r = r.setBalance(store, -sign);
                                return;
                            }
                            x = x.setBalance(store, 0);
                            x = r = r.setBalance(store, 0);
                            break;
                        }
                        NodeAVL l = IndexAVL.child(store, r, isleft);
                        x.replace(store, this, l);
                        b = l.getBalance(store);
                        r = r.set(store, isleft, IndexAVL.child(store, l, !isleft));
                        l = l.set(store, !isleft, r);
                        x = x.set(store, !isleft, IndexAVL.child(store, l, isleft));
                        l = l.set(store, isleft, x);
                        x = x.setBalance(store, b == sign ? -sign : 0);
                        r = r.setBalance(store, b == -sign ? sign : 0);
                        x = l = l.setBalance(store, 0);
                    }
                }
                isleft = x.isFromLeft(store);
                n = x.getParent(store);
            }
        }
        finally {
            store.unlock();
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean exists(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        return this.findNode(session, store, rowdata, rowColMap, rowColMap.length) != null;
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int match) {
        NodeAVL node = this.findNode(session, store, rowdata, this.defaultColMap, match);
        return this.getIterator(session, store, node, false);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata) {
        NodeAVL node = this.findNode(session, store, rowdata, this.colIndex, this.colIndex.length);
        return this.getIterator(session, store, node, false);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        NodeAVL node = this.findNode(session, store, rowdata, rowColMap, rowColMap.length);
        return this.getIterator(session, store, node, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator findFirstRow(Session session, PersistentStore store, Object value, int compare) {
        this.readLock.lock();
        try {
            boolean check;
            if (compare == 44 || compare == 45) {
                RowIterator rowIterator = this.findFirstRowNotNull(session, store);
                return rowIterator;
            }
            boolean isEqual = compare == 41 || compare == 47;
            NodeAVL x = this.getAccessor(store);
            int iTest = 1;
            if (compare == 43) {
                iTest = 0;
            }
            if (value == null && !isEqual) {
                IndexRowIterator indexRowIterator = emptyIterator;
                return indexRowIterator;
            }
            boolean bl = check = compare == 43 || compare == 41 || compare == 42;
            if (!check) {
                Error.runtimeError(401, "IndexAVL");
            }
            while (x != null) {
                boolean t;
                boolean bl2 = t = this.colTypes[0].compare(session, value, x.getData(store)[this.colIndex[0]]) >= iTest;
                if (t) {
                    NodeAVL r = x.getRight(store);
                    if (r == null) break;
                    x = r;
                    continue;
                }
                NodeAVL l = x.getLeft(store);
                if (l == null) break;
                x = l;
            }
            while (x != null) {
                Object colvalue = x.getData(store)[this.colIndex[0]];
                int result = this.colTypes[0].compare(session, value, colvalue);
                if (result >= iTest) {
                    x = this.next(store, x);
                    continue;
                }
                if (isEqual) {
                    if (result == 0) break;
                    x = null;
                    break;
                }
                if (colvalue != null) break;
                x = this.next(store, x);
            }
            if (session == null || x == null) {
                IndexRowIterator colvalue = this.getIterator(session, store, x, false);
                return colvalue;
            }
            while (x != null) {
                Row row = x.getRow(store);
                if (compare == 41 && this.colTypes[0].compare(session, value, row.getData()[this.colIndex[0]]) != 0) {
                    x = null;
                    break;
                }
                if (session.database.txManager.canRead(session, row)) break;
                x = this.next(store, x);
            }
            IndexRowIterator indexRowIterator = this.getIterator(session, store, x, this.isUnique && this.colIndex.length == 1 && compare == 41);
            return indexRowIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator findFirstRowNotNull(Session session, PersistentStore store) {
        this.readLock.lock();
        try {
            Row row;
            Object colvalue;
            NodeAVL x = this.getAccessor(store);
            while (x != null) {
                boolean t;
                boolean bl = t = this.colTypes[0].compare(session, null, x.getData(store)[this.colIndex[0]]) >= 0;
                if (t) {
                    NodeAVL r = x.getRight(store);
                    if (r == null) break;
                    x = r;
                    continue;
                }
                NodeAVL l = x.getLeft(store);
                if (l == null) break;
                x = l;
            }
            while (x != null && (colvalue = x.getData(store)[this.colIndex[0]]) == null) {
                x = this.next(store, x);
            }
            while (session != null && x != null && !session.database.txManager.canRead(session, row = x.getRow(store))) {
                x = this.next(store, x);
            }
            IndexRowIterator indexRowIterator = this.getIterator(session, store, x, false);
            return indexRowIterator;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(Session session, PersistentStore store) {
        int tempDepth = 0;
        this.readLock.lock();
        try {
            Row row;
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            while (l != null) {
                x = l;
                l = x.getLeft(store);
                ++tempDepth;
            }
            while (session != null && x != null && !session.database.txManager.canRead(session, row = x.getRow(store))) {
                x = this.next(store, x);
            }
            IndexRowIterator indexRowIterator = this.getIterator(session, store, x, false);
            return indexRowIterator;
        }
        finally {
            this.depth = tempDepth;
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(PersistentStore store) {
        int tempDepth = 0;
        this.readLock.lock();
        try {
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            while (l != null) {
                x = l;
                l = x.getLeft(store);
                ++tempDepth;
            }
            IndexRowIterator indexRowIterator = this.getIterator(null, store, x, false);
            return indexRowIterator;
        }
        finally {
            this.depth = tempDepth;
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Row lastRow(Session session, PersistentStore store) {
        this.readLock.lock();
        try {
            Row row;
            NodeAVL x;
            NodeAVL l = x = this.getAccessor(store);
            while (l != null) {
                x = l;
                l = x.getRight(store);
            }
            while (session != null && x != null && !session.database.txManager.canRead(session, row = x.getRow(store))) {
                x = this.last(store, x);
            }
            Row row2 = x == null ? null : x.getRow(store);
            return row2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private NodeAVL next(Session session, PersistentStore store, NodeAVL x) {
        if (x == null) {
            return null;
        }
        this.readLock.lock();
        try {
            while (true) {
                NodeAVL nodeAVL;
                if ((x = this.next(store, x)) == null) {
                    nodeAVL = x;
                    return nodeAVL;
                }
                if (session == null) {
                    nodeAVL = x;
                    return nodeAVL;
                }
                Row row = x.getRow(store);
                if (!session.database.txManager.canRead(session, row)) continue;
                NodeAVL nodeAVL2 = x;
                return nodeAVL2;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private NodeAVL next(PersistentStore store, NodeAVL x) {
        NodeAVL r = x.getRight(store);
        if (r != null) {
            x = r;
            NodeAVL l = x.getLeft(store);
            while (l != null) {
                x = l;
                l = x.getLeft(store);
            }
            return x;
        }
        NodeAVL ch = x;
        for (x = x.getParent(store); x != null && ch.equals(x.getRight(store)); x = x.getParent(store)) {
            ch = x;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeAVL last(PersistentStore store, NodeAVL x) {
        if (x == null) {
            return null;
        }
        this.readLock.lock();
        try {
            NodeAVL left = x.getLeft(store);
            if (left != null) {
                x = left;
                NodeAVL right = x.getRight(store);
                while (right != null) {
                    x = right;
                    right = x.getRight(store);
                }
                NodeAVL nodeAVL = x;
                return nodeAVL;
            }
            NodeAVL ch = x;
            for (x = x.getParent(store); x != null && ch.equals(x.getLeft(store)); x = x.getParent(store)) {
                ch = x;
            }
            NodeAVL nodeAVL = x;
            return nodeAVL;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void replace(PersistentStore store, NodeAVL x, NodeAVL n) {
        if (x.isRoot(store)) {
            if (n != null) {
                n = n.setParent(store, null);
            }
            store.setAccessor((Index)this, n);
        } else {
            x.getParent(store).set(store, x.isFromLeft(store), n);
        }
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, int[] rowColMap, Object[] b) {
        int fieldcount = rowColMap.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = this.colTypes[j].compare(session, a[rowColMap[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, int[] rowColMap, Object[] b, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[rowColMap[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int fieldcount) {
        for (int j = 0; j < fieldcount; ++j) {
            int i = this.colTypes[j].compare(session, a[j], b[this.colIndex[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    private int compareRowForInsertOrDelete(Session session, Row newRow, Row existingRow) {
        Object currentvalue;
        int j;
        Object[] a = newRow.getData();
        Object[] b = existingRow.getData();
        boolean hasNull = false;
        for (j = 0; j < this.colIndex.length; ++j) {
            boolean nulls;
            currentvalue = a[this.colIndex[j]];
            Object othervalue = b[this.colIndex[j]];
            int i = this.colTypes[j].compare(session, currentvalue, othervalue);
            boolean bl = nulls = currentvalue == null || othervalue == null;
            if (i != 0) {
                if (this.colDesc[j] && !nulls) {
                    i = -i;
                }
                if (this.nullsLast[j] && nulls) {
                    i = -i;
                }
                return i;
            }
            if (currentvalue != null) continue;
            hasNull = true;
        }
        if (this.isUnique && !this.useRowId && !hasNull) {
            if (session == null || session.database.txManager.canRead(session, existingRow)) {
                return 0;
            }
            int difference = newRow.getPos() - existingRow.getPos();
            return difference;
        }
        for (j = 0; j < this.pkCols.length; ++j) {
            currentvalue = a[this.pkCols[j]];
            int i = this.pkTypes[j].compare(session, currentvalue, b[this.pkCols[j]]);
            if (i == 0) continue;
            return i;
        }
        if (this.useRowId) {
            int difference = newRow.getPos() - existingRow.getPos();
            if (difference < 0) {
                difference = -1;
            } else if (difference > 0) {
                difference = 1;
            }
            return difference;
        }
        if (session == null || session.database.txManager.canRead(session, existingRow)) {
            return 0;
        }
        int difference = newRow.getPos() - existingRow.getPos();
        if (difference < 0) {
            difference = -1;
        } else if (difference > 0) {
            difference = 1;
        }
        return difference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeAVL findNode(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap, int fieldCount) {
        this.readLock.lock();
        try {
            NodeAVL x = this.getAccessor(store);
            NodeAVL result = null;
            while (x != null) {
                NodeAVL n;
                int i = this.compareRowNonUnique(session, rowdata, rowColMap, x.getData(store), fieldCount);
                if (i == 0) {
                    result = x;
                    n = x.getLeft(store);
                } else {
                    n = i > 0 ? x.getRight(store) : x.getLeft(store);
                }
                if (n == null) break;
                x = n;
            }
            if (session == null) {
                NodeAVL i = result;
                return i;
            }
            while (result != null) {
                Row row = result.getRow(store);
                if (this.compareRowNonUnique(session, rowdata, rowColMap, row.getData(), fieldCount) != 0) {
                    result = null;
                    break;
                }
                if (session.database.txManager.canRead(session, row)) break;
                result = this.next(store, result);
            }
            NodeAVL nodeAVL = result;
            return nodeAVL;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void balance(PersistentStore store, NodeAVL x, boolean isleft) {
        while (true) {
            int sign = isleft ? 1 : -1;
            switch (x.getBalance(store) * sign) {
                case 1: {
                    x = x.setBalance(store, 0);
                    return;
                }
                case 0: {
                    x = x.setBalance(store, -sign);
                    break;
                }
                case -1: {
                    NodeAVL l = IndexAVL.child(store, x, isleft);
                    if (l.getBalance(store) == -sign) {
                        x.replace(store, this, l);
                        x = x.set(store, isleft, IndexAVL.child(store, l, !isleft));
                        l = l.set(store, !isleft, x);
                        x = x.setBalance(store, 0);
                        l = l.setBalance(store, 0);
                    } else {
                        NodeAVL r = IndexAVL.child(store, l, !isleft);
                        x.replace(store, this, r);
                        l = l.set(store, !isleft, IndexAVL.child(store, r, isleft));
                        r = r.set(store, isleft, l);
                        x = x.set(store, isleft, IndexAVL.child(store, r, !isleft));
                        r = r.set(store, !isleft, x);
                        int rb = r.getBalance(store);
                        x = x.setBalance(store, rb == -sign ? sign : 0);
                        l = l.setBalance(store, rb == sign ? -sign : 0);
                        r = r.setBalance(store, 0);
                    }
                    return;
                }
            }
            if (x.isRoot(store)) {
                return;
            }
            isleft = x.isFromLeft(store);
            x = x.getParent(store);
        }
    }

    private NodeAVL getAccessor(PersistentStore store) {
        NodeAVL node = (NodeAVL)store.getAccessor(this);
        return node;
    }

    private IndexRowIterator getIterator(Session session, PersistentStore store, NodeAVL x, boolean single) {
        if (x == null) {
            return emptyIterator;
        }
        IndexRowIterator it = new IndexRowIterator(session, store, this, x, single);
        return it;
    }

    public static final class IndexRowIterator
    implements RowIterator {
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        NodeAVL nextnode;
        Row lastrow;
        boolean single;
        IndexRowIterator last;
        IndexRowIterator next;
        IndexRowIterator lastInSession;
        IndexRowIterator nextInSession;

        public IndexRowIterator(Session session, PersistentStore store, IndexAVL index, NodeAVL node, boolean single) {
            this.session = session;
            this.store = store;
            this.index = index;
            this.single = single;
            if (index == null) {
                return;
            }
            this.nextnode = node;
        }

        @Override
        public boolean hasNext() {
            return this.nextnode != null;
        }

        @Override
        public Row getNextRow() {
            if (this.nextnode == null) {
                this.release();
                return null;
            }
            this.lastrow = this.nextnode.getRow(this.store);
            this.nextnode = this.single ? null : this.index.next(this.session, this.store, this.nextnode);
            return this.lastrow;
        }

        @Override
        public void remove() {
            this.store.delete(this.lastrow);
            this.store.remove(this.lastrow.getPos());
        }

        @Override
        public void release() {
        }

        @Override
        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        @Override
        public long getPos() {
            return this.nextnode.getPos();
        }
    }
}

