/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class TableBase {
    public static final int SYSTEM_TABLE = 0;
    public static final int SYSTEM_SUBQUERY = 1;
    public static final int TEMP_TABLE = 2;
    public static final int MEMORY_TABLE = 3;
    public static final int CACHED_TABLE = 4;
    public static final int TEMP_TEXT_TABLE = 5;
    public static final int TEXT_TABLE = 6;
    public static final int VIEW_TABLE = 7;
    public static final int RESULT_TABLE = 8;
    public static final int TRANSITION_TABLE = 9;
    public static final int FUNCTION_TABLE = 10;
    public static final int SCOPE_STATEMENT = 11;
    public static final int SCOPE_TRANSACTION = 12;
    public static final int SCOPE_SESSION = 13;
    public static final int SCOPE_FULL = 14;
    public static final int COLUMNS_UNREFERENCED = 15;
    public static final int COLUMNS_REFERENCED = 16;
    public PersistentStore store;
    public int persistenceScope;
    public long persistenceId;
    int[] primaryKeyCols;
    Type[] primaryKeyTypes;
    int[] primaryKeyColsSequence;
    Index[] indexList;
    public Database database;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    Index fullIndex;
    boolean[] colNotNull;
    Type[] colTypes;
    protected int columnCount;
    int tableType;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected boolean isText;
    boolean isView;
    public boolean isSessionBased;
    protected boolean isSchemaBased;
    protected boolean isLogged;
    private boolean isTransactional = true;
    boolean hasLobColumn;

    TableBase() {
    }

    public TableBase(Session session, Database database, int scope, int type, Type[] colTypes) {
        this.tableType = type;
        this.persistenceScope = scope;
        this.isSessionBased = true;
        this.persistenceId = database.persistentStoreCollection.getNextId();
        this.database = database;
        this.colTypes = colTypes;
        this.columnCount = colTypes.length;
        this.primaryKeyCols = new int[0];
        this.primaryKeyTypes = new Type[0];
        this.indexList = new Index[0];
        this.createPrimaryIndex(this.primaryKeyCols, this.primaryKeyTypes, null);
    }

    public TableBase duplicate() {
        TableBase copy = new TableBase();
        copy.tableType = this.tableType;
        copy.persistenceScope = this.persistenceScope;
        copy.isSessionBased = this.isSessionBased;
        copy.persistenceId = this.database.persistentStoreCollection.getNextId();
        copy.database = this.database;
        copy.colTypes = this.colTypes;
        copy.columnCount = this.colTypes.length;
        copy.primaryKeyCols = this.primaryKeyCols;
        copy.primaryKeyTypes = this.primaryKeyTypes;
        copy.indexList = this.indexList;
        return copy;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public long getPersistenceId() {
        return this.persistenceId;
    }

    int getId() {
        return 0;
    }

    public final boolean onCommitPreserve() {
        return this.persistenceScope == 13;
    }

    public final RowIterator rowIterator(Session session) {
        PersistentStore store = session.sessionData.getRowStore(this);
        return this.getPrimaryIndex().firstRow(store);
    }

    public final RowIterator rowIterator(PersistentStore store) {
        return this.getPrimaryIndex().firstRow(store);
    }

    public final int getIndexCount() {
        return this.indexList.length;
    }

    public final Index getPrimaryIndex() {
        return this.indexList[0];
    }

    public final Type[] getPrimaryKeyTypes() {
        return this.primaryKeyTypes;
    }

    public final boolean hasPrimaryKey() {
        return this.primaryKeyCols.length != 0;
    }

    public final int[] getPrimaryKey() {
        return this.primaryKeyCols;
    }

    public final Type[] getColumnTypes() {
        return this.colTypes;
    }

    public Index getFullIndex() {
        return this.fullIndex;
    }

    public final Index getIndex(int i) {
        return this.indexList[i];
    }

    public final Index[] getIndexList() {
        return this.indexList;
    }

    public final boolean[] getNewColumnCheckList() {
        return new boolean[this.getColumnCount()];
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public final int getDataColumnCount() {
        return this.colTypes.length;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void setTransactional(boolean value) {
        this.isTransactional = value;
    }

    public final void setBestRowIdentifiers() {
        int[] briCols = null;
        int briColsCount = 0;
        boolean isStrict = false;
        int nNullCount = 0;
        if (this.colNotNull == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.colTypes.length];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        for (int i = 0; i < this.indexList.length; ++i) {
            Index index = this.indexList[i];
            int[] cols = index.getColumns();
            int colsCount = index.getVisibleColumns();
            if (colsCount == 0) continue;
            if (i == 0) {
                isStrict = true;
            }
            if (this.bestIndexForColumn[cols[0]] == -1) {
                this.bestIndexForColumn[cols[0]] = i;
            } else {
                Index existing = this.indexList[this.bestIndexForColumn[cols[0]]];
                if (colsCount > existing.getColumns().length) {
                    this.bestIndexForColumn[cols[0]] = i;
                }
            }
            if (!index.isUnique()) {
                if (this.bestIndex != null) continue;
                this.bestIndex = index;
                continue;
            }
            int nnullc = 0;
            for (int j = 0; j < colsCount; ++j) {
                if (!this.colNotNull[cols[j]]) continue;
                ++nnullc;
            }
            if (this.bestIndex != null) {
                this.bestIndex = index;
            }
            if (nnullc == colsCount) {
                if (briCols != null && briColsCount == nNullCount && colsCount >= briColsCount) continue;
                briCols = cols;
                briColsCount = colsCount;
                nNullCount = colsCount;
                isStrict = true;
                continue;
            }
            if (isStrict || briCols != null && colsCount >= briColsCount && nnullc <= nNullCount) continue;
            briCols = cols;
            briColsCount = colsCount;
            nNullCount = nnullc;
        }
        this.bestRowIdentifierCols = briCols == null || briColsCount == briCols.length ? briCols : ArrayUtil.arraySlice(briCols, 0, briColsCount);
        this.bestRowIdentifierStrict = isStrict;
        if (this.indexList[0].getColumnCount() > 0) {
            this.bestIndex = this.indexList[0];
        }
    }

    public final void createPrimaryIndex(int[] pkcols, Type[] pktypes, HsqlNameManager.HsqlName name) {
        long id = this.database.persistentStoreCollection.getNextId();
        IndexAVL newindex = new IndexAVL(name, id, this, pkcols, null, null, pktypes, true, true, true, false);
        try {
            this.addIndex(newindex);
        }
        catch (HsqlException e) {
            // empty catch block
        }
    }

    public final Index createAndAddIndexStructure(HsqlNameManager.HsqlName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward) {
        Index newindex = this.createIndexStructure(name, columns, descending, nullsLast, unique, constraint, forward);
        this.addIndex(newindex);
        return newindex;
    }

    final Index createIndexStructure(HsqlNameManager.HsqlName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward) {
        if (this.primaryKeyCols == null) {
            throw Error.runtimeError(401, "createIndex");
        }
        int s = columns.length;
        int[] cols = new int[s];
        Type[] types = new Type[s];
        for (int j = 0; j < s; ++j) {
            cols[j] = columns[j];
            types[j] = this.colTypes[cols[j]];
        }
        long id = this.database.persistentStoreCollection.getNextId();
        IndexAVL newIndex = new IndexAVL(name, id, this, cols, descending, nullsLast, types, false, unique, constraint, forward);
        return newIndex;
    }

    final void addIndex(Index index) {
        int i;
        for (i = 0; i < this.indexList.length; ++i) {
            Index current = this.indexList[i];
            int order = index.getIndexOrderValue() - current.getIndexOrderValue();
            if (order < 0) break;
        }
        this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, index, i, 1);
        for (i = 0; i < this.indexList.length; ++i) {
            this.indexList[i].setPosition(i);
        }
        if (this.store != null) {
            try {
                this.store.resetAccessorKeys(this.indexList);
            }
            catch (HsqlException e) {
                this.indexList = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, index.getPosition(), -1);
                for (i = 0; i < this.indexList.length; ++i) {
                    this.indexList[i].setPosition(i);
                }
                throw e;
            }
        }
        this.setBestRowIdentifiers();
    }

    final void removeIndex(int position) {
        this.setBestRowIdentifiers();
    }

    public final Object[] getEmptyRowData() {
        return new Object[this.getDataColumnCount()];
    }

    public final Index createIndex(HsqlNameManager.HsqlName name, int[] columns, boolean[] descending, boolean[] nullsLast, boolean unique, boolean constraint, boolean forward) {
        Index newIndex = this.createAndAddIndexStructure(name, columns, descending, nullsLast, unique, constraint, forward);
        return newIndex;
    }

    public void clearAllData(Session session) {
        PersistentStore store = session.sessionData.getRowStore(this);
        store.removeAll();
    }

    public void clearAllData(PersistentStore store) {
        store.removeAll();
    }

    public final boolean isEmpty(Session session) {
        if (this.getIndexCount() == 0) {
            return true;
        }
        PersistentStore store = session.sessionData.getRowStore(this);
        return this.getIndex(0).isEmpty(store);
    }

    public int getRowCount(PersistentStore store) {
        return this.getPrimaryIndex().size(store);
    }
}

