/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorLinkedList;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementResultUpdate
extends StatementDML {
    int actionType;
    Type[] types;

    StatementResultUpdate() {
        this.isTransactionStatement = true;
    }

    @Override
    public String describe(Session session) {
        return "";
    }

    @Override
    public Result execute(Session session) {
        try {
            return this.getResult(session);
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, null);
        }
    }

    @Override
    Result getResult(Session session) {
        this.checkAccessRights(session);
        Object[] args = session.sessionContext.dynamicArguments;
        switch (this.actionType) {
            case 81: {
                Long id = (Long)args[args.length - 1];
                PersistentStore store = session.sessionData.getRowStore(this.baseTable);
                Row row = (Row)store.get((int)id.longValue(), false);
                HashMappedList list = new HashMappedList();
                Object[] data = (Object[])ArrayUtil.duplicateArray(row.getData());
                for (int i = 0; i < this.baseColumnMap.length; ++i) {
                    if (this.types[i] == Type.SQL_ALL_TYPES) continue;
                    data[this.baseColumnMap[i]] = args[i];
                }
                list.add(row, data);
                this.update(session, this.baseTable, list);
                break;
            }
            case 18: {
                Long id = (Long)args[args.length - 1];
                PersistentStore store = session.sessionData.getRowStore(this.baseTable);
                Row row = (Row)store.get((int)id.longValue(), false);
                RowSetNavigatorLinkedList navigator = new RowSetNavigatorLinkedList();
                ((RowSetNavigator)navigator).add(row);
                this.delete(session, this.baseTable, navigator);
                break;
            }
            case 50: {
                Object[] data = this.baseTable.getNewRowData(session);
                for (int i = 0; i < data.length; ++i) {
                    data[this.baseColumnMap[i]] = args[i];
                }
                PersistentStore store = session.sessionData.getRowStore(this.baseTable);
                this.baseTable.insertRow(session, store, data);
            }
        }
        return Result.updateOneResult;
    }

    void setRowActionProperties(int action, Table table, Type[] types, int[] columnMap) {
        this.actionType = action;
        this.baseTable = table;
        this.types = types;
        this.baseColumnMap = columnMap;
    }

    @Override
    void checkAccessRights(Session session) {
        switch (this.type) {
            case 7: {
                break;
            }
            case 50: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                break;
            }
            case 85: {
                break;
            }
            case 19: {
                session.getGrantee().checkDelete(this.targetTable);
                break;
            }
            case 82: {
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
                break;
            }
            case 128: {
                session.getGrantee().checkInsert(this.targetTable, this.insertCheckColumns);
                session.getGrantee().checkUpdate(this.targetTable, this.updateCheckColumns);
            }
        }
    }
}

