/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementCompound;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;

public abstract class Statement {
    static final int META_RESET_VIEWS = 1;
    static final int META_RESET_STATEMENTS = 2;
    static final Statement[] emptyArray = new Statement[0];
    final int type;
    int group;
    boolean isLogged = true;
    boolean isValid = true;
    HsqlNameManager.HsqlName schemaName;
    Routine root;
    StatementCompound parent;
    boolean isError;
    boolean isTransactionStatement;
    boolean isExplain;
    int metaDataImpact;
    String sql;
    long id;
    long compileTimestamp;
    HsqlNameManager.HsqlName[] readTableNames = HsqlNameManager.HsqlName.emptyArray;
    HsqlNameManager.HsqlName[] writeTableNames = HsqlNameManager.HsqlName.emptyArray;
    OrderedHashSet references;

    public abstract Result execute(Session var1);

    public void setParameters(ExpressionColumn[] params) {
    }

    Statement(int type) {
        this.type = type;
    }

    Statement(int type, int group) {
        this.type = type;
        this.group = group;
    }

    public final boolean isError() {
        return this.isError;
    }

    public boolean isTransactionStatement() {
        return this.isTransactionStatement;
    }

    public boolean isAutoCommitStatement() {
        return false;
    }

    public void setCompileTimestamp(long ts) {
        this.compileTimestamp = ts;
    }

    public long getCompileTimestamp() {
        return this.compileTimestamp;
    }

    public final void setSQL(String sql) {
        this.sql = sql;
    }

    public String getSQL() {
        return this.sql;
    }

    public OrderedHashSet getReferences() {
        return this.references;
    }

    public final void setDescribe() {
        this.isExplain = true;
    }

    public abstract String describe(Session var1);

    public HsqlNameManager.HsqlName getSchemalName() {
        return this.schemaName;
    }

    public final void setSchemaHsqlName(HsqlNameManager.HsqlName name) {
        this.schemaName = name;
    }

    public final void setID(long csid) {
        this.id = csid;
    }

    public final long getID() {
        return this.id;
    }

    public final int getType() {
        return this.type;
    }

    public final int getGroup() {
        return this.group;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final boolean isLogged() {
        return this.isLogged;
    }

    public void clearVariables() {
    }

    public void resolve() {
    }

    public RangeVariable[] getRangeVariables() {
        return RangeVariable.emptyArray;
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForRead() {
        return this.readTableNames;
    }

    public final HsqlNameManager.HsqlName[] getTableNamesForWrite() {
        return this.writeTableNames;
    }

    public void setParent(StatementCompound statement) {
        this.parent = statement;
    }

    public void setRoot(Routine root) {
        this.root = root;
    }

    public boolean hasGeneratedColumns() {
        return false;
    }

    public ResultMetaData generatedResultMetaData() {
        return null;
    }

    public void setGeneratedColumnInfo(int mode, ResultMetaData meta) {
    }

    public ResultMetaData getResultMetaData() {
        return ResultMetaData.emptyResultMetaData;
    }

    public ResultMetaData getParametersMetaData() {
        return ResultMetaData.emptyParamMetaData;
    }
}

