/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.datechooser;

import java.util.Date;
import java.util.Locale;
import org.eclipse.nebula.widgets.datechooser.AbstractCombo;
import org.eclipse.nebula.widgets.datechooser.DateChooser;
import org.eclipse.nebula.widgets.datechooser.DateChooserTheme;
import org.eclipse.nebula.widgets.formattedtext.DateFormatter;
import org.eclipse.nebula.widgets.formattedtext.DefaultFormatterFactory;
import org.eclipse.nebula.widgets.formattedtext.FormattedText;
import org.eclipse.nebula.widgets.formattedtext.ITextFormatter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class DateChooserCombo
extends AbstractCombo {
    protected static final String IMAGE = "/org/eclipse/nebula/widgets/datechooser/DateChooserCombo.png";
    protected static Image buttonImage;
    protected FormattedText formattedText;
    protected boolean footerVisible = false;
    protected boolean gridVisible = true;
    protected DateChooserTheme theme;
    protected Locale locale;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Display display = Display.getCurrent();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.nebula.widgets.datechooser.DateChooserCombo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        buttonImage = new Image((Device)display, clazz.getResourceAsStream(IMAGE));
    }

    public DateChooserCombo(Composite parent, int style) {
        super(parent, style);
        this.setImage(buttonImage);
        this.pack();
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        this.formattedText.getControl().addKeyListener(listener);
    }

    protected void beforeDrop() {
        Date d = (Date)this.formattedText.getValue();
        DateChooser cal = (DateChooser)this.popupContent;
        if (d != null) {
            cal.setSelectedDate(d);
            cal.setFocusOnDate(d);
        } else {
            cal.clearSelection();
            cal.setFocusOnToday(false);
        }
    }

    protected void contentEvent(Event event) {
        switch (event.type) {
            case 13: {
                super.contentEvent(event);
                if (!event.doit) break;
                this.formattedText.setValue((Object)((DateChooser)this.popupContent).getSelectedDate());
                this.dropDown(false);
                this.text.setFocus();
                break;
            }
            default: {
                super.contentEvent(event);
            }
        }
    }

    protected void createButtonControl(int style) {
        this.button = new Button((Composite)this, (style &= 0xFFFFFBFB) | 8);
    }

    protected void createPopupContent() {
        DateChooser cal = new DateChooser((Composite)this.popup, 0);
        if (this.theme != null) {
            cal.setTheme(this.theme);
        }
        if (this.locale != null) {
            cal.setLocale(this.locale);
        }
        cal.setGridVisible(this.gridVisible);
        cal.setFooterVisible(this.footerVisible);
        cal.setAutoSelectOnFooter(true);
        this.popupContent = cal;
    }

    protected void createTextControl(int style) {
        this.formattedText = new FormattedText((Composite)this, 0);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.formattedText.setFormatter(DefaultFormatterFactory.createFormatter((Class)clazz));
        this.text = this.formattedText.getControl();
    }

    public Date getValue() {
        this.checkWidget();
        return (Date)this.formattedText.getValue();
    }

    public boolean isFooterVisible() {
        this.checkWidget();
        return this.footerVisible;
    }

    public boolean isGridVisible() {
        this.checkWidget();
        return this.gridVisible;
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        this.formattedText.getControl().removeKeyListener(listener);
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (!WIN32) {
            GridData textData = (GridData)this.text.getLayoutData();
            textData.heightHint = Math.max(this.button.computeSize((int)-1, (int)-1).y - 5, this.text.computeSize((int)-1, (int)-1).y);
        }
    }

    public void setFooterVisible(boolean footerVisible) {
        this.checkWidget();
        this.footerVisible = footerVisible;
    }

    public void setFormatter(DateFormatter formatter) {
        this.checkWidget();
        this.formattedText.setFormatter((ITextFormatter)formatter);
        this.locale = formatter.getLocale();
    }

    public void setGridVisible(boolean gridVisible) {
        this.checkWidget();
        this.gridVisible = gridVisible;
    }

    public void setImage(Image image) {
        this.checkWidget();
        GridData buttonLayout = (GridData)this.button.getLayoutData();
        if (WIN32) {
            ImageData id = image.getImageData();
            buttonLayout.widthHint = id.width + 4;
            buttonLayout.heightHint = id.height + 4;
        }
        buttonLayout.grabExcessVerticalSpace = true;
        this.button.setImage(image);
        if (!WIN32) {
            GridData textData = (GridData)this.text.getLayoutData();
            textData.heightHint = Math.max(this.button.computeSize((int)-1, (int)-1).y - 5, this.text.computeSize((int)-1, (int)-1).y);
        }
    }

    public void setLocale(Locale locale) {
        this.checkWidget();
        this.locale = locale;
        ((DateFormatter)this.formattedText.getFormatter()).setLocale(locale);
    }

    public void setTheme(DateChooserTheme theme) {
        this.checkWidget();
        this.theme = theme;
    }

    public void setValue(Date value) {
        this.checkWidget();
        this.formattedText.setValue((Object)value);
    }
}

