/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Collation;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.types.Charset;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobType;
import org.hsqldb.types.Type;

public class CharacterType
extends Type {
    Collation collation;
    Charset charset;
    boolean isEqualIdentical;
    static final int defaultCharPrecision = 32768;
    static final long maxCharPrecision = Integer.MAX_VALUE;

    public CharacterType(Collation collation, int type, long precision) {
        super(12, type, precision, 0);
        this.collation = collation;
        this.charset = Charset.getDefaultInstance();
        this.isEqualIdentical = this.collation.isEqualAlwaysIdentical() && type != 100;
    }

    public CharacterType(int type, long precision) {
        super(12, type, precision, 0);
        this.collation = Collation.getDefaultInstance();
        this.charset = Charset.getDefaultInstance();
        this.isEqualIdentical = type != 100;
    }

    @Override
    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    @Override
    public int getJDBCTypeCode() {
        switch (this.typeCode) {
            case 1: {
                return 1;
            }
            case 12: 
            case 100: {
                return 12;
            }
            case 40: {
                return 2005;
            }
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    @Override
    public String getJDBCClassName() {
        return "java.lang.String";
    }

    @Override
    public int getSQLGenericTypeCode() {
        return this.typeCode == 1 ? this.typeCode : 12;
    }

    @Override
    public String getNameString() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "VARCHAR";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 40: {
                return "CLOB";
            }
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    @Override
    public String getFullNameString() {
        switch (this.typeCode) {
            case 1: {
                return "CHARACTER";
            }
            case 12: {
                return "CHARACTER VARYING";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 40: {
                return "CHARACTER LARGE OBJECT";
            }
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    @Override
    public String getDefinition() {
        if (this.precision == 0L) {
            return this.getNameString();
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(this.precision);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean isCharacterType() {
        return true;
    }

    @Override
    public long getMaxPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean acceptsPrecision() {
        return true;
    }

    @Override
    public boolean requiresPrecision() {
        return this.typeCode == 12 || this.typeCode == 100;
    }

    @Override
    public int precedenceDegree(Type other) {
        if (other.typeCode == this.typeCode) {
            return 0;
        }
        if (!other.isCharacterType()) {
            return Integer.MIN_VALUE;
        }
        switch (this.typeCode) {
            case 1: {
                return other.typeCode == 40 ? 4 : 2;
            }
            case 12: 
            case 100: {
                return other.typeCode == 40 ? 4 : -2;
            }
            case 40: {
                return other.typeCode == 1 ? -4 : -2;
            }
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    @Override
    public Type getAggregateType(Type other) {
        if (this.typeCode == other.typeCode) {
            return this.precision >= other.precision ? this : other;
        }
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 1: {
                return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision);
            }
            case 12: {
                if (this.typeCode == 40 || this.typeCode == 100) {
                    return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision);
                }
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision);
            }
            case 100: {
                if (this.typeCode == 40) {
                    return this.precision >= other.precision ? this : CharacterType.getCharacterType(this.typeCode, other.precision);
                }
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision);
            }
            case 40: {
                return other.precision >= this.precision ? other : CharacterType.getCharacterType(other.typeCode, this.precision);
            }
            case 14: 
            case 15: 
            case 30: 
            case 60: 
            case 61: 
            case 1111: {
                throw Error.error(5562);
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Type other, int operation) {
        Type newType;
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        long newPrecision = this.precision + other.precision;
        switch (other.typeCode) {
            case 0: {
                return this;
            }
            case 1: {
                newType = this;
                break;
            }
            case 12: {
                newType = this.typeCode == 40 || this.typeCode == 100 ? this : other;
                break;
            }
            case 100: {
                newType = this.typeCode == 40 ? this : other;
                break;
            }
            case 40: {
                newType = other;
                break;
            }
            default: {
                throw Error.error(5562);
            }
        }
        if (newPrecision > Integer.MAX_VALUE) {
            if (this.typeCode == 60) {
                throw Error.error(5570);
            }
            if (this.typeCode == 1) {
                newPrecision = Integer.MAX_VALUE;
            }
        }
        return CharacterType.getCharacterType(newType.typeCode, this.precision + other.precision);
    }

    @Override
    public int compare(Session session, Object a, Object b) {
        int lb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        String as = (String)a;
        String bs = (String)b;
        int la = as.length();
        if (la != (lb = bs.length())) {
            if (la > lb) {
                char[] buffer = new char[la];
                bs.getChars(0, lb, buffer, 0);
                ArrayUtil.fillArray(buffer, lb, ' ');
                bs = String.valueOf(buffer);
            } else {
                char[] buffer = new char[lb];
                as.getChars(0, la, buffer, 0);
                ArrayUtil.fillArray(buffer, la, ' ');
                as = String.valueOf(buffer);
            }
        }
        if (this.typeCode == 100) {
            return this.collation.compareIgnoreCase(as, bs);
        }
        return this.collation.compare(as, bs);
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (this.precision == 0L) {
            return a;
        }
        switch (this.typeCode) {
            case 1: {
                int slen = ((String)a).length();
                if ((long)slen == this.precision) {
                    return a;
                }
                if ((long)slen > this.precision) {
                    if ((long)CharacterType.getRightTrimSise((String)a, ' ') <= this.precision) {
                        return ((String)a).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                char[] b = new char[(int)this.precision];
                ((String)a).getChars(0, slen, b, 0);
                int i = slen;
                while ((long)i < this.precision) {
                    b[i] = 32;
                    ++i;
                }
                return new String(b);
            }
            case 12: 
            case 100: {
                int slen = ((String)a).length();
                if ((long)slen > this.precision) {
                    if ((long)CharacterType.getRightTrimSise((String)a, ' ') <= this.precision) {
                        return ((String)a).substring(0, (int)this.precision);
                    }
                    throw Error.error(3401);
                }
                return a;
            }
            case 40: {
                return a;
            }
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    @Override
    public Object castToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, otherType, true);
    }

    public Object castOrConvertToType(SessionInterface session, Object a, Type otherType, boolean cast) {
        switch (otherType.typeCode) {
            case 1: 
            case 12: 
            case 100: {
                int length = ((String)a).length();
                if (this.precision != 0L && (long)length > this.precision) {
                    if ((long)StringUtil.rightTrimSize((String)a) > this.precision) {
                        if (!cast) {
                            throw Error.error(3401);
                        }
                        session.addWarning(Error.error(1004));
                    }
                    a = ((String)a).substring(0, (int)this.precision);
                }
                switch (this.typeCode) {
                    case 1: {
                        return this.convertToTypeLimits(session, a);
                    }
                    case 12: 
                    case 100: {
                        return a;
                    }
                    case 40: {
                        ClobDataID clob = session.createClob(((String)a).length());
                        clob.setString(session, 0L, (String)a);
                        return clob;
                    }
                }
                throw Error.runtimeError(401, "CharacterType");
            }
            case 40: {
                long length = ((ClobData)a).length(session);
                if (this.precision != 0L && length > this.precision && ((ClobData)a).nonSpaceLength(session) > this.precision) {
                    if (!cast) {
                        throw Error.error(3401);
                    }
                    session.addWarning(Error.error(1004));
                }
                switch (this.typeCode) {
                    case 1: 
                    case 12: 
                    case 100: {
                        if (length > Integer.MAX_VALUE) {
                            if (!cast) {
                                throw Error.error(3401);
                            }
                            length = Integer.MAX_VALUE;
                        }
                        a = ((ClobData)a).getSubString(session, 0L, (int)length);
                        return this.convertToTypeLimits(session, a);
                    }
                    case 40: {
                        if (this.precision != 0L && length > this.precision) {
                            return ((ClobData)a).getClob(session, 0L, this.precision);
                        }
                        return a;
                    }
                }
                throw Error.runtimeError(401, "CharacterType");
            }
            case 1111: {
                throw Error.error(5561);
            }
        }
        String s = otherType.convertToString(a);
        if (this.precision != 0L && (long)s.length() > this.precision) {
            throw Error.error(3401);
        }
        a = s;
        return this.convertToTypeLimits(session, a);
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.castOrConvertToType(session, a, otherType, false);
    }

    @Override
    public Object convertToTypeJDBC(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return a;
        }
        return this.convertToType(session, a, otherType);
    }

    @Override
    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof Boolean) {
            return this.convertToType(session, a, Type.SQL_BOOLEAN);
        }
        if (a instanceof BigDecimal) {
            a = JavaSystem.toString((BigDecimal)a);
            return this.convertToType(session, a, Type.SQL_VARCHAR);
        }
        if (a instanceof Number) {
            a = a.toString();
            return this.convertToType(session, a, Type.SQL_VARCHAR);
        }
        if (a instanceof String) {
            return this.convertToType(session, a, Type.SQL_VARCHAR);
        }
        if (a instanceof Date) {
            String s = ((Date)a).toString();
            return this.convertToType(session, s, Type.SQL_VARCHAR);
        }
        if (a instanceof Time) {
            String s = ((Time)a).toString();
            return this.convertToType(session, s, Type.SQL_VARCHAR);
        }
        if (a instanceof Timestamp) {
            String s = ((Timestamp)a).toString();
            return this.convertToType(session, s, Type.SQL_VARCHAR);
        }
        throw Error.error(5561);
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        switch (this.typeCode) {
            case 1: {
                int slen = ((String)a).length();
                if (this.precision == 0L || (long)slen == this.precision) {
                    return (String)a;
                }
                char[] b = new char[(int)this.precision];
                ((String)a).getChars(0, slen, b, 0);
                int i = slen;
                while ((long)i < this.precision) {
                    b[i] = 32;
                    ++i;
                }
                return new String(b);
            }
            case 12: 
            case 100: {
                return (String)a;
            }
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        String s = this.convertToString(a);
        return StringConverter.toQuotedString(s, '\'', true);
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        return !otherType.isObjectType();
    }

    public Collation getCollation() {
        return this.collation;
    }

    public Charset getCharacterSet() {
        return this.charset;
    }

    public boolean isEqualIdentical() {
        return this.isEqualIdentical;
    }

    public boolean isCaseInsensitive() {
        return this.typeCode == 100;
    }

    public long position(SessionInterface session, Object data, Object otherData, Type otherType, long offset) {
        if (data == null || otherData == null) {
            return -1L;
        }
        if (otherType.typeCode == 40) {
            long otherLength = ((ClobData)data).length(session);
            if (offset + otherLength > (long)((String)data).length()) {
                return -1L;
            }
            String otherString = ((ClobData)otherData).getSubString(session, 0L, (int)otherLength);
            return ((String)data).indexOf(otherString, (int)offset);
        }
        if (otherType.isCharacterType()) {
            long otherLength = ((String)data).length();
            if (offset + otherLength > (long)((String)data).length()) {
                return -1L;
            }
            return ((String)data).indexOf((String)otherData, (int)offset);
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    public Object substring(SessionInterface session, Object data, long offset, long length, boolean hasLength, boolean trailing) {
        long end;
        long dataLength;
        long l = dataLength = this.typeCode == 40 ? ((ClobData)data).length(session) : (long)((String)data).length();
        if (trailing) {
            end = dataLength;
            if (length > dataLength) {
                offset = 0L;
                length = dataLength;
            } else {
                offset = dataLength - length;
            }
        } else if (hasLength) {
            end = offset + length;
        } else {
            long l2 = end = dataLength > offset ? dataLength : offset;
        }
        if (end < offset) {
            throw Error.error(3431);
        }
        if (offset > end || end < 0L) {
            offset = 0L;
            end = 0L;
        }
        if (offset < 0L) {
            offset = 0L;
        }
        if (end > dataLength) {
            end = dataLength;
        }
        length = end - offset;
        if (data instanceof String) {
            return ((String)data).substring((int)offset, (int)(offset + length));
        }
        if (data instanceof ClobData) {
            ClobDataID clob = session.createClob(length);
            String result = ((ClobData)data).getSubString(session, offset, (int)length);
            clob.setString(session, 0L, result);
            return clob;
        }
        throw Error.runtimeError(401, "CharacterType");
    }

    public Object upper(Session session, Object data) {
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String result = ((ClobData)data).getSubString(session, 0L, (int)((ClobData)data).length(session));
            result = this.collation.toUpperCase(result);
            ClobDataID clob = session.createClob(result.length());
            clob.setString(session, 0L, result);
            return clob;
        }
        return this.collation.toUpperCase((String)data);
    }

    public Object lower(Session session, Object data) {
        if (data == null) {
            return null;
        }
        if (this.typeCode == 40) {
            String result = ((ClobData)data).getSubString(session, 0L, (int)((ClobData)data).length(session));
            result = this.collation.toLowerCase(result);
            ClobDataID clob = session.createClob(result.length());
            clob.setString(session, 0L, result);
            return clob;
        }
        return this.collation.toLowerCase((String)data);
    }

    public Object trim(SessionInterface session, Object data, int trim, boolean leading, boolean trailing) {
        int startindex;
        if (data == null) {
            return null;
        }
        String s = this.typeCode == 40 ? ((ClobData)data).getSubString(session, 0L, (int)((ClobData)data).length(session)) : (String)data;
        int endindex = s.length();
        if (trailing) {
            --endindex;
            while (endindex >= 0 && s.charAt(endindex) == trim) {
                --endindex;
            }
            ++endindex;
        }
        if (leading) {
            for (startindex = 0; startindex < endindex && s.charAt(startindex) == trim; ++startindex) {
            }
        }
        if (startindex != 0 || endindex != s.length()) {
            s = s.substring(startindex, endindex);
        }
        if (this.typeCode == 40) {
            ClobDataID clob = session.createClob(s.length());
            clob.setString(session, 0L, s);
            return clob;
        }
        return s;
    }

    public Object overlay(SessionInterface session, Object data, Object overlay, long offset, long length, boolean hasLength) {
        if (data == null || overlay == null) {
            return null;
        }
        if (!hasLength) {
            length = this.typeCode == 40 ? ((ClobData)overlay).length(session) : (long)((String)overlay).length();
        }
        Object temp = this.concat(null, this.substring(session, data, 0L, offset, true, false), overlay);
        return this.concat(null, temp, this.substring(session, data, offset + length, 0L, false, false));
    }

    @Override
    public Object concat(Session session, Object a, Object b) {
        if (a == null || b == null) {
            return null;
        }
        String left = a instanceof ClobData ? ((ClobData)a).getSubString(session, 0L, (int)((ClobData)a).length(session)) : (String)a;
        String right = b instanceof ClobData ? ((ClobData)b).getSubString(session, 0L, (int)((ClobData)b).length(session)) : (String)b;
        if (this.typeCode == 40) {
            ClobDataID clob = session.createClob(left.length() + right.length());
            clob.setString(session, 0L, left);
            clob.setString(session, left.length(), right);
            return clob;
        }
        return left + right;
    }

    public long size(SessionInterface session, Object data) {
        if (this.typeCode == 40) {
            return ((ClobData)data).length(session);
        }
        return ((String)data).length();
    }

    public static int getRightTrimSise(String s, char trim) {
        int endindex = s.length();
        --endindex;
        while (endindex >= 0 && s.charAt(endindex) == trim) {
            --endindex;
        }
        return ++endindex;
    }

    public static Type getCharacterType(int type, long precision) {
        switch (type) {
            case 1: 
            case 12: 
            case 100: {
                return new CharacterType(type, (int)precision);
            }
            case 40: {
                return new ClobType(precision);
            }
        }
        throw Error.runtimeError(401, "CharacterType");
    }
}

