/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.util.Enumeration;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.HsqlProperties;

public class ServerProperties
extends HsqlProperties {
    static final int SERVER_PROPERTY = 0;
    static final int SERVER_MULTI_PROPERTY = 1;
    static final int SYSTEM_PROPERTY = 2;
    static final String sc_key_address = "server.address";
    static final String sc_key_autorestart_server = "server.restart_on_shutdown";
    static final String sc_key_database = "server.database.";
    static final String sc_key_dbname = "server.dbname.";
    static final String sc_key_no_system_exit = "server.no_system_exit";
    static final String sc_key_port = "server.port";
    static final String sc_key_http_port = "server.port";
    static final String sc_key_silent = "server.silent";
    static final String sc_key_tls = "server.tls";
    static final String sc_key_trace = "server.trace";
    static final String sc_key_web_default_page = "server.default_page";
    static final String sc_key_web_root = "server.root";
    static final String sc_key_max_connections = "server.maxconnections";
    static final String sc_key_remote_open_db = "server.remote_open";
    static final String sc_key_max_databases = "server.maxdatabases";
    static final String sc_key_acl = "server.acl";
    static final String sc_key_system = "system.";
    static final String sc_default_web_mime = "text/html";
    static final String sc_default_web_page = "index.html";
    static final String sc_default_web_root = ".";
    static final HashMap meta = new HashMap();
    static final OrderedHashSet prefixes = new OrderedHashSet();
    final int protocol;
    protected boolean initialised = false;
    IntKeyHashMap idToAliasMap = new IntKeyHashMap();
    IntKeyHashMap idToPathMap = new IntKeyHashMap();
    HashMappedList databases = new HashMappedList();
    HsqlArrayList errorList = new HsqlArrayList();

    ServerProperties(int protocol) {
        this.protocol = protocol;
    }

    ServerProperties(int protocol, String path) {
        super(path);
        this.protocol = protocol;
    }

    void validate() {
        Enumeration<?> en = this.stringProps.propertyNames();
        while (en.hasMoreElements()) {
            String error;
            String key = (String)en.nextElement();
            Object[] metadata = (Object[])meta.get(key);
            if (metadata == null) {
                metadata = this.getPrefixedMetadata(key);
            }
            if (metadata == null) {
                error = "unsupported property: " + key;
                this.errorList.add(error);
                continue;
            }
            error = null;
            if ((Integer)metadata[1] == 2) {
                error = this.validateSystemProperty(key, metadata);
            } else if ((Integer)metadata[1] == 1) {
                error = this.validateMultiProperty(key, metadata);
            } else {
                String value = this.getProperty(key);
                if (value == null) {
                    if (metadata[4] == null) {
                        error = "missing value for property: " + key;
                    } else {
                        this.setProperty(key, metadata[4].toString());
                    }
                } else {
                    error = HsqlProperties.validateProperty(key, value, metadata);
                }
            }
            if (error == null) continue;
            this.errorList.add(error);
        }
        Iterator it = this.idToAliasMap.keySet().iterator();
        while (it.hasNext()) {
            int number = it.nextInt();
            if (this.idToPathMap.containsKey(number)) continue;
            this.errorList.add("no path for database id: " + number);
        }
        it = this.idToPathMap.keySet().iterator();
        while (it.hasNext()) {
            int number = it.nextInt();
            if (this.idToAliasMap.containsKey(number)) continue;
            this.errorList.add("no alias for database id: " + number);
        }
        this.initialised = true;
    }

    Object[] getPrefixedMetadata(String key) {
        for (int i = 0; i < prefixes.size(); ++i) {
            String prefix = (String)prefixes.get(i);
            if (!key.startsWith(prefix)) continue;
            return (Object[])meta.get(prefix);
        }
        return null;
    }

    String validateMultiProperty(String key, Object[] meta) {
        String path;
        Object existing;
        int dbNumber;
        String prefix = (String)meta[0];
        try {
            dbNumber = Integer.parseInt(key.substring(prefix.length()));
        }
        catch (NumberFormatException e1) {
            return "maformed database enumerator: " + key;
        }
        if (meta[0].equals(sc_key_dbname)) {
            String alias = this.stringProps.getProperty(key).toLowerCase();
            if (this.databases.containsKey(alias)) {
                return "duplicate alias: " + alias;
            }
            Object existing2 = this.idToAliasMap.put(dbNumber, alias);
            if (existing2 != null) {
                return "duplicate database enumerator: " + key;
            }
        } else if (meta[0].equals(sc_key_database) && (existing = this.idToPathMap.put(dbNumber, path = this.stringProps.getProperty(key))) != null) {
            return "duplicate database enumerator: " + key;
        }
        return null;
    }

    String validateSystemProperty(String key, Object[] meta) {
        String prefix = (String)meta[0];
        String specificKey = key.substring(prefix.length());
        String value = this.stringProps.getProperty(key);
        if (value == null) {
            return "value required for property: " + key;
        }
        System.setProperty(specificKey, value);
        return null;
    }

    static {
        meta.put(sc_key_database, ServerProperties.getMeta(sc_key_database, 1, null));
        meta.put(sc_key_dbname, ServerProperties.getMeta(sc_key_dbname, 1, null));
        meta.put(sc_key_system, ServerProperties.getMeta(sc_key_system, 2, null));
        meta.put(sc_key_silent, ServerProperties.getMeta(sc_key_silent, 0, false));
        meta.put(sc_key_trace, ServerProperties.getMeta(sc_key_trace, 0, false));
        meta.put(sc_key_tls, ServerProperties.getMeta(sc_key_tls, 0, false));
        meta.put(sc_key_acl, ServerProperties.getMeta(sc_key_acl, 0, false));
        meta.put(sc_key_autorestart_server, ServerProperties.getMeta(sc_key_autorestart_server, 0, false));
        meta.put(sc_key_remote_open_db, ServerProperties.getMeta(sc_key_remote_open_db, 0, false));
        meta.put(sc_key_no_system_exit, ServerProperties.getMeta(sc_key_no_system_exit, 0, false));
        prefixes.add(sc_key_database);
        prefixes.add(sc_key_dbname);
        prefixes.add(sc_key_system);
        meta.put(sc_key_address, ServerProperties.getMeta(sc_key_address, 0, null));
        meta.put("server.port", ServerProperties.getMeta("server.port", 0, 9001, 0, 65535));
        meta.put("server.port", ServerProperties.getMeta("server.port", 0, 80, 0, 65535));
        meta.put(sc_key_max_connections, ServerProperties.getMeta(sc_key_max_connections, 0, 100, 1, 10000));
        meta.put(sc_key_max_databases, ServerProperties.getMeta(sc_key_max_databases, 0, 10, 1, 1000));
    }
}

