/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.Storage;
import org.hsqldb.persist.ScaledRAFileHybrid;
import org.hsqldb.persist.ScaledRAFileInJar;
import org.hsqldb.persist.ScaledRAInterface;

final class ScaledRAFile
implements ScaledRAInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final long MAX_NIO_LENGTH = 0x10000000L;
    final Database database;
    final RandomAccessFile file;
    final FileDescriptor fileDescriptor;
    private final boolean readOnly;
    final String fileName;
    boolean isNio;
    boolean bufferDirty = true;
    final byte[] buffer;
    final HsqlByteArrayInputStream ba;
    long bufferOffset;
    long seekPosition;
    long realPosition;
    int cacheHit;

    static Storage newScaledRAFile(Database database, String name, boolean readonly, int type, String classname, String key) throws FileNotFoundException, IOException {
        if (classname != null) {
            try {
                Class<?> zclass = Class.forName(classname);
                Constructor<?> constructor = zclass.getConstructor(String.class, Boolean.class, Object.class);
                return (Storage)constructor.newInstance(name, new Boolean(readonly), key);
            }
            catch (ClassNotFoundException e) {
                throw new IOException();
            }
            catch (NoSuchMethodException e) {
                throw new IOException();
            }
            catch (InstantiationException e) {
                throw new IOException();
            }
            catch (IllegalAccessException e) {
                throw new IOException();
            }
            catch (InvocationTargetException e) {
                throw new IOException();
            }
        }
        if (type == 2) {
            return new ScaledRAFileInJar(name);
        }
        if (type == 0) {
            return new ScaledRAFile(database, name, readonly);
        }
        RandomAccessFile file = new RandomAccessFile(name, readonly ? "r" : "rw");
        if (file.length() > 0x10000000L) {
            return new ScaledRAFile(database, name, file, readonly);
        }
        file.close();
        try {
            Class.forName("java.nio.MappedByteBuffer");
            return new ScaledRAFileHybrid(database, name, readonly);
        }
        catch (Exception e) {
            return new ScaledRAFile(database, name, readonly);
        }
    }

    ScaledRAFile(Database database, String name, RandomAccessFile file, boolean readonly) throws FileNotFoundException, IOException {
        this.database = database;
        this.readOnly = readonly;
        this.fileName = name;
        this.file = file;
        int bufferSize = 4096;
        this.buffer = new byte[bufferSize];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
        this.fileDescriptor = file.getFD();
    }

    ScaledRAFile(Database database, String name, boolean readonly) throws FileNotFoundException, IOException {
        this.database = database;
        this.readOnly = readonly;
        this.fileName = name;
        this.file = new RandomAccessFile(name, readonly ? "r" : "rw");
        int bufferSize = 4096;
        this.buffer = new byte[bufferSize];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
        this.fileDescriptor = this.file.getFD();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long position) throws IOException {
        if (!this.readOnly && this.file.length() < position) {
            long tempSize = position - this.file.length();
            if (tempSize > 262144L) {
                tempSize = 262144L;
            }
            byte[] temp = new byte[(int)tempSize];
            try {
                long pos;
                for (pos = this.file.length(); pos < position - tempSize; pos += tempSize) {
                    this.file.seek(pos);
                    this.file.write(temp, 0, (int)tempSize);
                }
                this.file.seek(pos);
                this.file.write(temp, 0, (int)(position - pos));
                this.realPosition = position;
            }
            catch (IOException e) {
                this.database.logger.logWarningEvent("seek failed", e);
                throw e;
            }
        }
        this.seekPosition = position;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long filePos = this.seekPosition;
        long subOffset = filePos % (long)this.buffer.length;
        long fileLength = this.file.length();
        long readLength = fileLength - (filePos - subOffset);
        try {
            if (readLength <= 0L) {
                throw new IOException("read beyond end of file");
            }
            if (readLength > (long)this.buffer.length) {
                readLength = this.buffer.length;
            }
            this.file.seek(filePos - subOffset);
            this.file.readFully(this.buffer, 0, (int)readLength);
            this.bufferOffset = filePos - subOffset;
            this.realPosition = this.bufferOffset + readLength;
            this.bufferDirty = false;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent(" " + this.realPosition + " " + readLength, e);
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            long fileLength = this.file.length();
            if (this.seekPosition >= fileLength) {
                return -1;
            }
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            this.ba.skip(this.seekPosition - this.bufferOffset);
            int val = this.ba.read();
            ++this.seekPosition;
            return val;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("read failed", e);
            throw e;
        }
    }

    @Override
    public long readLong() throws IOException {
        try {
            long val;
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            try {
                val = this.ba.readLong();
            }
            catch (EOFException e) {
                this.file.seek(this.seekPosition);
                val = this.file.readLong();
                this.realPosition = this.file.getFilePointer();
            }
            this.seekPosition += 8L;
            return val;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed ot read a Long", e);
            throw e;
        }
    }

    @Override
    public int readInt() throws IOException {
        try {
            int val;
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            try {
                val = this.ba.readInt();
            }
            catch (EOFException e) {
                this.file.seek(this.seekPosition);
                val = this.file.readInt();
                this.realPosition = this.file.getFilePointer();
            }
            this.seekPosition += 4L;
            return val;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to read an Int", e);
            throw e;
        }
    }

    @Override
    public void read(byte[] b, int offset, int length) throws IOException {
        try {
            if (this.bufferDirty || this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int bytesRead = this.ba.read(b, offset, length);
            this.seekPosition += (long)bytesRead;
            if (bytesRead < length) {
                if (this.seekPosition != this.realPosition) {
                    this.file.seek(this.seekPosition);
                }
                this.file.readFully(b, offset + bytesRead, length - bytesRead);
                this.seekPosition += (long)(length - bytesRead);
                this.realPosition = this.seekPosition;
            }
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("faeild to read a byte array", e);
            throw e;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + (long)len > this.bufferOffset) {
                this.bufferDirty = true;
            }
            this.file.write(b, off, len);
            this.seekPosition += (long)len;
            this.realPosition = this.seekPosition;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write a byte array", e);
            throw e;
        }
    }

    @Override
    public void writeInt(int i) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + 4L > this.bufferOffset) {
                this.bufferDirty = true;
            }
            this.file.writeInt(i);
            this.seekPosition += 4L;
            this.realPosition = this.seekPosition;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write an int", e);
            throw e;
        }
    }

    @Override
    public void writeLong(long i) throws IOException {
        try {
            if (this.realPosition != this.seekPosition) {
                this.file.seek(this.seekPosition);
                this.realPosition = this.seekPosition;
            }
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + 8L > this.bufferOffset) {
                this.bufferDirty = true;
            }
            this.file.writeLong(i);
            this.seekPosition += 8L;
            this.realPosition = this.seekPosition;
        }
        catch (IOException e) {
            this.resetPointer();
            this.database.logger.logWarningEvent("failed to write a Long", e);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        Error.printSystemOut("cache hit " + this.cacheHit);
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean wasNio() {
        return false;
    }

    @Override
    public boolean canAccess(int length) {
        return true;
    }

    @Override
    public boolean canSeek(long position) {
        return true;
    }

    @Override
    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.fileDescriptor.sync();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void resetPointer() {
        try {
            this.bufferDirty = true;
            this.file.seek(this.seekPosition);
            this.realPosition = this.seekPosition;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

