/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class MultiValueHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;
    Iterator valueIterator;

    public MultiValueHashMap() {
        this(8);
    }

    public MultiValueHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 3, 3, false);
        this.multiValueTable = new boolean[this.objectValueTable.length];
    }

    public Iterator get(Object key) {
        int hash = key.hashCode();
        return super.getValuesIterator(key, hash);
    }

    public Object put(Object key, Object value) {
        return super.addOrRemoveMultiVal(0L, 0L, key, value, false, false);
    }

    public Object remove(Object key) {
        return super.addOrRemoveMultiVal(0L, 0L, key, null, true, false);
    }

    public Object remove(Object key, Object value) {
        return super.addOrRemoveMultiVal(0L, 0L, key, value, false, true);
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public void putAll(HashMap t) {
        Iterator it = t.keySet.iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            MultiValueHashMap multiValueHashMap = MultiValueHashMap.this;
            multiValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(multiValueHashMap, false);
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            MultiValueHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            return new BaseHashMap.MultiValueKeyIterator(MultiValueHashMap.this);
        }

        @Override
        public int size() {
            return MultiValueHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return MultiValueHashMap.this.containsKey(o);
        }

        @Override
        public Object get(Object key) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            int oldSize = this.size();
            MultiValueHashMap.this.remove(o);
            return this.size() != oldSize;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            MultiValueHashMap.this.clear();
        }
    }
}

