/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.BaseHashMap;

public class LongKeyHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;

    public LongKeyHashMap() {
        this(16);
    }

    public LongKeyHashMap(int initialCapacity) throws IllegalArgumentException {
        super(initialCapacity, 2, 3, false);
    }

    public Object get(long key) {
        int lookup = this.getLookup(key);
        if (lookup != -1) {
            return this.objectValueTable[lookup];
        }
        return null;
    }

    public Object put(long key, Object value) {
        return super.addOrRemove(key, 0L, null, value, false);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    public Object remove(long key) {
        return super.addOrRemove(key, 0L, null, null, true);
    }

    @Override
    public boolean containsKey(long key) {
        return super.containsKey(key);
    }

    public int getOrderedMatchCount(int[] array) {
        int i;
        for (i = 0; i < array.length && super.containsKey(array[i]); ++i) {
        }
        return i;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            throw new RuntimeException();
        }

        @Override
        public Object get(Object key) {
            throw new RuntimeException();
        }

        @Override
        public boolean add(Object value) {
            throw new RuntimeException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new RuntimeException();
        }

        @Override
        public boolean remove(Object o) {
            throw new RuntimeException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }
}

