/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hsqldb.ClientConnection;
import org.hsqldb.ClientConnectionHTTP;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCCallableStatement;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCSavepoint;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public class JDBCConnection
implements Connection {
    int rsHoldability = 1;
    HsqlProperties connProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private Object rootWarning_mutex = new Object();
    private int savepointIDSequence;

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        JDBCStatement stmt = new JDBCStatement(this, 1003, 1007, this.rsHoldability);
        return stmt;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement stmt = new JDBCCallableStatement(this, sql, 1003, 1007, this.rsHoldability);
            return stmt;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        if (sql == null || sql.length() == 0 || sql.indexOf(123) == -1) {
            return sql;
        }
        int state = 0;
        int len = sql.length();
        int nest = 0;
        StringBuffer sb = new StringBuffer(sql.length());
        boolean outside_all = false;
        boolean outside_escape_inside_single_quotes = true;
        int outside_escape_inside_double_quotes = 2;
        int inside_escape = 3;
        int inside_escape_inside_single_quotes = 4;
        int inside_escape_inside_double_quotes = 5;
        sb.append(sql);
        block6: for (int i = 0; i < len; ++i) {
            char c = sb.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\'') {
                        state = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    i = this.onStartEscapeSequence(sql, sb, i);
                    ++nest;
                    state = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --state;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    state -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        state = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        state = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        sb.setCharAt(i, ' ');
                        state = --nest == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    i = this.onStartEscapeSequence(sql, sb, i);
                    ++nest;
                    state = 3;
                }
            }
        }
        return sb.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(autoCommit);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.sessionProxy != null) {
            this.sessionProxy.close();
        }
        this.sessionProxy = null;
        this.rootWarning = null;
        this.connProperties = null;
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(readOnly);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, catalog);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        switch (level) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(level);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        return new JDBCStatement(this, resultSetType, resultSetConcurrency, this.rsHoldability);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, this.rsHoldability);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        switch (holdability) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        this.rsHoldability = holdability;
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw Util.sqlException(4821);
        }
        try {
            this.sessionProxy.savepoint("SYSTEM_SAVEPOINT");
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
        return new JDBCSavepoint(this);
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw Util.sqlException(4821);
        }
        if (name == null) {
            throw Util.nullArgument();
        }
        if ("SYSTEM_SAVEPOINT".equals(name)) {
            throw Util.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(name);
        }
        catch (HsqlException e) {
            Util.throwError(e);
        }
        return new JDBCSavepoint(name, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (sp.name == null) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this.getAutoCommit()) {
            sp.name = null;
            sp.connection = null;
            throw Util.sqlException(4821);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(sp.name);
            sp.connection = null;
            sp.name = null;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw Util.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        JDBCSavepoint sp = (JDBCSavepoint)savepoint;
        if (sp.name == null) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this != sp.connection) {
            String msg = Error.getMessage(4821);
            throw Util.invalidArgument(msg);
        }
        if (this.getAutoCommit()) {
            sp.name = null;
            sp.connection = null;
            throw Util.sqlException(4821);
        }
        try {
            this.sessionProxy.releaseSavepoint(sp.name);
            sp.connection = null;
            sp.name = null;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        return new JDBCStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, 2, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
                throw Util.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, autoGeneratedKeys, null, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 21, columnIndexes, null);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, sql, 1003, 1007, this.rsHoldability, 11, null, columnNames);
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JDBCNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new JDBCSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw Util.outOfRangeArgument("timeout: " + timeout);
        }
        if (this.isInternal) {
            return true;
        }
        if (!this.isNetConn) {
            return !this.isClosed();
        }
        if (this.isClosed()) {
            return false;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    JDBCConnection.this.getMetaData().getDatabaseMajorVersion();
                }
                catch (Exception e) {
                    throw new RuntimeException();
                }
            }
        };
        timeout *= 1000;
        try {
            t.start();
            long start = System.currentTimeMillis();
            t.join(timeout);
            return timeout > 0 ? System.currentTimeMillis() - start < (long)timeout : true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        SQLClientInfoException ex = new SQLClientInfoException();
        ex.initCause(Util.notSupported());
        throw ex;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (!this.isClosed && (properties == null || properties.isEmpty())) {
            return;
        }
        SQLClientInfoException ex = new SQLClientInfoException();
        if (this.isClosed) {
            ex.initCause(Util.connectionClosedException());
        } else {
            ex.initCause(Util.notSupported());
        }
        throw ex;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw Util.invalidArgument("iface: " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    public JDBCConnection(HsqlProperties props) throws SQLException {
        boolean isTLS;
        String user = props.getProperty("user");
        String password = props.getProperty("password");
        String connType = props.getProperty("connection_type");
        String host = props.getProperty("host");
        int port = props.getIntegerProperty("port", 0);
        String path = props.getProperty("path");
        String database = props.getProperty("database");
        boolean bl = isTLS = connType == "hsqls://" || connType == "https://";
        if (user == null) {
            user = "SA";
        }
        if (password == null) {
            password = "";
        }
        Calendar cal = Calendar.getInstance();
        int zoneSeconds = HsqlDateTime.getZoneSeconds(cal);
        try {
            if (DatabaseURL.isInProcessDatabaseType(connType)) {
                this.sessionProxy = DatabaseManager.newSession(connType, database, user, password, props, null, zoneSeconds);
            } else if (connType == "hsql://" || connType == "hsqls://") {
                this.sessionProxy = new ClientConnection(host, port, path, database, isTLS, user, password, zoneSeconds);
                this.isNetConn = true;
            } else if (connType == "http://" || connType == "https://") {
                this.sessionProxy = new ClientConnectionHTTP(host, port, path, database, isTLS, user, password, zoneSeconds);
                this.isNetConn = true;
            } else {
                throw Util.invalidArgument(connType);
            }
            this.connProperties = props;
        }
        catch (HsqlException e) {
            throw Util.sqlException(e);
        }
    }

    public JDBCConnection(SessionInterface c) {
        this.isInternal = true;
        this.sessionProxy = c;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = w;
            } else {
                this.rootWarning.setNextWarning(w);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning w) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = w;
        }
    }

    public void reset() throws SQLException {
        try {
            this.sessionProxy.resetSession();
        }
        catch (HsqlException e) {
            throw Util.sqlException(1305, e.getMessage(), e);
        }
    }

    private int onStartEscapeSequence(String sql, StringBuffer sb, int i) throws SQLException {
        sb.setCharAt(i++, ' ');
        i = StringUtil.skipSpaces(sql, i);
        if (sql.regionMatches(true, i, "fn ", 0, 3) || sql.regionMatches(true, i, "oj ", 0, 3) || sql.regionMatches(true, i, "ts ", 0, 3)) {
            sb.setCharAt(i++, ' ');
            sb.setCharAt(i++, ' ');
        } else if (sql.regionMatches(true, i, "d ", 0, 2) || sql.regionMatches(true, i, "t ", 0, 2)) {
            sb.setCharAt(i++, ' ');
        } else if (sql.regionMatches(true, i, "call ", 0, 5)) {
            i += 4;
        } else if (sql.regionMatches(true, i, "?= call ", 0, 8)) {
            sb.setCharAt(i++, ' ');
            sb.setCharAt(i++, ' ');
            i += 5;
        } else if (sql.regionMatches(true, i, "? = call ", 0, 8)) {
            sb.setCharAt(i++, ' ');
            sb.setCharAt(i++, ' ');
            sb.setCharAt(i++, ' ');
            i += 5;
        } else if (sql.regionMatches(true, i, "escape ", 0, 7)) {
            i += 6;
        } else {
            throw Util.sqlException(Error.error(138, sql.substring(--i)));
        }
        return i;
    }
}

