/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDDL;
import org.hsqldb.Session;
import org.hsqldb.StatementSchema;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.result.Result;

public class StatementSchemaDefinition
extends StatementSchema {
    StatementSchema[] statements;

    StatementSchemaDefinition(StatementSchema[] statements) {
        this.statements = statements;
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
        }
        return result;
    }

    @Override
    Result getResult(Session session) {
        int i;
        this.schemaName = this.statements[0].getSchemalName();
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        Result result = this.statements[0].execute(session);
        HsqlArrayList constraints = new HsqlArrayList();
        if (this.statements.length == 1 || result.isError()) {
            return result;
        }
        HsqlNameManager.HsqlName oldSessionSchema = session.getCurrentSchemaHsqlName();
        for (i = 1; i < this.statements.length; ++i) {
            try {
                session.setSchema(this.schemaName.name);
            }
            catch (HsqlException e) {
                // empty catch block
            }
            this.statements[i].setSchemaHsqlName(this.schemaName);
            session.parser.reset(this.statements[i].getSQL());
            try {
                session.parser.read();
                switch (this.statements[i].getType()) {
                    case 48: 
                    case 49: {
                        result = this.statements[i].execute(session);
                        break;
                    }
                    case 77: {
                        StatementSchema cs = session.parser.compileCreate();
                        cs.isSchemaDefinition = true;
                        cs.setSchemaHsqlName(this.schemaName);
                        if (session.parser.token.tokenType != 748) {
                            throw session.parser.unexpectedToken();
                        }
                        result = cs.execute(session);
                        constraints.addAll((HsqlArrayList)cs.arguments[1]);
                        ((HsqlArrayList)cs.arguments[1]).clear();
                        break;
                    }
                    case 8: 
                    case 10: 
                    case 61: 
                    case 83: 
                    case 133: {
                        result = this.statements[i].execute(session);
                        break;
                    }
                    case 14: 
                    case 23: 
                    case 80: 
                    case 84: 
                    case 1052: {
                        StatementSchema cs = session.parser.compileCreate();
                        cs.isSchemaDefinition = true;
                        cs.setSchemaHsqlName(this.schemaName);
                        if (session.parser.token.tokenType != 748) {
                            throw session.parser.unexpectedToken();
                        }
                        result = cs.execute(session);
                        break;
                    }
                    case 6: 
                    case 52: 
                    case 79: 
                    case 114: 
                    case 117: {
                        throw session.parser.unsupportedFeature();
                    }
                    default: {
                        throw Error.runtimeError(401, "");
                    }
                }
                if (!result.isError()) continue;
                break;
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e, this.statements[i].getSQL());
            }
        }
        if (!result.isError()) {
            try {
                for (i = 0; i < constraints.size(); ++i) {
                    Constraint c = (Constraint)constraints.get(i);
                    Table table = session.database.schemaManager.getUserTable(session, c.core.refTableName);
                    ParserDDL.addForeignKey(session, table, c, null);
                }
            }
            catch (HsqlException e) {
                result = Result.newErrorResult(e, this.sql);
            }
        }
        if (result.isError()) {
            try {
                session.database.schemaManager.dropSchema(this.schemaName.name, true);
                session.database.logger.writeToLog(session, this.getDropSchemaStatement(this.schemaName));
            }
            catch (HsqlException e) {
                // empty catch block
            }
        }
        try {
            session.setCurrentSchemaHsqlName(oldSessionSchema);
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    String getDropSchemaStatement(HsqlNameManager.HsqlName schema) {
        return "DROP SCHEMA " + schema.statementName + " " + "CASCADE";
    }
}

