/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.error.Error;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.rights.User;
import org.hsqldb.scriptio.ScriptWriterText;

public class StatementCommand
extends Statement {
    Expression[] expressions;
    Object[] parameters;

    StatementCommand(int type, Object[] args, HsqlNameManager.HsqlName readName, HsqlNameManager.HsqlName writeName) {
        super(type);
        this.isTransactionStatement = true;
        this.parameters = args;
        if (readName != null) {
            this.readTableNames = new HsqlNameManager.HsqlName[]{readName};
        }
        if (writeName != null) {
            this.writeTableNames = new HsqlNameManager.HsqlName[]{writeName};
        }
        switch (type) {
            case 1002: {
                this.group = 2013;
                this.isLogged = false;
                break;
            }
            case 1001: 
            case 1004: {
                this.group = 2013;
                this.isLogged = false;
                break;
            }
            case 1025: 
            case 1026: 
            case 1040: {
                this.isTransactionStatement = false;
                this.group = 2012;
                break;
            }
            case 1011: 
            case 1012: 
            case 1013: 
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: 
            case 1018: 
            case 1019: 
            case 1020: 
            case 1023: 
            case 1024: 
            case 1027: 
            case 1028: 
            case 1031: 
            case 1032: 
            case 1033: 
            case 1034: 
            case 1035: 
            case 1036: 
            case 1037: 
            case 1038: 
            case 1039: {
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1070: {
                this.isLogged = false;
            }
            case 1069: {
                this.metaDataImpact = 1;
                this.group = 2013;
                this.isTransactionStatement = true;
                break;
            }
            case 1068: {
                this.metaDataImpact = 1;
                this.group = 2012;
                this.isTransactionStatement = true;
                break;
            }
            case 1003: {
                this.isLogged = false;
                this.group = 2013;
                this.isTransactionStatement = false;
                break;
            }
            case 1071: {
                this.group = 2013;
                this.isTransactionStatement = true;
                break;
            }
            case 1067: {
                this.group = 2012;
                this.isTransactionStatement = false;
                this.isLogged = false;
                break;
            }
            case 1042: 
            case 1043: {
                this.group = 2012;
                this.isTransactionStatement = false;
                break;
            }
            default: {
                throw Error.runtimeError(401, "StatementCommand");
            }
        }
    }

    @Override
    public Result execute(Session session) {
        Result result;
        try {
            result = this.getResult(session);
        }
        catch (Throwable t) {
            result = Result.newErrorResult(t, null);
        }
        if (result.isError()) {
            result.getException().setStatementType(this.group, this.type);
            return result;
        }
        try {
            if (this.isLogged) {
                session.database.logger.writeToLog(session, this.sql);
            }
        }
        catch (Throwable e) {
            return Result.newErrorResult(e, this.sql);
        }
        return result;
    }

    Result getResult(Session session) {
        if (this.isExplain) {
            return Result.newSingleColumnStringResult("OPERATION", this.describe(session));
        }
        switch (this.type) {
            case 1001: {
                String path = (String)this.parameters[0];
                boolean blocking = (Boolean)this.parameters[1];
                boolean script = (Boolean)this.parameters[2];
                boolean compressed = (Boolean)this.parameters[3];
                try {
                    session.checkAdmin();
                    if (!session.database.getType().equals("file:")) {
                        return Result.newErrorResult(Error.error(82));
                    }
                    if (session.database.isReadOnly()) {
                        return Result.newErrorResult(Error.error(63), null);
                    }
                    session.database.logger.backup(path, session.database.getPath(), script, blocking, compressed);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1002: {
                boolean defrag = (Boolean)this.parameters[0];
                try {
                    session.database.logger.checkpoint(defrag);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1013: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setIncrementBackup(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1014: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setCacheMaxRows(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1015: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setCacheSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1023: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setCacheFileScale(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1016: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setDefagLimit(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1017: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setEventLogLevel(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1018: {
                try {
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1020: {
                try {
                    boolean value = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setNioDataFile(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1019: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setLogSize(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1025: {
                try {
                    String value = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1026: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.setMetaDirty(false);
                    session.database.logger.setWriteDelay(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1033: {
                try {
                    String name = (String)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.collation.setCollation(name);
                    session.database.setMetaDirty(false);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1034: {
                try {
                    boolean mode = (Boolean)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.setIgnoreCase(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1035: {
                boolean mode = (Boolean)this.parameters[0];
                session.database.setReferentialIntegrity(mode);
                return Result.updateZeroResult;
            }
            case 1036: {
                boolean mode = (Boolean)this.parameters[0];
                session.database.setStrictNames(mode);
                return Result.updateZeroResult;
            }
            case 1037: {
                boolean mode = (Boolean)this.parameters[0];
                session.database.setStrictColumnSize(mode);
                return Result.updateZeroResult;
            }
            case 1011: {
                HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.parameters[0];
                session.database.schemaManager.setDefaultSchemaHsqlName(schema);
                session.database.setMetaDirty(true);
                return Result.updateZeroResult;
            }
            case 1012: {
                Integer type = (Integer)this.parameters[0];
                session.database.schemaManager.setDefaultTableType(type);
                return Result.updateZeroResult;
            }
            case 1032: {
                try {
                    int value = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.logger.setScriptType(value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1039: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    session.database.txManager.setTransactionControl(session, mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1027: {
                try {
                    int count = (Integer)this.parameters[0];
                    session.checkAdmin();
                    JavaSystem.gcFrequency = count;
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1028: {
                try {
                    String property = (String)this.parameters[0];
                    Object value = this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1031: {
                int size = (Integer)this.parameters[0];
                session.database.getProperties().setProperty("hsqldb.result_max_memory_rows", size);
                session.database.setResultMaxMemoryRows(size);
                return Result.updateZeroResult;
            }
            case 1038: {
                try {
                    String source = (String)this.parameters[0];
                    HsqlProperties props = null;
                    if (source.length() > 0 && (props = HsqlProperties.delimitedArgPairsToProps(source, "=", ";", null)).getErrorKeys().length > 0) {
                        throw Error.error(75, props.getErrorKeys()[0]);
                    }
                    session.database.logger.setDefaultTextTableProperties(source, props);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1040: {
                try {
                    String name = (String)this.parameters[0];
                    session.database.setUniqueName(name);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1004: {
                ScriptWriterText dsw = null;
                String name = (String)this.parameters[0];
                if (name == null) {
                    return session.database.getScript(false);
                }
                try {
                    dsw = new ScriptWriterText(session.database, name, true, true, true);
                    dsw.writeAll();
                    dsw.close();
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
                return Result.updateZeroResult;
            }
            case 1003: {
                try {
                    int mode = (Integer)this.parameters[0];
                    session.database.close(mode);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1067: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    String value = (String)this.parameters[1];
                    Table table = session.database.schemaManager.getTable(session, name.name, name.schema.name);
                    table.setIndexRoots(session, value);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1068: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, name.name, name.schema.name);
                    boolean mode = (Boolean)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    table.setDataReadOnly(mode);
                    session.database.setMetaDirty(false);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1069: 
            case 1070: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    Table table = session.database.schemaManager.getTable(session, name.name, name.schema.name);
                    if (!table.isText()) {
                        HsqlException e = Error.error(321);
                        return Result.newErrorResult(e, this.sql);
                    }
                    if (this.parameters[1] != null) {
                        boolean mode = (Boolean)this.parameters[1];
                        if (mode) {
                            ((TextTable)table).connect(session);
                        } else {
                            ((TextTable)table).disconnect();
                        }
                        session.database.setMetaDirty(false);
                        return Result.updateZeroResult;
                    }
                    String source = (String)this.parameters[2];
                    boolean isDesc = (Boolean)this.parameters[3];
                    boolean isHeader = (Boolean)this.parameters[4];
                    if (isHeader) {
                        ((TextTable)table).setHeader(source);
                    } else {
                        ((TextTable)table).setDataSource(session, source, isDesc, false);
                    }
                    return Result.updateZeroResult;
                }
                catch (Throwable e2) {
                    HsqlException e2;
                    if (!(e2 instanceof HsqlException)) {
                        e2 = Error.error(98, e2.getMessage());
                    }
                    if (session.isProcessingLog() || session.isProcessingScript()) {
                        session.addWarning(e2);
                        session.database.logger.logWarningEvent("Problem processing SET TABLE SOURCE", e2);
                        return Result.updateZeroResult;
                    }
                    return Result.newErrorResult(e2, this.sql);
                }
            }
            case 1071: {
                try {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)this.parameters[0];
                    int type = (Integer)this.parameters[1];
                    session.checkAdmin();
                    session.checkDDLWrite();
                    Table table = session.database.schemaManager.getUserTable(session, name.name, name.schema.name);
                    session.setScripting(true);
                    TableWorks tw = new TableWorks(session, table);
                    tw.setTableType(session, type);
                    session.database.setMetaDirty(false);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1042: {
                try {
                    User user = (User)this.parameters[0];
                    HsqlNameManager.HsqlName schema = (HsqlNameManager.HsqlName)this.parameters[1];
                    session.checkDDLWrite();
                    if (user == null) {
                        user = session.getUser();
                    } else {
                        session.checkAdmin();
                        session.checkDDLWrite();
                        user = session.database.userManager.get(user.getNameString());
                    }
                    if (schema != null) {
                        schema = session.database.schemaManager.getSchemaHsqlName(schema.name);
                    }
                    user.setInitialSchema(schema);
                    session.database.setMetaDirty(false);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
            case 1043: {
                try {
                    User user = this.parameters[0] == null ? session.getUser() : (User)this.parameters[0];
                    String password = (String)this.parameters[1];
                    session.checkDDLWrite();
                    session.setScripting(true);
                    user.setPassword(password);
                    return Result.updateZeroResult;
                }
                catch (HsqlException e) {
                    return Result.newErrorResult(e, this.sql);
                }
            }
        }
        throw Error.runtimeError(401, "StatemntCommand");
    }

    @Override
    public boolean isAutoCommitStatement() {
        return this.isTransactionStatement;
    }

    @Override
    public String describe(Session session) {
        return this.sql;
    }
}

