/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ParserDQL;
import org.hsqldb.RangeVariable;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.MultiValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;

public class RangeVariableResolver {
    RangeVariable[] rangeVariables;
    Expression conditions;
    OrderedHashSet rangeVarSet = new OrderedHashSet();
    ParserDQL.CompileContext compileContext;
    HsqlArrayList[] tempJoinExpressions;
    HsqlArrayList[] joinExpressions;
    HsqlArrayList[] whereExpressions;
    HsqlArrayList queryExpressions = new HsqlArrayList();
    Expression[] inExpressions;
    boolean[] flags;
    OrderedHashSet set = new OrderedHashSet();
    OrderedIntHashSet colIndexSetEqual = new OrderedIntHashSet();
    OrderedIntHashSet colIndexSetOther = new OrderedIntHashSet();
    MultiValueHashMap map = new MultiValueHashMap();
    int inExpressionCount = 0;
    boolean hasOuterJoin = false;

    RangeVariableResolver(RangeVariable[] rangeVars, Expression conditions, ParserDQL.CompileContext compileContext) {
        int i;
        this.rangeVariables = rangeVars;
        this.conditions = conditions;
        this.compileContext = compileContext;
        for (i = 0; i < rangeVars.length; ++i) {
            RangeVariable range = rangeVars[i];
            this.rangeVarSet.add(range);
            if (!range.isLeftJoin && !range.isRightJoin) continue;
            this.hasOuterJoin = true;
        }
        this.inExpressions = new Expression[rangeVars.length];
        this.flags = new boolean[rangeVars.length];
        this.tempJoinExpressions = new HsqlArrayList[rangeVars.length];
        for (i = 0; i < rangeVars.length; ++i) {
            this.tempJoinExpressions[i] = new HsqlArrayList();
        }
        this.joinExpressions = new HsqlArrayList[rangeVars.length];
        for (i = 0; i < rangeVars.length; ++i) {
            this.joinExpressions[i] = new HsqlArrayList();
        }
        this.whereExpressions = new HsqlArrayList[rangeVars.length];
        for (i = 0; i < rangeVars.length; ++i) {
            this.whereExpressions[i] = new HsqlArrayList();
        }
    }

    void processConditions() {
        RangeVariableResolver.decomposeCondition(this.conditions, this.queryExpressions);
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].nonIndexJoinCondition == null) continue;
            RangeVariableResolver.decomposeCondition(this.rangeVariables[i].nonIndexJoinCondition, this.tempJoinExpressions[i]);
            this.rangeVariables[i].nonIndexJoinCondition = null;
        }
        this.conditions = null;
        this.assignToLists();
        this.expandConditions();
        this.assignToRangeVariables();
        this.processFullJoins();
    }

    static Expression decomposeCondition(Expression e, HsqlArrayList conditions) {
        if (e == null) {
            return Expression.EXPR_TRUE;
        }
        Expression arg1 = e.getLeftNode();
        Expression arg2 = e.getRightNode();
        int type = e.getType();
        if (type == 49) {
            arg1 = RangeVariableResolver.decomposeCondition(arg1, conditions);
            arg2 = RangeVariableResolver.decomposeCondition(arg2, conditions);
            if (arg1 == Expression.EXPR_TRUE) {
                return arg2;
            }
            if (arg2 == Expression.EXPR_TRUE) {
                return arg1;
            }
            e.setLeftNode(arg1);
            e.setRightNode(arg2);
            return e;
        }
        if (type == 41 && arg1.getType() == 25 && arg2.getType() == 25) {
            for (int i = 0; i < arg1.nodes.length; ++i) {
                ExpressionLogical part = new ExpressionLogical(arg1.nodes[i], arg2.nodes[i]);
                ((Expression)part).resolveTypes(null, null);
                conditions.add(part);
            }
            return Expression.EXPR_TRUE;
        }
        if (e != Expression.EXPR_TRUE) {
            conditions.add(e);
        }
        return Expression.EXPR_TRUE;
    }

    void assignToLists() {
        int i;
        int lastOuterIndex = -1;
        int lastRightIndex = -1;
        for (i = 0; i < this.rangeVariables.length; ++i) {
            if (this.rangeVariables[i].isLeftJoin) {
                lastOuterIndex = i;
            }
            if (this.rangeVariables[i].isRightJoin) {
                lastOuterIndex = i;
                lastRightIndex = i;
            }
            if (lastOuterIndex == i) {
                this.joinExpressions[i].addAll(this.tempJoinExpressions[i]);
                continue;
            }
            for (int j = 0; j < this.tempJoinExpressions[i].size(); ++j) {
                this.assignToJoinLists((Expression)this.tempJoinExpressions[i].get(j), this.joinExpressions, lastOuterIndex + 1);
            }
        }
        for (i = 0; i < this.queryExpressions.size(); ++i) {
            this.assignToWhereLists((Expression)this.queryExpressions.get(i), this.whereExpressions, lastRightIndex);
        }
    }

    void assignToJoinLists(Expression e, HsqlArrayList[] expressionLists, int first) {
        this.set.clear();
        e.collectRangeVariables(this.rangeVariables, this.set);
        int index = this.rangeVarSet.getLargestIndex(this.set);
        if (index == -1) {
            index = 0;
        }
        if (this.set.size() == 1) {
            switch (e.getType()) {
                default: 
            }
        }
        if (index < first) {
            index = first;
        }
        expressionLists[index].add(e);
    }

    void assignToWhereLists(Expression e, HsqlArrayList[] expressionLists, int first) {
        this.set.clear();
        e.collectRangeVariables(this.rangeVariables, this.set);
        int index = this.rangeVarSet.getLargestIndex(this.set);
        if (index == -1) {
            index = 0;
        }
        if (index < first) {
            index = first;
        }
        expressionLists[index].add(e);
    }

    void expandConditions() {
        this.expandConditions(this.whereExpressions, false);
        this.expandConditions(this.joinExpressions, false);
    }

    void expandConditions(HsqlArrayList[] array, boolean isJoin) {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            HsqlArrayList list = array[i];
            this.map.clear();
            this.set.clear();
            boolean hasChain = false;
            for (int j = 0; j < list.size(); ++j) {
                Expression e = (Expression)list.get(j);
                if (!e.isColumnEqual || e.getLeftNode().getRangeVariable() == e.getRightNode().getRangeVariable()) continue;
                if (e.getLeftNode().getRangeVariable() == this.rangeVariables[i]) {
                    this.map.put(e.getLeftNode().getColumn(), e.getRightNode());
                    if (this.set.add(e.getLeftNode().getColumn())) continue;
                    hasChain = true;
                    continue;
                }
                this.map.put(e.getRightNode().getColumn(), e.getLeftNode());
                if (this.set.add(e.getRightNode().getColumn())) continue;
                hasChain = true;
            }
            if (!hasChain || this.hasOuterJoin && isJoin) continue;
            Iterator keyIt = this.map.keySet().iterator();
            while (keyIt.hasNext()) {
                Object key = keyIt.next();
                Iterator it = this.map.get(key);
                this.set.clear();
                while (it.hasNext()) {
                    this.set.add(it.next());
                }
                while (this.set.size() > 1) {
                    Expression e1 = (Expression)this.set.remove(this.set.size() - 1);
                    for (int j = 0; j < this.set.size(); ++j) {
                        Expression e2 = (Expression)this.set.get(j);
                        this.closeJoinChain(array, e1, e2);
                    }
                }
            }
        }
    }

    void closeJoinChain(HsqlArrayList[] array, Expression e1, Expression e2) {
        int idx2;
        int idx1 = this.rangeVarSet.getIndex(e1.getRangeVariable());
        int index = idx1 > (idx2 = this.rangeVarSet.getIndex(e2.getRangeVariable())) ? idx1 : idx2;
        array[index].add(new ExpressionLogical(e1, e2));
    }

    void assignToRangeVariables() {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            boolean isOuter;
            boolean bl = isOuter = this.rangeVariables[i].isLeftJoin || this.rangeVariables[i].isRightJoin;
            if (isOuter) {
                this.assignToRangeVariable(this.rangeVariables[i], i, this.joinExpressions[i], true);
                this.assignToRangeVariable(this.rangeVariables[i], i, this.whereExpressions[i], false);
            } else {
                this.joinExpressions[i].addAll(this.whereExpressions[i]);
                this.assignToRangeVariable(this.rangeVariables[i], i, this.joinExpressions[i], true);
            }
            if (!this.rangeVariables[i].hasIndexCondition() || this.inExpressions[i] == null) continue;
            if (!this.flags[i] && isOuter) {
                this.rangeVariables[i].addWhereCondition(this.inExpressions[i]);
            } else {
                this.rangeVariables[i].addJoinCondition(this.inExpressions[i]);
            }
            this.inExpressions[i] = null;
            --this.inExpressionCount;
        }
        if (this.inExpressionCount != 0) {
            this.setInConditionsAsTables();
        }
    }

    void assignToRangeVariable(RangeVariable rangeVar, int rangeVarIndex, HsqlArrayList exprList, boolean isJoin) {
        int[] cols;
        if (exprList.isEmpty()) {
            return;
        }
        this.colIndexSetEqual.clear();
        this.colIndexSetOther.clear();
        int size = exprList.size();
        block5: for (int j = 0; j < size; ++j) {
            Expression e = (Expression)exprList.get(j);
            if (rangeVar.hasIndexCondition()) {
                rangeVar.addCondition(e, isJoin);
                exprList.set(j, null);
                continue;
            }
            if (e.getIndexableExpression(rangeVar) == null) {
                rangeVar.addCondition(e, isJoin);
                exprList.set(j, null);
                continue;
            }
            int type = e.getType();
            switch (type) {
                default: {
                    int colIndex = e.getLeftNode().getColumnIndex();
                    this.colIndexSetOther.add(colIndex);
                    continue block5;
                }
                case 41: {
                    if (e.exprSubType == 52) {
                        Index index = rangeVar.rangeTable.getIndexForColumn(e.getLeftNode().nodes[0].getColumnIndex());
                        if (index != null && this.inExpressions[rangeVarIndex] == null) {
                            this.inExpressions[rangeVarIndex] = e;
                            ++this.inExpressionCount;
                        } else {
                            rangeVar.addCondition(e, isJoin);
                        }
                        exprList.set(j, null);
                        continue block5;
                    }
                }
                case 47: {
                    int colIndex = e.getLeftNode().getColumnIndex();
                    this.colIndexSetEqual.add(colIndex);
                    continue block5;
                }
                case 48: {
                    int colIndex = e.getLeftNode().getLeftNode().getColumnIndex();
                    this.colIndexSetOther.add(colIndex);
                    continue block5;
                }
            }
        }
        boolean isEqual = true;
        Index idx = rangeVar.rangeTable.getIndexForColumns(this.colIndexSetEqual);
        if (idx == null) {
            isEqual = false;
            idx = rangeVar.rangeTable.getIndexForColumns(this.colIndexSetOther);
        }
        if (idx == null && rangeVar.rangeTable.isSessionBased) {
            if (!this.colIndexSetEqual.isEmpty()) {
                cols = this.colIndexSetEqual.toArray();
                idx = rangeVar.rangeTable.getIndexForColumns(cols);
            }
            if (idx == null && !this.colIndexSetOther.isEmpty()) {
                cols = this.colIndexSetOther.toArray();
                idx = rangeVar.rangeTable.getIndexForColumns(cols);
            }
        }
        if (idx == null) {
            int size2 = exprList.size();
            for (int j = 0; j < size2; ++j) {
                Expression e = (Expression)exprList.get(j);
                if (e == null) continue;
                rangeVar.addCondition(e, isJoin);
            }
            return;
        }
        cols = idx.getColumns();
        int colCount = cols.length;
        if (isEqual && colCount > 1) {
            Expression[] firstRowExpressions = new Expression[cols.length];
            for (int j = 0; j < exprList.size(); ++j) {
                int offset;
                Expression e = (Expression)exprList.get(j);
                if (e == null) continue;
                int type = e.getType();
                if (type == 41 && (offset = ArrayUtil.find(cols, e.getLeftNode().getColumnIndex())) != -1 && firstRowExpressions[offset] == null) {
                    firstRowExpressions[offset] = e;
                    exprList.set(j, null);
                    continue;
                }
                rangeVar.addCondition(e, isJoin);
                exprList.set(j, null);
            }
            boolean hasNull = false;
            for (int i = 0; i < firstRowExpressions.length; ++i) {
                Expression e = firstRowExpressions[i];
                if (e == null) {
                    if (colCount == cols.length) {
                        colCount = i;
                    }
                    hasNull = true;
                    continue;
                }
                if (!hasNull) continue;
                rangeVar.addCondition(e, isJoin);
                firstRowExpressions[i] = null;
            }
            rangeVar.addIndexCondition(firstRowExpressions, idx, colCount, isJoin);
            return;
        }
        for (int j = 0; j < exprList.size(); ++j) {
            Expression e = (Expression)exprList.get(j);
            if (e == null) continue;
            if (rangeVar.hasIndexCondition()) {
                rangeVar.addCondition(e, isJoin);
                exprList.set(j, null);
                continue;
            }
            boolean isIndexed = false;
            if (e.getType() == 48 && cols[0] == e.getLeftNode().getLeftNode().getColumnIndex()) {
                isIndexed = true;
            }
            if (cols[0] == e.getLeftNode().getColumnIndex()) {
                if (e.getRightNode() != null && !e.getRightNode().isCorrelated()) {
                    isIndexed = true;
                }
                if (e.getType() == 47) {
                    isIndexed = true;
                }
            }
            if (isIndexed) {
                rangeVar.addIndexCondition(e, idx, isJoin);
            } else {
                rangeVar.addCondition(e, isJoin);
            }
            exprList.set(j, null);
        }
    }

    void setInConditionsAsTables() {
        for (int i = this.rangeVariables.length - 1; i >= 0; --i) {
            RangeVariable rangeVar = this.rangeVariables[i];
            Expression in = this.inExpressions[i];
            if (in == null) continue;
            Index index = rangeVar.rangeTable.getIndexForColumn(in.getLeftNode().nodes[0].getColumnIndex());
            RangeVariable newRangeVar = new RangeVariable(in.getRightNode().subQuery.getTable(), null, null, null, this.compileContext);
            RangeVariable[] newList = new RangeVariable[this.rangeVariables.length + 1];
            ArrayUtil.copyAdjustArray(this.rangeVariables, newList, newRangeVar, i, 1);
            this.rangeVariables = newList;
            ColumnSchema left = rangeVar.rangeTable.getColumn(in.getLeftNode().nodes[0].getColumnIndex());
            ColumnSchema right = newRangeVar.rangeTable.getColumn(0);
            ExpressionLogical e = new ExpressionLogical(rangeVar, left, newRangeVar, right);
            rangeVar.addIndexCondition(e, index, this.flags[i]);
            rangeVar.addCondition(in, true);
        }
    }

    void processFullJoins() {
        for (int i = 0; i < this.rangeVariables.length; ++i) {
            if (!this.rangeVariables[i].isRightJoin) continue;
        }
    }
}

