/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionOp;
import org.hsqldb.FunctionSQL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class ExpressionLogical
extends Expression {
    boolean noOptimisation;

    ExpressionLogical(int type) {
        super(type);
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(boolean b) {
        super(1);
        this.dataType = Type.SQL_BOOLEAN;
        this.valueData = b ? Boolean.TRUE : Boolean.FALSE;
    }

    ExpressionLogical(RangeVariable leftRangeVar, ColumnSchema left, RangeVariable rightRangeVar, ColumnSchema right) {
        super(41);
        ExpressionColumn leftExpression = new ExpressionColumn(leftRangeVar, left);
        ExpressionColumn rightExpression = new ExpressionColumn(rightRangeVar, right);
        this.nodes = new Expression[2];
        this.dataType = Type.SQL_BOOLEAN;
        this.nodes[0] = leftExpression;
        this.nodes[1] = rightExpression;
    }

    ExpressionLogical(Expression left, Expression right) {
        super(41);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        if (left.opType == 2 && right.opType == 2) {
            this.isColumnEqual = true;
        }
        this.dataType = Type.SQL_BOOLEAN;
    }

    ExpressionLogical(int type, Expression left, Expression right) {
        super(type);
        this.nodes = new Expression[2];
        this.nodes[0] = left;
        this.nodes[1] = right;
        switch (this.opType) {
            case 41: {
                if (left.opType == 2 && right.opType == 2) {
                    this.isColumnEqual = true;
                }
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 49: 
            case 50: 
            case 54: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionLogical");
            }
        }
    }

    ExpressionLogical(int type, Expression e) {
        super(type);
        this.nodes = new Expression[1];
        this.nodes[0] = e;
        switch (this.opType) {
            case 47: 
            case 48: 
            case 55: 
            case 57: {
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionLogical");
            }
        }
    }

    ExpressionLogical(ColumnSchema column) {
        super(48);
        this.nodes = new Expression[1];
        this.dataType = Type.SQL_BOOLEAN;
        Expression e = new ExpressionColumn(column);
        e = new ExpressionLogical(47, e);
        this.nodes[0] = e;
    }

    static Expression andExpressions(Expression e1, Expression e2) {
        if (e1 == null) {
            return e2;
        }
        if (e2 == null) {
            return e1;
        }
        return new ExpressionLogical(49, e1, e2);
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(64);
        if (this.opType == 1) {
            return super.getSQL();
        }
        String left = ExpressionLogical.getContextSQL(this.nodes[0]);
        String right = ExpressionLogical.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 48: {
                if (this.nodes[0].opType == 47) {
                    sb.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("NOT").append(' ').append("NULL");
                    return sb.toString();
                }
                if (this.nodes[0].opType == 58) {
                    sb.append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                    return sb.toString();
                }
                sb.append("NOT").append(' ').append(left);
                return sb.toString();
            }
            case 58: {
                sb.append("NOT").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[0])).append(' ').append("IS").append(' ').append("DISTINCT").append(' ').append("FROM").append(' ').append(ExpressionLogical.getContextSQL(this.nodes[0].nodes[1]));
                return sb.toString();
            }
            case 47: {
                sb.append(left).append(' ').append("IS").append(' ').append("NULL");
                return sb.toString();
            }
            case 57: {
                sb.append(' ').append("UNIQUE").append(' ');
                break;
            }
            case 55: {
                sb.append(' ').append("EXISTS").append(' ');
                break;
            }
            case 41: {
                sb.append(left).append('=').append(right);
                return sb.toString();
            }
            case 42: {
                sb.append(left).append(">=").append(right);
                return sb.toString();
            }
            case 43: {
                sb.append(left).append('>').append(right);
                return sb.toString();
            }
            case 44: {
                sb.append(left).append('<').append(right);
                return sb.toString();
            }
            case 45: {
                sb.append(left).append("<=").append(right);
                return sb.toString();
            }
            case 46: {
                if ("NULL".equals(right)) {
                    sb.append(left).append(" IS NOT ").append(right);
                } else {
                    sb.append(left).append("!=").append(right);
                }
                return sb.toString();
            }
            case 49: {
                sb.append(left).append(' ').append("AND").append(' ').append(right);
                return sb.toString();
            }
            case 50: {
                sb.append(left).append(' ').append("OR").append(' ').append(right);
                return sb.toString();
            }
            case 54: {
                sb.append(left).append(' ').append("IN").append(' ').append(right);
                return sb.toString();
            }
            case 59: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(right);
                return sb.toString();
            }
            case 60: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(469).append(right);
                return sb.toString();
            }
            case 61: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(115).append(right);
                return sb.toString();
            }
            case 62: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(297).append(right);
                return sb.toString();
            }
            case 63: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(297).append(' ').append(469).append(right);
                return sb.toString();
            }
            case 64: {
                sb.append(left).append(' ').append("MATCH").append(' ').append(297).append(' ').append(115).append(right);
                return sb.toString();
            }
            default: {
                throw Error.runtimeError(401, "ExpressionLogical");
            }
        }
        return sb.toString();
    }

    @Override
    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 1: {
                sb.append("VALUE = ").append(this.valueData);
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                return sb.toString();
            }
            case 48: {
                if (this.nodes[0].opType == 58) {
                    sb.append("DISTINCT");
                    return sb.toString();
                }
                sb.append("NOT ");
                break;
            }
            case 58: {
                sb.append("NOT ");
                sb.append("DISTINCT ");
                break;
            }
            case 41: {
                sb.append("EQUAL ");
                break;
            }
            case 42: {
                sb.append("GREATER_EQUAL ");
                break;
            }
            case 43: {
                sb.append("GREATER ");
                break;
            }
            case 44: {
                sb.append("SMALLER ");
                break;
            }
            case 45: {
                sb.append("SMALLER_EQUAL ");
                break;
            }
            case 46: {
                sb.append("NOT_EQUAL ");
                break;
            }
            case 49: {
                sb.append("AND ");
                break;
            }
            case 50: {
                sb.append("OR ");
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                sb.append("MATCH ");
                break;
            }
            case 47: {
                sb.append("IS_NULL ");
                break;
            }
            case 57: {
                sb.append("UNIQUE ");
                break;
            }
            case 55: {
                sb.append("EXISTS ");
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionLogical");
            }
        }
        if (this.nodes[0] != null) {
            sb.append(" arg_left=[");
            sb.append(this.nodes[0].describe(session, blanks + 1));
            sb.append(']');
        }
        if (this.nodes[1] != null) {
            sb.append(" arg_right=[");
            sb.append(this.nodes[1].describe(session, blanks + 1));
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 58: {
                this.resolveTypesForComparison(session, parent);
                break;
            }
            case 49: {
                Object value;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    Object value2 = this.nodes[0].getValue(session);
                    if (value2 != null && !Boolean.FALSE.equals(value2)) break;
                    this.setAsConstantValue(Boolean.FALSE);
                    break;
                }
                if (this.nodes[1].opType != 1 || (value = this.nodes[1].getValue(session)) != null && !Boolean.FALSE.equals(value)) break;
                this.setAsConstantValue(Boolean.FALSE);
                break;
            }
            case 50: {
                Object value;
                this.resolveTypesForLogicalOp();
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[1].opType == 1) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    Object value3 = this.nodes[0].getValue(session);
                    if (!Boolean.TRUE.equals(value3)) break;
                    this.setAsConstantValue(Boolean.TRUE);
                    break;
                }
                if (this.nodes[1].opType != 1 || !Boolean.TRUE.equals(value = this.nodes[1].getValue(session))) break;
                this.setAsConstantValue(Boolean.TRUE);
                break;
            }
            case 47: {
                if (this.nodes[0].isParam) {
                    throw Error.error(5565);
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session);
                break;
            }
            case 48: {
                if (this.nodes[0].isParam) {
                    this.nodes[0].dataType = Type.SQL_BOOLEAN;
                    break;
                }
                if (this.nodes[0].opType == 1) {
                    if (this.nodes[0].dataType.isBooleanType()) {
                        this.setAsConstantValue(session);
                        break;
                    }
                    throw Error.error(5565);
                }
                if (this.nodes[0].dataType == null || !this.nodes[0].dataType.isBooleanType()) {
                    throw Error.error(5565);
                }
                this.dataType = Type.SQL_BOOLEAN;
                break;
            }
            case 56: {
                this.resolveTypesForOverlaps();
                break;
            }
            case 54: {
                this.resolveTypesForIn(session);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                this.resolveTypesForAllAny(session);
                break;
            }
            case 55: 
            case 57: {
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionLogical");
            }
        }
    }

    private void resolveTypesForLogicalOp() {
        if (this.nodes[0].isParam) {
            this.nodes[0].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[1].isParam) {
            this.nodes[1].dataType = Type.SQL_BOOLEAN;
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5571);
        }
        if (this.nodes[0].opType == 25 || this.nodes[1].opType == 25 || Type.SQL_BOOLEAN != this.nodes[0].dataType || Type.SQL_BOOLEAN != this.nodes[1].dataType) {
            throw Error.error(5564);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveTypesForComparison(Session session, Expression parent) {
        if (this.exprSubType == 51 || this.exprSubType == 52) {
            this.resolveTypesForAllAny(session);
            return;
        }
        if (this.nodes[0].opType == 25 || this.nodes[1].opType == 25) {
            if (this.nodes[0].opType != 25 || this.nodes[1].opType != 25 || this.nodes[0].nodes.length != this.nodes[1].nodes.length) {
                throw Error.error(5564);
            }
            this.resolveRowTypes();
        } else {
            if (this.nodes[0].isParam) {
                this.nodes[0].dataType = this.nodes[1].dataType;
            } else if (this.nodes[1].isParam) {
                this.nodes[1].dataType = this.nodes[0].dataType;
            }
            if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
                throw Error.error(5567);
            }
            if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
                if (!this.convertDateTimeLiteral(session, this.nodes[0], this.nodes[1])) {
                    if (this.nodes[0].dataType.isBitType()) {
                        if (this.nodes[1].dataType.canConvertFrom(this.nodes[0].dataType)) {
                            this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], this.nodes[1].dataType);
                        }
                    } else {
                        if (!this.nodes[1].dataType.isBitType()) throw Error.error(5562);
                        if (this.nodes[0].dataType.canConvertFrom(this.nodes[1].dataType)) {
                            this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], this.nodes[0].dataType);
                        }
                    }
                }
            } else if (this.nodes[0].dataType.isDateTimeType() && this.nodes[0].dataType.isDateTimeTypeWithZone() ^ this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                this.nodes[0] = new ExpressionOp(this.nodes[0]);
            }
        }
        if (this.nodes[0].opType != 1 || this.nodes[1].opType != 1) return;
        this.setAsConstantValue(session);
    }

    private void resolveRowTypes() {
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type leftType = this.nodes[0].nodeDataTypes[i];
            Type rightType = this.nodes[1].nodeDataTypes[i];
            if (leftType.typeComparisonGroup != rightType.typeComparisonGroup) {
                throw Error.error(5562);
            }
            if (!leftType.isDateTimeType() || !(leftType.isDateTimeTypeWithZone() ^ rightType.isDateTimeTypeWithZone())) continue;
            this.nodes[0].nodes[i] = new ExpressionOp(this.nodes[0].nodes[i]);
            this.nodes[0].nodeDataTypes[i] = this.nodes[0].nodes[i].dataType;
        }
    }

    private boolean convertDateTimeLiteral(Session session, Expression a, Expression b) {
        if (!a.dataType.isDateTimeType()) {
            if (b.dataType.isDateTimeType()) {
                Expression c = a;
                a = b;
                b = c;
            } else {
                return false;
            }
        }
        if (a.dataType.isDateTimeTypeWithZone()) {
            return false;
        }
        if (b.opType == 1 && b.dataType.isCharacterType()) {
            b.valueData = a.dataType.castToType(session, b.valueData, b.dataType);
            b.dataType = a.dataType;
            return true;
        }
        return false;
    }

    void resolveTypesForOverlaps() {
        if (this.nodes[0].nodes[0].isParam) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[0].isParam) {
            this.nodes[1].nodes[0].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (this.nodes[0].nodes[0].dataType == null) {
            this.nodes[0].nodes[0].dataType = this.nodes[1].nodes[0].dataType = Type.SQL_TIMESTAMP;
        }
        if (this.nodes[0].nodes[1].isParam) {
            this.nodes[0].nodes[1].dataType = this.nodes[1].nodes[0].dataType;
        }
        if (this.nodes[1].nodes[1].isParam) {
            this.nodes[1].nodes[1].dataType = this.nodes[0].nodes[0].dataType;
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType) || !DTIType.isValidDatetimeRange(this.nodes[1].nodes[0].dataType, this.nodes[1].nodes[1].dataType)) {
            throw Error.error(5565);
        }
        if (!DTIType.isValidDatetimeRange(this.nodes[0].nodes[0].dataType, this.nodes[0].nodes[1].dataType)) {
            throw Error.error(5563);
        }
        this.nodes[0].nodeDataTypes[0] = this.nodes[0].nodes[0].dataType;
        this.nodes[0].nodeDataTypes[1] = this.nodes[0].nodes[1].dataType;
        this.nodes[1].nodeDataTypes[0] = this.nodes[1].nodes[0].dataType;
        this.nodes[1].nodeDataTypes[1] = this.nodes[1].nodes[1].dataType;
    }

    void resolveTypesForAllAny(Session session) {
        int degree = this.nodes[0].getDegree();
        if (degree == 1 && this.nodes[0].opType != 25) {
            this.nodes[0] = new Expression(25, new Expression[]{this.nodes[0]});
        }
        if (this.nodes[1].opType == 26) {
            this.nodes[1].prepareTable(session, this.nodes[0], degree);
            this.nodes[1].subQuery.prepareTable(session);
            if (this.nodes[1].isCorrelated) {
                this.nodes[1].subQuery.setCorrelated();
            }
        }
        if (degree != this.nodes[1].nodeDataTypes.length) {
            throw Error.error(5564);
        }
        if (this.nodes[1].opType == 26) {
            // empty if block
        }
        this.nodes[0].nodeDataTypes = new Type[this.nodes[0].nodes.length];
        for (int i = 0; i < this.nodes[0].nodeDataTypes.length; ++i) {
            Type type = this.nodes[0].nodes[i].dataType;
            if (type == null) {
                type = this.nodes[1].nodeDataTypes[i];
            }
            if (type == null) {
                throw Error.error(5567);
            }
            this.nodes[0].nodeDataTypes[i] = type;
        }
    }

    void resolveTypesForIn(Session session) {
        this.resolveTypesForAllAny(session);
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object[] data = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
                return data[this.columnIndex];
            }
            case 31: {
                return ((NumberType)this.dataType).negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
            case 47: {
                return this.nodes[0].getValue(session) == null ? Boolean.TRUE : Boolean.FALSE;
            }
            case 56: {
                Object[] left = this.nodes[0].getRowValue(session);
                Object[] right = this.nodes[1].getRowValue(session);
                return DateTimeType.overlaps(session, left, this.nodes[0].nodeDataTypes, right, this.nodes[1].nodeDataTypes);
            }
            case 54: {
                return this.testInCondition(session, this.nodes[0].getRowValue(session));
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return this.testMatchCondition(session, this.nodes[0].getRowValue(session));
            }
            case 57: {
                this.nodes[0].subQuery.materialiseCorrelated(session);
                return this.nodes[0].subQuery.hasUniqueNotNullRows(session) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 55: {
                return this.testExistsCondition(session);
            }
            case 48: {
                Boolean result = (Boolean)this.nodes[0].getValue(session);
                return result == null ? null : (result != false ? Boolean.FALSE : Boolean.TRUE);
            }
            case 49: {
                Boolean r1 = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.FALSE.equals(r1)) {
                    return Boolean.FALSE;
                }
                Boolean r2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.FALSE.equals(r2)) {
                    return Boolean.FALSE;
                }
                if (r1 == null || r2 == null) {
                    return null;
                }
                return Boolean.TRUE;
            }
            case 50: {
                Boolean r1 = (Boolean)this.nodes[0].getValue(session);
                if (Boolean.TRUE.equals(r1)) {
                    return Boolean.TRUE;
                }
                Boolean r2 = (Boolean)this.nodes[1].getValue(session);
                if (Boolean.TRUE.equals(r2)) {
                    return Boolean.TRUE;
                }
                if (r1 == null || r2 == null) {
                    return null;
                }
                return Boolean.FALSE;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 58: {
                if (this.exprSubType == 52 || this.exprSubType == 51) {
                    return this.testAllAnyCondition(session, this.nodes[0].getRowValue(session));
                }
                Object o1 = this.nodes[0].getValue(session);
                Object o2 = this.nodes[1].getValue(session);
                if (o1 instanceof Object[]) {
                    return this.compareValues(session, (Object[])o1, (Object[])o2);
                }
                return this.compareValues(session, o1, o2);
            }
        }
        throw Error.runtimeError(401, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object left, Object right) {
        int result = 0;
        if (left == null || right == null) {
            return null;
        }
        result = this.nodes[0].dataType.compare(session, left, right);
        switch (this.opType) {
            case 41: {
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                return result != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                return result > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                return result >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                return result <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                return result < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(401, "ExpressionLogical");
    }

    private Boolean compareValues(Session session, Object[] left, Object[] right) {
        int result = 0;
        boolean hasNull = false;
        if (left == null || right == null) {
            return null;
        }
        Object[] leftList = left;
        Object[] rightList = right;
        for (int i = 0; i < this.nodes[0].nodes.length; ++i) {
            Object rightValue;
            Object leftValue;
            Type[] types;
            if (leftList[i] == null) {
                if (this.opType == 60 || this.opType == 63) continue;
                hasNull = true;
            }
            if (rightList[i] == null) {
                hasNull = true;
            }
            if ((result = (types = this.nodes[0].nodeDataTypes)[i].compare(session, leftValue = leftList[i], rightValue = rightList[i])) != 0) break;
        }
        switch (this.opType) {
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 41: 
            case 54: {
                if (hasNull) {
                    return null;
                }
                return result == 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 46: {
                if (hasNull) {
                    return null;
                }
                return result != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 43: {
                if (hasNull) {
                    return null;
                }
                return result > 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 42: {
                if (hasNull) {
                    return null;
                }
                return result >= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 45: {
                if (hasNull) {
                    return null;
                }
                return result <= 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 44: {
                if (hasNull) {
                    return null;
                }
                return result < 0 ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        throw Error.runtimeError(401, "ExpressionLogical");
    }

    private Boolean testInCondition(Session session, Object[] data) {
        if (data == null) {
            return null;
        }
        if (Expression.countNulls(data) != 0) {
            return null;
        }
        if (this.nodes[1].opType == 26) {
            int length = this.nodes[1].nodes.length;
            for (int i = 0; i < length; ++i) {
                Object[] rowData = this.nodes[1].nodes[i].getRowValue(session);
                if (!Boolean.TRUE.equals(this.compareValues(session, data, rowData))) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        throw Error.runtimeError(401, "ExpressionLogical");
    }

    private Boolean testMatchCondition(Session session, Object[] data) {
        if (data == null) {
            return Boolean.TRUE;
        }
        int nulls = ExpressionLogical.countNulls(data);
        if (nulls != 0) {
            switch (this.opType) {
                case 59: 
                case 62: {
                    return Boolean.TRUE;
                }
                case 60: 
                case 63: {
                    if (nulls != data.length) break;
                    return Boolean.TRUE;
                }
                case 61: 
                case 64: {
                    return nulls == data.length ? Boolean.TRUE : Boolean.FALSE;
                }
            }
        }
        if (this.nodes[1].opType == 26) {
            int length = this.nodes[1].nodes.length;
            boolean hasMatch = false;
            for (int i = 0; i < length; ++i) {
                Object[] rowData = this.nodes[1].nodes[i].getRowValue(session);
                Boolean result = this.compareValues(session, data, rowData);
                if (result == null || !result.booleanValue()) continue;
                switch (this.opType) {
                    case 59: 
                    case 60: 
                    case 61: {
                        return Boolean.TRUE;
                    }
                    case 62: 
                    case 63: 
                    case 64: {
                        if (hasMatch) {
                            return Boolean.FALSE;
                        }
                        hasMatch = true;
                    }
                }
            }
            return hasMatch ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.nodes[1].opType == 23) {
            PersistentStore store = session.sessionData.getRowStore(this.nodes[1].subQuery.getTable());
            this.nodes[1].subQuery.materialiseCorrelated(session);
            ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
            if (nulls != 0 && (this.opType == 60 || this.opType == 63)) {
                boolean hasMatch = false;
                RowIterator it = this.nodes[1].subQuery.getTable().rowIterator(session);
                while (it.hasNext()) {
                    Object[] rowData = it.getNextRow().getData();
                    Boolean result = this.compareValues(session, data, rowData);
                    if (result == null || !result.booleanValue()) continue;
                    if (this.opType == 60) {
                        return Boolean.TRUE;
                    }
                    if (hasMatch) {
                        return Boolean.FALSE;
                    }
                    hasMatch = true;
                }
                return hasMatch ? Boolean.TRUE : Boolean.FALSE;
            }
            RowIterator it = this.nodes[1].subQuery.getTable().getPrimaryIndex().findFirstRow(session, store, data);
            boolean result = it.hasNext();
            if (!result) {
                return Boolean.FALSE;
            }
            switch (this.opType) {
                case 59: 
                case 60: 
                case 61: {
                    return Boolean.TRUE;
                }
            }
            it.getNextRow();
            result = it.hasNext();
            if (!result) {
                return Boolean.TRUE;
            }
            Object[] rowData = it.getNextRow().getData();
            Boolean returnValue = Boolean.TRUE.equals(this.compareValues(session, data, rowData)) ? Boolean.FALSE : Boolean.TRUE;
            return returnValue;
        }
        throw Error.error(5564);
    }

    private Boolean testExistsCondition(Session session) {
        SubQuery subQuery = this.nodes[0].subQuery;
        if (subQuery.isCorrelated()) {
            subQuery.materialiseCorrelated(session);
        }
        return subQuery.getTable().isEmpty(session) ? Boolean.FALSE : Boolean.TRUE;
    }

    private Boolean testAllAnyCondition(Session session, Object[] o) {
        SubQuery subquery = this.nodes[1].subQuery;
        subquery.materialiseCorrelated(session);
        Boolean result = this.getAllAnyValue(session, o, subquery);
        return result;
    }

    private Boolean getAllAnyValue(Session session, Object[] data, SubQuery subquery) {
        TableDerived table = subquery.getTable();
        boolean empty = table.isEmpty(session);
        Index index = table.getFullIndex();
        PersistentStore store = session.sessionData.getRowStore(table);
        Row lastrow = index.lastRow(session, store);
        switch (this.exprSubType) {
            case 52: {
                if (empty) {
                    return Boolean.FALSE;
                }
                if (ExpressionLogical.countNulls(data) == data.length) {
                    return null;
                }
                Object[] lastdata = lastrow.getData();
                if (ExpressionLogical.countNulls(lastdata) == data.length) {
                    return null;
                }
                ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                if (this.opType == 41) {
                    RowIterator it = index.findFirstRow(session, store, data);
                    return it.hasNext() ? Boolean.TRUE : Boolean.FALSE;
                }
                RowIterator it = index.findFirstRowNotNull(session, store);
                Row firstrow = it.getNextRow();
                Object[] firstdata = firstrow.getData();
                Boolean comparefirst = this.compareValues(session, data, firstdata);
                Boolean comparelast = this.compareValues(session, data, lastdata);
                switch (this.opType) {
                    case 46: {
                        return Boolean.TRUE.equals(comparefirst) || Boolean.TRUE.equals(comparelast) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    case 43: {
                        return comparefirst;
                    }
                    case 42: {
                        return comparefirst;
                    }
                    case 44: {
                        return comparelast;
                    }
                    case 45: {
                        return comparelast;
                    }
                }
                break;
            }
            case 51: {
                if (empty) {
                    return Boolean.TRUE;
                }
                if (ExpressionLogical.countNulls(data) == data.length) {
                    return null;
                }
                RowIterator it = index.firstRow(session, store);
                Row firstrow = it.getNextRow();
                Object[] firstdata = firstrow.getData();
                if (ExpressionLogical.countNulls(firstdata) == data.length) {
                    return null;
                }
                ExpressionLogical.convertToType(session, data, this.nodes[0].nodeDataTypes, this.nodes[1].nodeDataTypes);
                it = index.findFirstRow(session, store, data);
                if (this.opType == 41) {
                    if (it.hasNext()) {
                        return subquery.getTable().getRowCount(store) == 1 ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return Boolean.FALSE;
                }
                if (this.opType == 46) {
                    return it.hasNext() ? Boolean.FALSE : Boolean.TRUE;
                }
                Object[] lastdata = lastrow.getData();
                Boolean comparefirst = this.compareValues(session, data, firstdata);
                Boolean comparelast = this.compareValues(session, data, lastdata);
                switch (this.opType) {
                    case 43: {
                        return comparelast;
                    }
                    case 42: {
                        return comparelast;
                    }
                    case 44: {
                        return comparefirst;
                    }
                    case 45: {
                        return comparefirst;
                    }
                }
                break;
            }
        }
        return null;
    }

    void distributeOr() {
        if (this.opType != 50) {
            return;
        }
        if (this.nodes[0].opType == 49) {
            this.opType = 49;
            ExpressionLogical temp = new ExpressionLogical(50, this.nodes[0].nodes[1], this.nodes[1]);
            this.nodes[0].opType = 50;
            this.nodes[0].nodes[1] = this.nodes[1];
            this.nodes[1] = temp;
        } else if (this.nodes[1].opType == 49) {
            Expression temp = this.nodes[0];
            this.nodes[0] = this.nodes[1];
            this.nodes[1] = temp;
            this.distributeOr();
            return;
        }
        ((ExpressionLogical)this.nodes[0]).distributeOr();
        ((ExpressionLogical)this.nodes[1]).distributeOr();
    }

    @Override
    Expression getIndexableExpression(RangeVariable rangeVar) {
        switch (this.opType) {
            case 47: {
                return this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar ? this : null;
            }
            case 48: {
                return this.nodes[0].opType == 47 && this.nodes[0].nodes[0].opType == 2 && this.nodes[0].nodes[0].getRangeVariable() == rangeVar ? this : null;
            }
            case 41: {
                if (this.exprSubType == 52) {
                    if (this.nodes[1].isCorrelated) {
                        return null;
                    }
                    return this.nodes[0].nodes[0].opType == 2 && this.nodes[0].nodes[0].getRangeVariable() == rangeVar ? this : null;
                }
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (this.exprSubType != 0) {
                    return null;
                }
                if (this.nodes[0].opType == 2 && this.nodes[0].getRangeVariable() == rangeVar) {
                    if (this.nodes[1].hasReference(rangeVar)) {
                        return null;
                    }
                    return this;
                }
                if (this.nodes[1].opType != 2 || this.nodes[1].getRangeVariable() != rangeVar) break;
                this.swapCondition();
                if (this.nodes[1].hasReference(rangeVar)) {
                    return null;
                }
                return this;
            }
        }
        return null;
    }

    boolean isSimpleBound() {
        if (this.opType == 47) {
            return true;
        }
        if (this.nodes[1] != null) {
            if (this.nodes[1].opType == 1) {
                return true;
            }
            if (this.nodes[1].opType == 28 && ((FunctionSQL)this.nodes[1]).isValueFunction()) {
                return true;
            }
        }
        return false;
    }

    void swapCondition() {
        int i = 41;
        switch (this.opType) {
            case 42: {
                i = 45;
                break;
            }
            case 45: {
                i = 42;
                break;
            }
            case 44: {
                i = 43;
                break;
            }
            case 43: {
                i = 44;
                break;
            }
            case 58: {
                i = 58;
                break;
            }
            case 41: {
                break;
            }
            default: {
                throw Error.runtimeError(401, "ExpressionLogical");
            }
        }
        this.opType = i;
        Expression e = this.nodes[0];
        this.nodes[0] = this.nodes[1];
        this.nodes[1] = e;
    }

    boolean reorderComparison(Session session) {
        Expression colExpression = null;
        Expression nonColExpression = null;
        boolean left = false;
        boolean replaceColumn = false;
        int operation = 0;
        if (this.nodes[0].opType == 32) {
            operation = 33;
            left = true;
        } else if (this.nodes[0].opType == 33) {
            operation = 32;
            left = true;
        } else if (this.nodes[1].opType == 32) {
            operation = 33;
        } else if (this.nodes[1].opType == 33) {
            operation = 32;
        }
        if (operation == 0) {
            return false;
        }
        if (left) {
            if (this.nodes[0].nodes[0].opType == 2) {
                colExpression = this.nodes[0].nodes[0];
                nonColExpression = this.nodes[0].nodes[1];
            } else if (this.nodes[0].nodes[1].opType == 2) {
                replaceColumn = operation == 32;
                colExpression = this.nodes[0].nodes[1];
                nonColExpression = this.nodes[0].nodes[0];
            }
        } else if (this.nodes[1].nodes[0].opType == 2) {
            colExpression = this.nodes[1].nodes[0];
            nonColExpression = this.nodes[1].nodes[1];
        } else if (this.nodes[1].nodes[1].opType == 2) {
            replaceColumn = operation == 32;
            colExpression = this.nodes[1].nodes[1];
            nonColExpression = this.nodes[1].nodes[0];
        }
        if (colExpression == null) {
            return false;
        }
        Expression otherExpression = left ? this.nodes[1] : this.nodes[0];
        ExpressionArithmetic newArg = null;
        if (!replaceColumn) {
            newArg = new ExpressionArithmetic(operation, otherExpression, nonColExpression);
            newArg.resolveTypesForArithmetic(session);
        }
        if (left) {
            if (replaceColumn) {
                this.nodes[1] = colExpression;
                this.nodes[0].nodes[1] = otherExpression;
                ((ExpressionArithmetic)this.nodes[0]).resolveTypesForArithmetic(session);
            } else {
                this.nodes[0] = colExpression;
                this.nodes[1] = newArg;
            }
        } else if (replaceColumn) {
            this.nodes[0] = colExpression;
            this.nodes[1].nodes[1] = otherExpression;
            ((ExpressionArithmetic)this.nodes[1]).resolveTypesForArithmetic(session);
        } else {
            this.nodes[1] = colExpression;
            this.nodes[0] = newArg;
        }
        return true;
    }
}

