package de.ugoe.cs.swe.memos.tests;

//TODO: This tests will delete the settings file and replace it with a default one.

import static org.junit.Assert.*;

import java.io.File;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.swe.memos.SettingsManager;

public class SettingsManagerTest {
	File settingsFile = new File(System.getProperty("user.home") + System.getProperty("file.separator") +  ".snm");

	@Before
	public void setUp() throws Exception {
	}
	
	@Test
	public void readTest() {
		settingsFile.delete();
		assertFalse(settingsFile.exists());
		SettingsManager man = SettingsManager.getInstance();
		//assertTrue(settingsFile.exists());
		assertEquals("xprakt2", man.getUsername());
		assertEquals("huttraeger", man.getPassword());
	}
	
	@Test
	public void changeTest() {
		SettingsManager man = SettingsManager.getInstance();
		man.setPassword("muhaha");
		assertEquals("muhaha", man.getPassword());
		man.setDatabaseURI("willnotwork");
		assertEquals("willnotwork", man.getDatabaseURI());
		man.setExport_Path("over_bombay_to_usa");
		assertEquals("over_bombay_to_usa", man.getExport_Path());
		man.setImport_Path("import");
		assertEquals("import", man.getImport_Path());
		man.setUsername("asd");
		
	}
	
	@After
	public void tearDown() {
		settingsFile.delete();
		SettingsManager.getInstance().loadSettingsFromFile();
	}

}
