/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLHybrid
extends RowStoreAVL
implements PersistentStore {
    final TableBase table;
    final Session session;
    DataFileCacheSession cache;
    private int maxMemoryRowCount;
    private int memoryRowCount;
    private boolean useCache;
    private boolean isCached;
    private final boolean isTempTable;
    private IntKeyHashMapConcurrent rowIdMap;
    int rowIdSequence = 0;

    public RowStoreAVLHybrid(Session session, PersistentStoreCollection manager, TableBase table, boolean useCache) {
        this.session = session;
        this.manager = manager;
        this.table = table;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.isTempTable = table.getTableType() == 2;
        this.useCache = useCache;
        if (this.isTempTable) {
            this.rowIdMap = new IntKeyHashMapConcurrent();
        }
        if (table.getTableType() == 8) {
            this.timestamp = session.getActionTimestamp();
        }
        this.resetAccessorKeys(table.getIndexList());
        manager.setStore(table, this);
    }

    @Override
    public boolean isMemory() {
        return !this.isCached;
    }

    @Override
    public int getAccessCount() {
        return this.isCached ? this.cache.getAccessCount() : 0;
    }

    @Override
    public void set(CachedObject object) {
    }

    @Override
    public CachedObject get(int i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, false);
            }
            return (CachedObject)this.rowIdMap.get(i);
        }
        catch (HsqlException e) {
            return null;
        }
    }

    @Override
    public CachedObject getKeep(int i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, true);
            }
            return (CachedObject)this.rowIdMap.get(i);
        }
        catch (HsqlException e) {
            return null;
        }
    }

    @Override
    public CachedObject get(int i, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, keep);
            }
            return (CachedObject)this.rowIdMap.get(i);
        }
        catch (HsqlException e) {
            return null;
        }
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        try {
            if (this.isCached) {
                return this.cache.get(object, (PersistentStore)this, keep);
            }
            return object;
        }
        catch (HsqlException e) {
            return null;
        }
    }

    @Override
    public int getStorageSize(int i) {
        try {
            if (this.isCached) {
                return this.cache.get(i, (PersistentStore)this, false).getStorageSize();
            }
            return 0;
        }
        catch (HsqlException e) {
            return 0;
        }
    }

    @Override
    public void add(CachedObject object) {
        if (this.isCached) {
            int size = object.getRealSize(this.cache.rowOut);
            size = this.cache.rowOut.getStorageSize(size);
            object.setStorageSize(size);
            this.cache.add(object);
        }
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            if (this.isCached) {
                return new RowAVLDisk(this.table, in);
            }
        }
        catch (HsqlException e) {
            return null;
        }
        catch (IOException e1) {
            return null;
        }
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object) {
        if (this.isCached) {
            RowAVLDisk row = new RowAVLDisk(this.table, (Object[])object);
            this.add(row);
            if (this.isTempTable) {
                RowAction.addAction(session, (byte)1, (Table)this.table, row);
            }
            return row;
        }
        ++this.memoryRowCount;
        if (this.useCache && this.memoryRowCount > this.maxMemoryRowCount) {
            this.changeToDiskTable();
            return this.getNewCachedObject(session, object);
        }
        RowAVL row = new RowAVL(this.table, (Object[])object);
        int id = this.rowIdSequence++;
        row.setPos(id);
        if (this.rowIdMap != null) {
            this.rowIdMap.put(id, row);
        }
        if (this.isTempTable) {
            RowAction.addAction(session, (byte)1, (Table)this.table, row);
        }
        return row;
    }

    @Override
    public void removeAll() {
        if (!this.isCached && this.rowIdMap != null) {
            this.rowIdMap.clear();
        }
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int i) {
        if (this.isCached) {
            this.cache.remove(i, this);
        } else if (this.rowIdMap != null) {
            this.rowIdMap.remove(i);
        }
    }

    @Override
    public void removePersistence(int i) {
    }

    @Override
    public void release(int i) {
        if (this.isCached) {
            this.cache.release(i);
        }
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        throw Error.runtimeError(401, "RowStoreAVLHybrid");
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        if (this.isCached) {
            --this.cache.storeCount;
            if (this.cache.storeCount == 0) {
                this.cache.clear();
            }
            this.cache = null;
            this.isCached = false;
        } else if (this.rowIdMap != null) {
            this.rowIdMap.clear();
        }
        this.manager.setStore(this.table, null);
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
        Index index = key;
        this.accessorList[index.getPosition()] = accessor;
    }

    @Override
    public void setAccessor(Index key, int accessor) {
    }

    @Override
    public void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.indexList[0] == null || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(401, "RowStoreAVLHybrid");
    }

    public void changeToDiskTable() {
        this.cache = this.session.sessionData.getResultCache();
        if (this.cache != null) {
            RowIterator iterator = this.table.rowIterator(this);
            ArrayUtil.fillArray(this.accessorList, null);
            this.isCached = true;
            ++this.cache.storeCount;
            while (iterator.hasNext()) {
                Row row = iterator.getNextRow();
                Row newRow = (Row)this.getNewCachedObject(this.session, row.getData());
                this.indexRow(null, newRow);
            }
            if (this.rowIdMap != null) {
                this.rowIdMap.clear();
            }
        }
        this.maxMemoryRowCount = Integer.MAX_VALUE;
    }

    @Override
    public CachedObject getNewInstance(int size) {
        return null;
    }
}

