/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HsqlHeap;
import org.hsqldb.lib.ObjectComparator;

public class HsqlArrayHeap
implements HsqlHeap {
    protected ObjectComparator oc;
    protected int count;
    protected Object[] heap;

    public HsqlArrayHeap(int capacity, ObjectComparator comparator) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException("" + capacity);
        }
        if (comparator == null) {
            throw new IllegalArgumentException("null comparator");
        }
        this.heap = new Object[capacity];
        this.oc = comparator;
    }

    @Override
    public synchronized void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.heap[i] = null;
        }
        this.count = 0;
    }

    @Override
    public synchronized void add(Object o) throws IllegalArgumentException, RuntimeException {
        if (o == null) {
            throw new IllegalArgumentException("null element");
        }
        if (this.isFull()) {
            throw new RuntimeException("full");
        }
        if (this.count >= this.heap.length) {
            this.increaseCapacity();
        }
        int ci = this.count++;
        while (ci > 0) {
            int pi = ci - 1 >> 1;
            try {
                if (this.oc.compare(o, this.heap[pi]) >= 0) {
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.toString());
            }
            this.heap[ci] = this.heap[pi];
            ci = pi;
        }
        this.heap[ci] = o;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public synchronized boolean isFull() {
        return this.count == Integer.MAX_VALUE;
    }

    @Override
    public synchronized Object peek() {
        return this.heap[0];
    }

    @Override
    public synchronized Object remove() {
        int li;
        if (this.count == 0) {
            return null;
        }
        int ci = 0;
        Object ro = this.heap[ci];
        --this.count;
        if (this.count == 0) {
            this.heap[0] = null;
            return ro;
        }
        Object co = this.heap[this.count];
        this.heap[this.count] = null;
        while ((li = (ci << 1) + 1) < this.count) {
            int chi;
            int ri = (ci << 1) + 2;
            int n = chi = ri >= this.count || this.oc.compare(this.heap[li], this.heap[ri]) < 0 ? li : ri;
            if (this.oc.compare(co, this.heap[chi]) <= 0) break;
            this.heap[ci] = this.heap[chi];
            ci = chi;
        }
        this.heap[ci] = co;
        return ro;
    }

    @Override
    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" : size=");
        sb.append(this.count);
        sb.append(' ');
        sb.append('[');
        for (int i = 0; i < this.count; ++i) {
            sb.append(this.heap[i]);
            if (i + 1 >= this.count) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void increaseCapacity() {
        Object[] oldheap = this.heap;
        this.heap = new Object[3 * this.heap.length / 2 + 1];
        System.arraycopy(oldheap, 0, this.heap, 0, this.count);
    }
}

