/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.OrderedHashSet;

public class TriggerDefSQL
extends TriggerDef {
    OrderedHashSet references;

    public TriggerDefSQL(HsqlNameManager.HsqlName name, String when, String operation, boolean forEachRow, Table table, Table[] transitions, RangeVariable[] rangeVars, Expression condition, String conditionSQL, int[] updateColumns, StatementDMQL[] compiledStatements, String procedureSQL, OrderedHashSet references) {
        super(name, when, operation, forEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumns);
        this.statements = compiledStatements;
        this.procedureSQL = procedureSQL;
        this.references = references;
    }

    @Override
    public OrderedHashSet getReferences() {
        return this.references;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getClassName() {
        return null;
    }

    @Override
    public boolean hasOldTable() {
        return this.transitions[2] != null;
    }

    @Override
    public boolean hasNewTable() {
        return this.transitions[3] != null;
    }

    @Override
    synchronized void pushPair(Session session, Object[] oldData, Object[] newData) {
        if (this.transitions[0] != null) {
            this.rangeVars[0].getIterator((Session)session).currentData = oldData;
        }
        if (this.transitions[1] != null) {
            this.rangeVars[1].getIterator((Session)session).currentData = newData;
        }
        if (!this.condition.testCondition(session)) {
            return;
        }
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i].execute(session);
        }
    }

    @Override
    public String getSQL() {
        boolean isBlock = this.statements.length > 1;
        StringBuffer sb = this.getSQLMain();
        if (isBlock) {
            sb.append("BEGIN").append(' ').append("ATOMIC");
            sb.append(' ');
        }
        sb.append(this.procedureSQL).append(' ');
        if (isBlock) {
            sb.append("END");
        }
        return sb.toString();
    }
}

