/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ParserDQL;
import org.hsqldb.Routine;
import org.hsqldb.Session;
import org.hsqldb.StatementDMQL;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.store.ValuePool;

public class StatementProcedure
extends StatementDMQL {
    Expression expression;
    Routine procedure;
    Expression[] arguments;
    ResultMetaData resultMetaData;

    StatementProcedure(Session session, Expression expression, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        this.expression = expression;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementProcedure(Session session, Routine procedure, Expression[] arguments, ParserDQL.CompileContext compileContext) {
        super(7, 2003, session.getCurrentSchemaHsqlName());
        this.procedure = procedure;
        this.arguments = arguments;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        return this.expression == null ? this.getProcedureResult(session) : this.getExpressionResult(session);
    }

    Result getProcedureResult(Session session) {
        Result result;
        Object[] data = ValuePool.emptyObjectArray;
        if (this.arguments.length > 0) {
            data = new Object[this.arguments.length];
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Expression e = this.arguments[i];
            if (e == null) continue;
            data[i] = e.getValue(session, e.dataType);
        }
        int variableCount = this.procedure.getVariableCount();
        session.sessionContext.push();
        session.sessionContext.routineArguments = data;
        session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
        if (variableCount > 0) {
            session.sessionContext.routineVariables = new Object[variableCount];
        }
        if (!(result = this.procedure.statement.execute(session)).isError()) {
            result = Result.updateZeroResult;
        }
        Object[] callArguments = session.sessionContext.routineArguments;
        session.sessionContext.pop();
        if (result.isError()) {
            return result;
        }
        boolean returnParams = false;
        for (int i = 0; i < this.procedure.getParameterCount(); ++i) {
            ColumnSchema param = this.procedure.getParameter(i);
            byte mode = param.getParameterMode();
            if (mode == 1) continue;
            if (this.arguments[i].isParam) {
                int paramIndex = this.arguments[i].parameterIndex;
                session.sessionContext.dynamicArguments[paramIndex] = callArguments[i];
                returnParams = true;
                continue;
            }
            int varIndex = this.arguments[i].getColumnIndex();
            session.sessionContext.routineVariables[varIndex] = callArguments[i];
        }
        if (returnParams) {
            result = Result.newCallResponse(this.getParametersMetaData().getParameterTypes(), this.id, session.sessionContext.dynamicArguments);
        }
        return result;
    }

    Result getExpressionResult(Session session) {
        session.sessionData.startRowProcessing();
        Object o = this.expression.getValue(session);
        if (o instanceof Result) {
            return (Result)o;
        }
        if (this.resultMetaData == null) {
            this.getResultMetaData();
        }
        Result r = Result.newSingleColumnResult(this.resultMetaData);
        Object[] row = new Object[]{o};
        r.getNavigator().add(row);
        return r;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        if (this.resultMetaData != null) {
            return this.resultMetaData;
        }
        switch (this.type) {
            case 7: {
                if (this.expression == null) {
                    return ResultMetaData.emptyResultMetaData;
                }
                ResultMetaData md = ResultMetaData.newResultMetaData(1);
                ColumnBase column = new ColumnBase(null, null, null, "@p0");
                column.setType(this.expression.getDataType());
                md.columns[0] = column;
                md.prepareData();
                this.resultMetaData = md;
                return md;
            }
        }
        throw Error.runtimeError(401, "StatementProcedure");
    }

    @Override
    public ResultMetaData getParametersMetaData() {
        return super.getParametersMetaData();
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
    }
}

