/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserDQL;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.TriggerDef;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorLinkedList;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementDML
extends StatementDMQL {
    public StatementDML(int type, int group, HsqlNameManager.HsqlName schemaName) {
        super(type, group, schemaName);
    }

    StatementDML(Session session, Table targetTable, RangeVariable[] rangeVars, ParserDQL.CompileContext compileContext, boolean restartIdentity) {
        super(19, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable();
        this.targetRangeVariables = rangeVars;
        this.restartIdentity = restartIdentity;
        this.isTransactionStatement = true;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementDML(Session session, Table targetTable, RangeVariable[] rangeVars, int[] updateColumnMap, Expression[] colExpressions, boolean[] checkColumns, ParserDQL.CompileContext compileContext) {
        super(82, 2004, session.getCurrentSchemaHsqlName());
        this.targetTable = targetTable;
        this.baseTable = targetTable.getBaseTable();
        this.updateColumnMap = updateColumnMap;
        this.updateExpressions = colExpressions;
        this.updateCheckColumns = checkColumns;
        this.targetRangeVariables = rangeVars;
        this.isTransactionStatement = true;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementDML(Session session, RangeVariable[] targetRangeVars, int[] insertColMap, int[] updateColMap, boolean[] checkColumns, Expression mergeCondition, Expression insertExpr, Expression[] updateExpr, ParserDQL.CompileContext compileContext) {
        super(128, 2004, session.getCurrentSchemaHsqlName());
        this.sourceTable = targetRangeVars[0].rangeTable;
        this.targetTable = targetRangeVars[1].rangeTable;
        this.baseTable = this.targetTable.getBaseTable();
        this.insertCheckColumns = checkColumns;
        this.insertColumnMap = insertColMap;
        this.updateColumnMap = updateColMap;
        this.insertExpression = insertExpr;
        this.updateExpressions = updateExpr;
        this.targetRangeVariables = targetRangeVars;
        this.condition = mergeCondition;
        this.isTransactionStatement = true;
        this.setDatabseObjects(compileContext);
        this.checkAccessRights(session);
    }

    StatementDML() {
        super(81, 2004, null);
    }

    @Override
    Result getResult(Session session) {
        Result result = null;
        switch (this.type) {
            case 82: {
                result = this.executeUpdateStatement(session);
                break;
            }
            case 128: {
                result = this.executeMergeStatement(session);
                break;
            }
            case 19: {
                result = this.executeDeleteStatement(session);
                break;
            }
            default: {
                throw Error.runtimeError(401, "StatementDML");
            }
        }
        return result;
    }

    @Override
    void collectTableNamesForRead(OrderedHashSet set) {
        int i;
        if (!this.baseTable.isTemp()) {
            for (i = 0; i < this.baseTable.fkConstraints.length; ++i) {
                set.add(this.baseTable.fkConstraints[i].getMain().getName());
            }
            this.getTriggerTableNames(set, false);
        }
        for (i = 0; i < this.rangeVariables.length; ++i) {
            Table rangeTable = this.rangeVariables[i].rangeTable;
            HsqlNameManager.HsqlName name = rangeTable.getName();
            if (rangeTable.isReadOnly() || rangeTable.isTemp() || name.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            set.add(name);
        }
        for (i = 0; i < this.subqueries.length; ++i) {
            if (this.subqueries[i].queryExpression == null) continue;
            this.subqueries[i].queryExpression.getBaseTableNames(set);
        }
    }

    @Override
    void getTriggerTableNames(OrderedHashSet set, boolean write) {
        block6: for (int i = 0; i < this.baseTable.triggerList.length; ++i) {
            TriggerDef td = this.baseTable.triggerList[i];
            switch (this.type) {
                case 50: {
                    if (td.getPrivilegeType() != 4) continue block6;
                    break;
                }
                case 82: {
                    if (td.getPrivilegeType() != 8) continue block6;
                    break;
                }
                case 19: {
                    if (td.getPrivilegeType() != 2) continue block6;
                    break;
                }
                case 128: {
                    if (td.getPrivilegeType() != 4 && td.getPrivilegeType() != 8) continue block6;
                    break;
                }
                default: {
                    throw Error.runtimeError(401, "StatementDML");
                }
            }
            for (int j = 0; j < td.statements.length; ++j) {
                if (write) {
                    set.addAll(td.statements[j].getTableNamesForWrite());
                    continue;
                }
                set.addAll(td.statements[j].getTableNamesForRead());
            }
        }
    }

    Result executeUpdateStatement(Session session) {
        int count = 0;
        Expression[] colExpressions = this.updateExpressions;
        HashMappedList rowset = new HashMappedList();
        Type[] colTypes = this.baseTable.getColumnTypes();
        RangeVariable.RangeIteratorMain it = RangeVariable.getIterator(session, this.targetRangeVariables);
        Expression checkCondition = null;
        if (this.targetTable != this.baseTable) {
            checkCondition = ((TableDerived)this.targetTable).getQueryExpression().getMainSelect().checkQueryCondition;
        }
        while (((RangeVariable.RangeIteratorBase)it).next()) {
            session.sessionData.startRowProcessing();
            Row row = it.getCurrentRow();
            Object[] data = row.getData();
            Object[] newData = StatementDML.getUpdatedData(session, this.baseTable, this.updateColumnMap, colExpressions, colTypes, data);
            if (checkCondition != null) {
                it.currentData = newData;
                boolean check = checkCondition.testCondition(session);
                if (!check) {
                    throw Error.error(5700);
                }
            }
            rowset.add(row, newData);
        }
        count = this.update(session, this.baseTable, rowset);
        this.baseTable.fireTriggers(session, 2, rowset);
        return Result.getUpdateCountResult(count);
    }

    static Object[] getUpdatedData(Session session, Table targetTable, int[] columnMap, Expression[] colExpressions, Type[] colTypes, Object[] oldData) {
        Object[] data = targetTable.getEmptyRowData();
        System.arraycopy(oldData, 0, data, 0, data.length);
        int i = 0;
        int ix = 0;
        while (i < columnMap.length) {
            int colIndex;
            int j;
            Expression expr;
            if ((expr = colExpressions[ix++]).getType() == 25) {
                Object[] values = expr.getRowValue(session);
                j = 0;
                while (j < values.length) {
                    colIndex = columnMap[i];
                    Expression e = expr.nodes[j];
                    if (targetTable.identityColumn != colIndex || e.getType() != 1 || e.valueData != null) {
                        if (e.getType() == 4) {
                            if (targetTable.identityColumn != colIndex) {
                                data[colIndex] = targetTable.colDefaults[colIndex].getValue(session);
                            }
                        } else {
                            data[colIndex] = colTypes[colIndex].convertToType(session, values[j], e.dataType);
                        }
                    }
                    ++j;
                    ++i;
                }
                continue;
            }
            if (expr.getType() == 23) {
                Object[] values = expr.getRowValue(session);
                j = 0;
                while (j < values.length) {
                    colIndex = columnMap[i];
                    Type colType = expr.subQuery.queryExpression.getMetaData().columnTypes[j];
                    data[colIndex] = colTypes[colIndex].convertToType(session, values[j], colType);
                    ++j;
                    ++i;
                }
                continue;
            }
            int colIndex2 = columnMap[i];
            if (expr.getType() == 4) {
                if (targetTable.identityColumn == colIndex2) {
                    ++i;
                    continue;
                }
                data[colIndex2] = targetTable.colDefaults[colIndex2].getValue(session);
                ++i;
                continue;
            }
            data[colIndex2] = expr.getValue(session, colTypes[colIndex2]);
            ++i;
        }
        return data;
    }

    Result executeMergeStatement(Session session) {
        Result resultOut = null;
        RowSetNavigator generatedNavigator = null;
        PersistentStore store = session.sessionData.getRowStore(this.baseTable);
        if (this.generatedIndexes != null) {
            resultOut = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
            generatedNavigator = resultOut.getChainedResult().getNavigator();
        }
        int count = 0;
        RowSetNavigatorClient newData = new RowSetNavigatorClient(8);
        HashMappedList updateRowSet = new HashMappedList();
        RangeVariable[] joinRangeIterators = this.targetRangeVariables;
        RangeIterator[] rangeIterators = new RangeIterator[joinRangeIterators.length];
        for (int i = 0; i < joinRangeIterators.length; ++i) {
            rangeIterators[i] = joinRangeIterators[i].getIterator(session);
        }
        int currentIndex = 0;
        while (0 <= currentIndex) {
            RangeIterator it = rangeIterators[currentIndex];
            boolean beforeFirst = it.isBeforeFirst();
            if (it.next()) {
                if (currentIndex < joinRangeIterators.length - 1) {
                    ++currentIndex;
                    continue;
                }
            } else {
                Object[] data;
                if (currentIndex == 1 && beforeFirst && (data = this.getMergeInsertData(session)) != null) {
                    newData.add(data);
                }
                it.reset();
                --currentIndex;
                continue;
            }
            if (this.updateExpressions == null) continue;
            Row row = it.getCurrentRow();
            Object[] data = StatementDML.getUpdatedData(session, this.baseTable, this.updateColumnMap, this.updateExpressions, this.baseTable.getColumnTypes(), row.getData());
            updateRowSet.add(row, data);
        }
        if (updateRowSet.size() > 0) {
            count = this.update(session, this.baseTable, updateRowSet);
            this.baseTable.fireTriggers(session, 2, updateRowSet);
        }
        if (newData.getSize() > 0) {
            newData.beforeFirst();
            while (newData.hasNext()) {
                Object[] data = newData.getNext();
                this.baseTable.insertRow(session, store, data);
                if (generatedNavigator == null) continue;
                Object[] generatedValues = this.getGeneratedColumns(data);
                generatedNavigator.add(generatedValues);
            }
            newData.beforeFirst();
            this.baseTable.fireTriggers(session, 0, newData);
            count += newData.getSize();
        }
        if (resultOut == null) {
            return Result.getUpdateCountResult(count);
        }
        resultOut.setUpdateCount(count);
        return resultOut;
    }

    int update(Session session, Table table, HashMappedList updateList) {
        HashMappedList triggeredList;
        Row row;
        int i;
        HashSet path = session.sessionContext.getConstraintPath();
        HashMappedList tableUpdateList = session.sessionContext.getTableUpdateList();
        for (i = 0; i < updateList.size(); ++i) {
            Row row2 = (Row)updateList.getKey(i);
            Object[] data = (Object[])updateList.get(i);
            table.setIdentityColumn(session, data);
            table.fireTriggers(session, 8, row2.getData(), data, this.updateColumnMap);
            table.setGeneratedColumns(session, data);
            table.enforceRowConstraints(session, data);
        }
        if (table.isView) {
            return updateList.size();
        }
        if (session.database.isReferentialIntegrity()) {
            for (i = 0; i < updateList.size(); ++i) {
                Object[] data = (Object[])updateList.get(i);
                row = (Row)updateList.getKey(i);
                StatementDML.checkCascadeUpdate(session, table, tableUpdateList, row, data, this.updateColumnMap, null, path);
            }
        }
        if ((triggeredList = (HashMappedList)tableUpdateList.get(table)) != null) {
            for (int i2 = 0; i2 < triggeredList.size(); ++i2) {
                row = (Row)triggeredList.getKey(i2);
                Object[] data = (Object[])triggeredList.get(i2);
                StatementDML.mergeKeepUpdate(session, updateList, this.updateColumnMap, table.colTypes, row, data);
            }
            triggeredList.clear();
        }
        for (int i3 = 0; i3 < tableUpdateList.size(); ++i3) {
            Table targetTable = (Table)tableUpdateList.getKey(i3);
            HashMappedList updateListT = (HashMappedList)tableUpdateList.get(i3);
            targetTable.updateRowSet(session, updateListT, null, true);
            updateListT.clear();
        }
        table.updateRowSet(session, updateList, this.updateColumnMap, false);
        this.baseTable.fireTriggers(session, 5, updateList);
        path.clear();
        return updateList.size();
    }

    Result executeDeleteStatement(Session session) {
        int count = 0;
        RowSetNavigatorLinkedList oldRows = new RowSetNavigatorLinkedList();
        RangeVariable.RangeIteratorMain it = RangeVariable.getIterator(session, this.targetRangeVariables);
        while (it.next()) {
            Row currentRow = it.getCurrentRow();
            oldRows.add(currentRow);
        }
        count = this.delete(session, this.baseTable, oldRows);
        if (this.restartIdentity && this.targetTable.identitySequence != null) {
            this.targetTable.identitySequence.reset();
        }
        return Result.getUpdateCountResult(count);
    }

    int delete(Session session, Table table, RowSetNavigator oldRows) {
        Row row;
        if (table.fkMainConstraints.length == 0) {
            this.deleteRows(session, table, oldRows);
            oldRows.beforeFirst();
            table.fireTriggers(session, 1, oldRows);
            return oldRows.getSize();
        }
        HashSet path = session.sessionContext.getConstraintPath();
        HashMappedList tableUpdateList = session.sessionContext.getTableUpdateList();
        if (session.database.isReferentialIntegrity()) {
            oldRows.beforeFirst();
            while (oldRows.hasNext()) {
                oldRows.next();
                row = oldRows.getCurrentRow();
                path.clear();
                StatementDML.checkCascadeDelete(session, table, tableUpdateList, row, false, path);
            }
        }
        if (session.database.isReferentialIntegrity()) {
            oldRows.beforeFirst();
            while (oldRows.hasNext()) {
                oldRows.next();
                row = oldRows.getCurrentRow();
                path.clear();
                StatementDML.checkCascadeDelete(session, table, tableUpdateList, row, true, path);
            }
        }
        oldRows.beforeFirst();
        while (oldRows.hasNext()) {
            oldRows.next();
            row = oldRows.getCurrentRow();
            if (row.isDeleted(session)) continue;
            table.deleteNoRefCheck(session, row);
        }
        for (int i = 0; i < tableUpdateList.size(); ++i) {
            Table targetTable = (Table)tableUpdateList.getKey(i);
            HashMappedList updateList = (HashMappedList)tableUpdateList.get(i);
            if (updateList.size() <= 0) continue;
            targetTable.updateRowSet(session, updateList, null, true);
            updateList.clear();
        }
        oldRows.beforeFirst();
        table.fireTriggers(session, 1, oldRows);
        path.clear();
        return oldRows.getSize();
    }

    void deleteRows(Session session, Table table, RowSetNavigator oldRows) {
        while (oldRows.hasNext()) {
            oldRows.next();
            Row row = oldRows.getCurrentRow();
            if (row.isDeleted(session)) continue;
            table.deleteNoRefCheck(session, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkCascadeDelete(Session session, Table table, HashMappedList tableUpdateList, Row row, boolean delete, HashSet path) {
        block5: for (Constraint c : table.fkMainConstraints) {
            RowIterator refiterator = c.findFkRef(session, row.getData(), delete);
            if (!refiterator.hasNext()) continue;
            try {
                Row refrow;
                boolean hasref;
                if (c.core.deleteAction == 3 || c.core.deleteAction == 1) {
                    Row refrow2;
                    if (c.core.mainTable == c.core.refTable && row.equals(refrow2 = refiterator.getNextRow())) continue;
                    int errorCode = c.core.deleteAction == 3 ? 8 : 3501;
                    Object[] info = new String[]{c.core.refName.name, c.core.refTable.getName().name};
                    throw Error.error(null, errorCode, 2, info);
                }
                Table reftable = c.getRef();
                boolean bl = hasref = reftable.fkMainConstraints.length > 0;
                if (!delete && !hasref) continue;
                Index refindex = c.getRefIndex();
                int[] m_columns = c.getMainColumns();
                int[] r_columns = c.getRefColumns();
                Object[] mdata = row.getData();
                boolean isUpdate = c.getDeleteAction() == 2 || c.getDeleteAction() == 4;
                HashMappedList rowSet = null;
                if (isUpdate && (rowSet = (HashMappedList)tableUpdateList.get(reftable)) == null) {
                    rowSet = new HashMappedList();
                    tableUpdateList.add(reftable, rowSet);
                }
                while ((refrow = refiterator.getNextRow()) != null && !refrow.isDeleted(session)) {
                    if (refindex.compareRowNonUnique(session, mdata, m_columns, refrow.getData()) != 0) {
                        continue block5;
                    }
                    if (isUpdate) {
                        int j;
                        Object[] rnd = reftable.getEmptyRowData();
                        System.arraycopy(refrow.getData(), 0, rnd, 0, rnd.length);
                        if (c.getDeleteAction() == 2) {
                            for (j = 0; j < r_columns.length; ++j) {
                                rnd[r_columns[j]] = null;
                            }
                        } else {
                            for (j = 0; j < r_columns.length; ++j) {
                                ColumnSchema col = reftable.getColumn(r_columns[j]);
                                rnd[r_columns[j]] = col.getDefaultValue(session);
                            }
                        }
                        if (hasref && path.add(c)) {
                            StatementDML.checkCascadeUpdate(session, reftable, null, refrow, rnd, r_columns, null, path);
                            path.remove(c);
                        }
                        if (delete && (reftable != table || !refrow.equals(row))) {
                            StatementDML.mergeUpdate(rowSet, refrow, rnd, r_columns);
                        }
                    } else if (hasref) {
                        if (reftable != table) {
                            if (path.add(c)) {
                                StatementDML.checkCascadeDelete(session, reftable, tableUpdateList, refrow, delete, path);
                                path.remove(c);
                            }
                        } else if (refrow.getPos() != row.getPos()) {
                            StatementDML.checkCascadeDelete(session, reftable, tableUpdateList, refrow, delete, path);
                        }
                    }
                    if (!delete || isUpdate || refrow.isDeleted(session)) continue;
                    reftable.deleteRowAsTriggeredAction(session, refrow);
                }
            }
            finally {
                refiterator.release();
            }
        }
    }

    Object[] getMergeInsertData(Session session) {
        if (this.insertExpression == null) {
            return null;
        }
        session.sessionData.startRowProcessing();
        Object[] data = this.targetTable.getNewRowData(session);
        Type[] colTypes = this.targetTable.getColumnTypes();
        Expression[] rowArgs = this.insertExpression.nodes[0].nodes;
        for (int i = 0; i < rowArgs.length; ++i) {
            Expression e = rowArgs[i];
            int colIndex = this.insertColumnMap[i];
            if (this.targetTable.identityColumn == colIndex && e.getType() == 1 && e.valueData == null) continue;
            if (e.getType() == 4) {
                if (this.targetTable.identityColumn == colIndex) continue;
                data[colIndex] = this.targetTable.colDefaults[colIndex].getValue(session);
                continue;
            }
            data[colIndex] = colTypes[colIndex].convertToType(session, e.getValue(session), e.getDataType());
        }
        return data;
    }

    static void checkCascadeUpdate(Session session, Table table, HashMappedList tableUpdateLists, Row orow, Object[] nrow, int[] cols, Table ref, HashSet path) {
        for (Constraint c : table.fkConstraints) {
            if (ref != null && c.getMain() == ref || ArrayUtil.countCommonElements(cols, c.getRefColumns()) == 0) continue;
            c.checkHasMainRef(session, nrow);
        }
        for (Constraint c : table.fkMainConstraints) {
            RowIterator refiterator;
            int[] common = ArrayUtil.commonElements(cols, c.getMainColumns());
            if (common == null) continue;
            int[] m_columns = c.getMainColumns();
            int[] r_columns = c.getRefColumns();
            boolean nochange = true;
            for (int j = 0; j < m_columns.length; ++j) {
                if (orow.getData()[m_columns[j]] == nrow[m_columns[j]]) continue;
                nochange = false;
                break;
            }
            if (nochange || !(refiterator = c.findFkRef(session, orow.getData(), false)).hasNext()) continue;
            if (c.core.updateAction == 3 || c.core.updateAction == 1) {
                int errorCode = c.core.deleteAction == 3 ? 8 : 3501;
                Object[] info = new String[]{c.core.refName.name, c.core.refTable.getName().name};
                throw Error.error(null, errorCode, 2, info);
            }
            Table reftable = c.getRef();
            boolean hasref = reftable.getNextConstraintIndex(0, 1) != -1;
            Index refindex = c.getRefIndex();
            HashMappedList rowSet = (HashMappedList)tableUpdateLists.get(reftable);
            if (rowSet == null) {
                rowSet = new HashMappedList();
                tableUpdateLists.add(reftable, rowSet);
            }
            Row refrow = refiterator.getNextRow();
            while (refrow != null && refindex.compareRowNonUnique(session, orow.getData(), m_columns, refrow.getData()) == 0) {
                int j;
                Object[] rnd = reftable.getEmptyRowData();
                System.arraycopy(refrow.getData(), 0, rnd, 0, rnd.length);
                if (c.getUpdateAction() == 2) {
                    for (j = 0; j < r_columns.length; ++j) {
                        rnd[r_columns[j]] = null;
                    }
                } else if (c.getUpdateAction() == 4) {
                    for (j = 0; j < r_columns.length; ++j) {
                        ColumnSchema col = reftable.getColumn(r_columns[j]);
                        rnd[r_columns[j]] = col.getDefaultValue(session);
                    }
                    if (path.add(c)) {
                        StatementDML.checkCascadeUpdate(session, reftable, tableUpdateLists, refrow, rnd, r_columns, null, path);
                        path.remove(c);
                    }
                } else {
                    for (j = 0; j < m_columns.length; ++j) {
                        rnd[r_columns[j]] = nrow[m_columns[j]];
                    }
                    if (path.add(c)) {
                        StatementDML.checkCascadeUpdate(session, reftable, tableUpdateLists, refrow, rnd, common, table, path);
                        path.remove(c);
                    }
                }
                StatementDML.mergeUpdate(rowSet, refrow, rnd, r_columns);
                refrow = refiterator.getNextRow();
            }
        }
    }

    static void mergeUpdate(HashMappedList rowSet, Row row, Object[] newData, int[] cols) {
        Object[] data = (Object[])rowSet.get(row);
        if (data != null) {
            for (int j = 0; j < cols.length; ++j) {
                data[cols[j]] = newData[cols[j]];
            }
        } else {
            rowSet.add(row, newData);
        }
    }

    static boolean mergeKeepUpdate(Session session, HashMappedList rowSet, int[] cols, Type[] colTypes, Row row, Object[] newData) {
        Object[] data = (Object[])rowSet.get(row);
        if (data != null) {
            if (IndexAVL.compareRows(session, row.getData(), newData, cols, colTypes) != 0 && IndexAVL.compareRows(session, newData, data, cols, colTypes) != 0) {
                return false;
            }
            for (int j = 0; j < cols.length; ++j) {
                newData[cols[j]] = data[cols[j]];
            }
            rowSet.put(row, newData);
        } else {
            rowSet.add(row, newData);
        }
        return true;
    }
}

