/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongKeyIntValueHashMap;
import org.hsqldb.lib.LongKeyLongValueHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.ReaderInputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.DataFileCacheSession;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollectionSession;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.ClobDataID;

public class SessionData {
    private final Database database;
    private final Session session;
    PersistentStoreCollectionSession persistentStoreCollection;
    LongKeyHashMap resultMap;
    DataFileCacheSession resultCache;
    Object currentValue;
    HashMap sequenceMap;
    OrderedHashSet sequenceUpdateSet;
    LongKeyLongValueHashMap resultLobs = new LongKeyLongValueHashMap();
    LongKeyIntValueHashMap lobUsageCount = new LongKeyIntValueHashMap();
    LongDeque createdLobs = new LongDeque();
    boolean hasLobOps;

    public SessionData(Database database, Session session) {
        this.database = database;
        this.session = session;
        this.persistentStoreCollection = new PersistentStoreCollectionSession(session);
    }

    public PersistentStore getRowStore(TableBase table) {
        if (table.store != null) {
            return table.store;
        }
        if (table.isSessionBased) {
            return this.persistentStoreCollection.getStore(table);
        }
        return this.database.persistentStoreCollection.getStore(table);
    }

    public PersistentStore getSubqueryRowStore(TableBase table) {
        PersistentStore store = this.persistentStoreCollection.getStore(table);
        store.removeAll();
        return store;
    }

    public PersistentStore getNewResultRowStore(TableBase table, boolean isCached) {
        try {
            PersistentStore store = this.session.database.logger.newStore(this.session, this.persistentStoreCollection, table, isCached);
            return store;
        }
        catch (HsqlException hsqlException) {
            throw Error.runtimeError(401, "SessionData");
        }
    }

    void setResultSetProperties(Result command, Result result) {
        if (command.rsConcurrency == 1007) {
            result.setDataResultConcurrency(1007);
            result.setDataResultHoldability(command.rsHoldability);
        } else if (result.rsConcurrency == 1008) {
            result.setDataResultHoldability(2);
            if (command.rsHoldability != 2) {
                this.session.addWarning(Error.error(4713));
            }
        } else {
            result.setDataResultConcurrency(1007);
            result.setDataResultHoldability(command.rsHoldability);
            this.session.addWarning(Error.error(4712));
        }
        if (command.rsScrollability == 1005) {
            this.session.addWarning(Error.error(4711));
        }
        result.setDataResultScrollability(command.rsScrollability);
    }

    Result getDataResultHead(Result command, Result result, boolean isNetwork) {
        int fetchSize = command.getFetchSize();
        result.setResultId(this.session.actionTimestamp);
        if (command.rsConcurrency == 1007) {
            result.setDataResultConcurrency(1007);
            result.setDataResultHoldability(command.rsHoldability);
        } else if (result.rsConcurrency == 1007) {
            result.setDataResultHoldability(command.rsHoldability);
        } else if (this.session.isAutoCommit()) {
            result.setDataResultConcurrency(1007);
            result.setDataResultHoldability(1);
        } else {
            result.setDataResultHoldability(2);
        }
        result.setDataResultScrollability(command.rsScrollability);
        boolean hold = false;
        boolean copy = false;
        if (result.rsConcurrency == 1008) {
            hold = true;
        }
        if (isNetwork) {
            if (fetchSize != 0 && result.getNavigator().getSize() > fetchSize) {
                copy = true;
                hold = true;
            }
        } else if (!result.getNavigator().isMemory()) {
            hold = true;
        }
        if (hold) {
            if (this.resultMap == null) {
                this.resultMap = new LongKeyHashMap();
            }
            this.resultMap.put(result.getResultId(), result);
        }
        if (copy) {
            result = Result.newDataHeadResult(this.session, result, 0, fetchSize);
        }
        return result;
    }

    Result getDataResultSlice(long id, int offset, int count) {
        RowSetNavigatorClient navigator = this.getRowSetSlice(id, offset, count);
        return Result.newDataRowsResult(navigator);
    }

    Result getDataResult(long id) {
        Result result = (Result)this.resultMap.get(id);
        return result;
    }

    RowSetNavigatorClient getRowSetSlice(long id, int offset, int count) {
        Result result = (Result)this.resultMap.get(id);
        RowSetNavigator source = result.getNavigator();
        if (offset + count > source.getSize()) {
            count = source.getSize() - offset;
        }
        return new RowSetNavigatorClient(source, offset, count);
    }

    public void closeNavigator(long id) {
        Result result = (Result)this.resultMap.remove(id);
        result.getNavigator().close();
    }

    public void closeAllNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            result.getNavigator().close();
        }
        this.resultMap.clear();
    }

    public void closeAllTransactionNavigators() {
        if (this.resultMap == null) {
            return;
        }
        Iterator it = this.resultMap.values().iterator();
        while (it.hasNext()) {
            Result result = (Result)it.next();
            if (result.rsHoldability != 2) continue;
            result.getNavigator().close();
            it.remove();
        }
        this.resultMap.clear();
    }

    public DataFileCacheSession getResultCache() {
        if (this.resultCache == null) {
            String path = this.database.logger.getTempDirectoryPath();
            if (path == null) {
                return null;
            }
            try {
                this.resultCache = new DataFileCacheSession(this.database, path + "/session_" + Long.toString(this.session.getId()));
                this.resultCache.open(false);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return this.resultCache;
    }

    synchronized void closeResultCache() {
        if (this.resultCache != null) {
            try {
                this.resultCache.close(false);
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.resultCache = null;
        }
    }

    public void updateLobUsage(boolean commit) {
        if (!this.hasLobOps) {
            return;
        }
        this.hasLobOps = false;
        if (commit) {
            int delta;
            long lobID;
            for (int i = 0; i < this.createdLobs.size(); ++i) {
                lobID = this.createdLobs.get(i);
                delta = this.lobUsageCount.get(lobID, 0);
                if (delta == 1) {
                    this.lobUsageCount.remove(lobID);
                    this.createdLobs.remove(i);
                    --i;
                    continue;
                }
                if (this.session.isBatch) continue;
                this.database.lobManager.adjustUsageCount(lobID, delta - 1);
                this.lobUsageCount.remove(lobID);
                this.createdLobs.remove(i);
                --i;
            }
            if (!this.lobUsageCount.isEmpty()) {
                Iterator it = this.lobUsageCount.keySet().iterator();
                while (it.hasNext()) {
                    lobID = it.nextLong();
                    delta = this.lobUsageCount.get(lobID);
                    this.database.lobManager.adjustUsageCount(lobID, delta - 1);
                }
                this.lobUsageCount.clear();
            }
            return;
        }
        for (int i = 0; i < this.createdLobs.size(); ++i) {
            long lobID = this.createdLobs.get(i);
            this.database.lobManager.deleteLob(lobID);
        }
        this.createdLobs.clear();
        this.lobUsageCount.clear();
    }

    public void updateLobUsageForBatch() {
        for (int i = 0; i < this.createdLobs.size(); ++i) {
            long lobID = this.createdLobs.get(i);
            this.database.lobManager.deleteLob(lobID);
        }
        this.createdLobs.clear();
    }

    public void addToCreatedLobs(long lobID) {
        this.hasLobOps = true;
        this.createdLobs.add(lobID);
    }

    public void addLobUsageCount(long lobID) {
        int count = this.lobUsageCount.get(lobID, 0);
        this.hasLobOps = true;
        this.lobUsageCount.put(lobID, count + 1);
    }

    public void removeUsageCount(long lobID) {
        int count = this.lobUsageCount.get(lobID, 0);
        this.hasLobOps = true;
        this.lobUsageCount.put(lobID, count - 1);
    }

    public void allocateLobForResult(ResultLob result, InputStream inputStream) {
        long resultLobId = result.getLobID();
        switch (result.getSubType()) {
            case 7: {
                long blobId;
                long blobLength = result.getBlockLength();
                if (inputStream == null) {
                    blobId = resultLobId;
                    inputStream = result.getInputStream();
                } else {
                    BlobDataID blob = this.session.createBlob(blobLength);
                    blobId = blob.getId();
                    this.resultLobs.put(resultLobId, blobId);
                }
                CountdownInputStream countStream = new CountdownInputStream(inputStream);
                countStream.setCount(blobLength);
                this.database.lobManager.setBytesForNewBlob(blobId, countStream, result.getBlockLength());
                break;
            }
            case 8: {
                long clobId;
                long clobLength = result.getBlockLength();
                if (inputStream == null) {
                    clobId = resultLobId;
                    inputStream = result.getReader() != null ? new ReaderInputStream(result.getReader()) : result.getInputStream();
                } else {
                    ClobDataID clob = this.session.createClob(clobLength);
                    clobId = clob.getId();
                    this.resultLobs.put(resultLobId, clobId);
                }
                CountdownInputStream countStream = new CountdownInputStream(inputStream);
                countStream.setCount(clobLength * 2L);
                this.database.lobManager.setCharsForNewClob(clobId, countStream, result.getBlockLength());
                break;
            }
        }
    }

    public void registerLobForResult(Result result) {
        RowSetNavigator navigator = result.getNavigator();
        while (navigator.next()) {
            Object[] data = navigator.getCurrent();
            for (int i = 0; i < data.length; ++i) {
                long id;
                if (data[i] instanceof BlobData) {
                    BlobData blob = (BlobData)data[i];
                    id = this.resultLobs.get(blob.getId());
                    data[i] = this.database.lobManager.getBlob(this.session, id);
                    continue;
                }
                if (!(data[i] instanceof ClobData)) continue;
                ClobData clob = (ClobData)data[i];
                id = this.resultLobs.get(clob.getId());
                data[i] = this.database.lobManager.getClob(this.session, id);
            }
        }
        this.resultLobs.clear();
        navigator.reset();
    }

    public void startRowProcessing() {
        if (this.sequenceMap != null) {
            this.sequenceMap.clear();
        }
    }

    public Object getSequenceValue(NumberSequence sequence) {
        HsqlNameManager.HsqlName key;
        Object value;
        if (this.sequenceMap == null) {
            this.sequenceMap = new HashMap();
            this.sequenceUpdateSet = new OrderedHashSet();
        }
        if ((value = this.sequenceMap.get(key = sequence.getName())) == null) {
            value = sequence.getValueObject();
            this.sequenceMap.put(key, value);
            this.sequenceUpdateSet.add(sequence);
        }
        return value;
    }
}

