/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.SchemaManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.store.ValuePool;

public class SchemaObjectSet {
    HashMap map;
    int type;
    SchemaManager manager;

    SchemaObjectSet(int type) {
        this.type = type;
        switch (type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: {
                this.map = new HashMappedList();
                break;
            }
            case 5: 
            case 20: {
                this.map = new HashMap();
            }
        }
    }

    HsqlNameManager.HsqlName getName(String name) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: {
                SchemaObject object = (SchemaObject)this.map.get(name);
                return object == null ? null : object.getName();
            }
            case 5: 
            case 20: {
                return (HsqlNameManager.HsqlName)this.map.get(name);
            }
        }
        return (HsqlNameManager.HsqlName)this.map.get(name);
    }

    SchemaObject getObject(String name) {
        switch (this.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: {
                return (SchemaObject)this.map.get(name);
            }
        }
        throw Error.runtimeError(401, "SchemaObjectSet");
    }

    boolean contains(String name) {
        return this.map.containsKey(name);
    }

    void checkAdd(HsqlNameManager.HsqlName name) {
        if (this.map.containsKey(name.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, name.name);
        }
    }

    void checkExists(String name) {
        if (!this.map.containsKey(name)) {
            int code = SchemaObjectSet.getGetErrorCode(this.type);
            throw Error.error(code, name);
        }
    }

    void add(SchemaObject object) {
        HsqlNameManager.HsqlName name = object.getName();
        if (this.type == 24) {
            name = ((Routine)object).getSpecificName();
        }
        if (this.map.containsKey(name.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, name.name);
        }
        Object value = object;
        switch (name.type) {
            case 5: 
            case 20: {
                value = name;
            }
        }
        this.map.put(name.name, value);
    }

    void remove(String name) {
        this.map.remove(name);
    }

    void removeParent(HsqlNameManager.HsqlName parent) {
        Iterator it = this.map.values().iterator();
        while (it.hasNext()) {
            if (this.type == 8 || this.type == 24) {
                SchemaObject object = (SchemaObject)it.next();
                if (object.getName().parent != parent) continue;
                it.remove();
                continue;
            }
            HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
            if (name.parent != parent) continue;
            it.remove();
        }
    }

    void rename(HsqlNameManager.HsqlName name, HsqlNameManager.HsqlName newName) {
        if (this.map.containsKey(newName.name)) {
            int code = SchemaObjectSet.getAddErrorCode(name.type);
            throw Error.error(code, newName.name);
        }
        switch (newName.type) {
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                int i = ((HashMappedList)this.map).getIndex(name.name);
                if (i == -1) {
                    int code = SchemaObjectSet.getGetErrorCode(name.type);
                    throw Error.error(code, name.name);
                }
                SchemaObject object = (SchemaObject)((HashMappedList)this.map).get(i);
                object.getName().rename(newName);
                ((HashMappedList)this.map).setKey(i, name.name);
                break;
            }
            case 5: 
            case 20: {
                this.map.remove(name.name);
                name.rename(newName);
                this.map.put(name.name, name);
            }
        }
    }

    static int getAddErrorCode(int type) {
        int code;
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: {
                code = 5504;
                break;
            }
            default: {
                throw Error.runtimeError(401, "SchemaObjectSet");
            }
        }
        return code;
    }

    static int getGetErrorCode(int type) {
        int code;
        switch (type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 24: {
                code = 5501;
                break;
            }
            default: {
                throw Error.runtimeError(401, "SchemaObjectSet");
            }
        }
        return code;
    }

    public static String getName(int type) {
        switch (type) {
            case 4: {
                return "VIEW";
            }
            case 3: {
                return "TABLE";
            }
            case 7: {
                return "SEQUENCE";
            }
            case 14: {
                return "CHARACTER SET";
            }
            case 13: {
                return "DOMAIN";
            }
            case 12: {
                return "TYPE";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 15: {
                return "COLLATION";
            }
            case 17: {
                return "PROCEDURE";
            }
            case 16: {
                return "FUNCTION";
            }
            case 6: {
                return "ASSERTION";
            }
            case 20: {
                return "INDEX";
            }
            case 8: {
                return "TRIGGER";
            }
        }
        throw Error.runtimeError(401, "SchemaObjectSet");
    }

    String[] getSQL(OrderedHashSet resolved, OrderedHashSet unresolved) {
        HsqlArrayList list = new HsqlArrayList();
        if (!(this.map instanceof HashMappedList)) {
            return null;
        }
        if (this.map.isEmpty()) {
            return ValuePool.emptyStringArray;
        }
        Iterator it = this.map.values().iterator();
        if (this.type == 16 || this.type == 17) {
            OrderedHashSet set = new OrderedHashSet();
            while (it.hasNext()) {
                RoutineSchema routine = (RoutineSchema)it.next();
                for (int i = 0; i < routine.routines.length; ++i) {
                    set.add(routine.routines[i]);
                }
            }
            it = set.iterator();
        }
        while (it.hasNext()) {
            SchemaObject object = (SchemaObject)it.next();
            OrderedHashSet references = object.getReferences();
            if (references != null) {
                boolean isResolved = true;
                for (int j = 0; j < references.size(); ++j) {
                    HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)references.get(j);
                    if (SqlInvariants.isSchemaNameSystem(name)) continue;
                    if (name.type == 9) {
                        name = name.parent;
                    }
                    if (name.type == 14 && name.schema == null || resolved.contains(name)) continue;
                    isResolved = false;
                    break;
                }
                if (!isResolved) {
                    unresolved.add(object);
                    continue;
                }
            }
            resolved.add(object.getName());
            if (object.getType() == 3) {
                list.addAll(((Table)object).getSQL(resolved, unresolved));
                continue;
            }
            list.add(object.getSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }
}

