/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Expression;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class FunctionSQLInvoked
extends Expression {
    RoutineSchema routineSchema;
    Routine routine;

    FunctionSQLInvoked(RoutineSchema routineSchema) {
        super(27);
        this.routineSchema = routineSchema;
    }

    public void setArguments(Expression[] newNodes) {
        this.nodes = newNodes;
    }

    @Override
    public void resolveTypes(Session session, Expression parent) {
        int i;
        Type[] types = new Type[this.nodes.length];
        for (i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            e.resolveTypes(session, this);
            types[i] = e.dataType;
        }
        this.routine = this.routineSchema.getSpecificRoutine(types);
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i].dataType != null) continue;
            this.nodes[i].dataType = this.routine.getParameterTypes()[i];
        }
        this.dataType = this.routine.getReturnType();
    }

    @Override
    public Object getValue(Session session) {
        Result result;
        boolean push;
        int variableCount = this.routine.getVariableCount();
        int extraArg = this.routine.javaMethodWithConnection ? 1 : 0;
        Object[] data = ValuePool.emptyObjectArray;
        Object returnValue = null;
        boolean bl = push = this.routine.isPSM() || this.routine.dataImpact != 1;
        if (extraArg + this.nodes.length > 0) {
            data = new Object[this.nodes.length + extraArg];
            if (extraArg > 0) {
                data[0] = session.getInternalConnection();
            }
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            Object value = e.getValue(session, e.dataType);
            if (value == null) {
                if (this.routine.isNullInputOutput()) {
                    return null;
                }
                if (!this.routine.getParameter(i).isNullable()) {
                    throw Error.error(4811);
                }
            }
            if (this.routine.isPSM()) {
                data[i] = value;
                continue;
            }
            data[i + extraArg] = e.dataType.convertSQLToJava(session, value);
        }
        if (push) {
            session.sessionContext.push();
        }
        if (this.routine.isPSM()) {
            session.sessionContext.routineArguments = data;
            session.sessionContext.routineVariables = ValuePool.emptyObjectArray;
            if (variableCount > 0) {
                session.sessionContext.routineVariables = new Object[variableCount];
            }
            if (!(result = this.routine.statement.execute(session)).isError()) {
                if (result.isSimpleValue()) {
                    returnValue = result.getValueObject();
                } else {
                    result = Result.newErrorResult(Error.error(4605, this.routine.getName().name), null);
                }
            }
        } else {
            try {
                returnValue = this.routine.javaMethod.invoke(null, data);
                if (!this.routine.returnsTable()) {
                    returnValue = this.dataType.convertJavaToSQL(session, returnValue);
                }
                result = Result.updateZeroResult;
            }
            catch (InvocationTargetException e) {
                result = Result.newErrorResult(Error.error(6000, this.routine.getName().name), null);
            }
            catch (IllegalAccessException e) {
                result = Result.newErrorResult(Error.error(6000, this.routine.getName().name), null);
            }
            catch (Throwable e) {
                result = Result.newErrorResult(Error.error(6000, this.routine.getName().name), null);
            }
        }
        if (push) {
            if (result.isError()) {
                session.rollbackToSavepoint();
            }
            session.sessionContext.pop();
        }
        if (result.isError()) {
            throw result.getException();
        }
        return returnValue;
    }

    @Override
    public String getSQL() {
        return "FUNCTION";
    }

    @Override
    public String describe(Session session) {
        return super.describe(session);
    }
}

