package de.ugoe.cs.swe.memos.gui.menu;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

import de.ugoe.cs.swe.memos.Utils;
import de.ugoe.cs.swe.memos.database.DBUtility;
import de.ugoe.cs.swe.memos.database.DatabaseException;
import de.ugoe.cs.swe.memos.datamodel.Category;
import de.ugoe.cs.swe.memos.gui.mainview.CategoryBrowser;

public class editCHandler implements IHandler, Listener {
	private static boolean enabled = true;
	private static boolean doNotLoseFocus = false;

	public static void setEnabled(boolean state) {
		enabled = state;

	}

	@Override
	public void addHandlerListener(IHandlerListener handlerListener) {
		// TODO Auto-generated method stub

	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub

	}

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		editCategoryButtonPressed();
		return null;
	}

	@Override
	public boolean isEnabled() {
		// TODO Auto-generated method stub
		return enabled;
	}

	@Override
	public boolean isHandled() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void removeHandlerListener(IHandlerListener handlerListener) {
		// TODO Auto-generated method stub

	}

	private void editCategoryButtonPressed() {
		if (getCategoryTree().getSelection().length > 0) {
			try {
				if (getCategoryTree().getSelection()[0].getParentItem() == null) {
					Category root = new Category("root");

					DBUtility.getInstance().addChildrenToCategory(root);
					
					Category toEditC=(Category) getCategoryTree().getSelection()[0].getData();
					
					Category currentC=null;
					for(Category c : root.getChildCategories())
					{	if(c.getName().equals(toEditC.getName()))
								currentC=c;
					}
					if(currentC!=null)
					root.getChildCategories().remove(currentC);

					showNewCatEditField(getCategoryTree().getSelection()[0],
							toEditC, root);
				} else {
					Category parent = (Category) (getCategoryTree()
							.getSelection()[0].getParentItem().getData());
					DBUtility.getInstance().addChildrenToCategory(parent);

					
					Category toEditC=(Category) getCategoryTree().getSelection()[0].getData();
					
					Category currentC=null;
					for(Category c : parent.getChildCategories())
					{	if(c.getName().equals(toEditC.getName()))
								currentC=c;
					}
					if(currentC!=null)
					parent.getChildCategories().remove(currentC);
					
					showNewCatEditField(getCategoryTree().getSelection()[0],
							toEditC, parent);

				}
			} catch (DatabaseException e) {
				Utils
						.showError("Fehler mit der Datenbank, bitte Anwendung neustarten");
			}
		}
	}

	private void showNewCatEditField(final TreeItem toEditItem,
			final Category toEditCategory, final Category parent) {

		final TreeEditor editor = new TreeEditor(getCategoryTree());
		final Text itemTextEditor = new Text(getCategoryTree(), SWT.NONE);

		editor.horizontalAlignment = SWT.LEFT;
		editor.grabHorizontal = true;

		itemTextEditor.setText(toEditCategory.getName());
		itemTextEditor.selectAll();
		itemTextEditor.setFocus();
		itemTextEditor.addFocusListener(new FocusAdapter() {
			public void focusLost(FocusEvent event) {
				if (!doNotLoseFocus) {
					toEditItem.setText(itemTextEditor.getText());
					itemTextEditor.dispose();
				}
			}
		});

		itemTextEditor.addKeyListener(new KeyAdapter() {
			public void keyPressed(KeyEvent event) {
				doNotLoseFocus = true;
				switch (event.keyCode) {
				case SWT.CR:
					CategoryBrowser catBrowser = Utils.getMainView()
							.getCategoryBrowser();

					if (catBrowser.isValidCategoryName(
							itemTextEditor.getText(), parent
									.getChildCategories())) {
						DBUtility connect = DBUtility.getInstance();
						toEditCategory.setName(itemTextEditor.getText());
						toEditItem.setText(toEditCategory.getName());
						parent.addChild(toEditCategory);
						try {
							connect.updateCategory(toEditCategory);
						} catch (DatabaseException e) {

						}
						catBrowser.refreshCatTree();
					}

				case SWT.ESC:
					itemTextEditor.dispose();
					break;
				}
				doNotLoseFocus = false;
			}
		});
		editor.setEditor(itemTextEditor, toEditItem);
	}

	private Tree getCategoryTree() {
		return Utils.getMainView().getCategoryBrowser().getCategoryTree();

	}

	@Override
	public void handleEvent(Event event) {
		if (event.type == SWT.Selection)
			editCategoryButtonPressed();

	}

}
