package de.ugoe.cs.swe.memos.gui.menu;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

import de.ugoe.cs.swe.memos.Utils;
import de.ugoe.cs.swe.memos.database.DBUtility;
import de.ugoe.cs.swe.memos.database.DatabaseException;
import de.ugoe.cs.swe.memos.datamodel.Memo;
import de.ugoe.cs.swe.memos.gui.mainview.ArticleComposite;
import de.ugoe.cs.swe.memos.gui.mainview.View;

public class deleteHandler implements IHandler {
	private static boolean enabled = true;

	public static void setEnabled(boolean state) {
		enabled = state;
	}

	@Override
	public void addHandlerListener(IHandlerListener handlerListener) {
		// TODO Auto-generated method stub

	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub

	}

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		DBUtility db = DBUtility.getInstance();
		View mainView = Utils.getMainView();
		Composite aC = mainView.getActiveComposite();
		if (aC != null && aC instanceof ArticleComposite) {
			Memo currentMemo = ((ArticleComposite) aC).getMemo();

			MessageBox mb = new MessageBox(PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell(), SWT.ICON_QUESTION
					| SWT.YES | SWT.NO);
			mb.setMessage("Der Artikel " + currentMemo.getTitle()
					+ " soll gelöscht werden. Sicher?");
			mb.setText("Achtung");
			if (mb.open() == SWT.YES)				
			try {
				db.deleteMemo(currentMemo);
				mainView.getTabFolder().getSelection().dispose();
			} catch (DatabaseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		return null;
	}

	@Override
	public boolean isEnabled() {
		// TODO Auto-generated method stub
		return enabled;
	}

	@Override
	public boolean isHandled() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void removeHandlerListener(IHandlerListener handlerListener) {
		// TODO Auto-generated method stub

	}

}
