package de.ugoe.cs.swe.memos.gui.mainview;

import java.util.Vector;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import de.ugoe.cs.swe.memos.SettingsManager;
import de.ugoe.cs.swe.memos.Utils;
import de.ugoe.cs.swe.memos.datamodel.Memo;

public class SearchResultComposite extends Composite {
	private Table searchResulttable;

	public SearchResultComposite(Composite parent, int style,
			final CategoryBrowser cbrowser) {
		super(parent, style);
		this.setLayout(createGridLayout(1));

		searchResulttable = new Table(this, SWT.MULTI | SWT.BORDER
				| SWT.FULL_SELECTION);
		searchResulttable.setLinesVisible(true);
		searchResulttable.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				true));
		this.searchResulttable.addMouseListener(new MouseAdapter() {
			public void mouseDoubleClick(MouseEvent e) {
				TableItem item = searchResulttable.getSelection()[0];
				Memo memo = (Memo) item.getData();
				CTabItem memoTab = Utils.getMainView().addTabItem(
						memo.getTitle());
				Utils.getMainView().SetTabItemActive(memoTab);
				ArticleComposite articleComposite;
				if (memo.getLock() != null
						&& memo.getLock().equals(
								SettingsManager.getInstance().getUsername()))
					articleComposite = new ArticleComposite(Utils.getMainView()
							.getTabFolder(), SWT.BORDER, memo, cbrowser,
							ArticleComposite.MODE.WRITE);
				else
					articleComposite = new ArticleComposite(Utils.getMainView()
							.getTabFolder(), SWT.BORDER, memo, cbrowser,
							ArticleComposite.MODE.READ);

				memoTab.setData(articleComposite);
				memoTab.setText(memo.getTitle());
//				memoTab.addDisposeListener(new DisposeArticleListene(Utils
//						.getMainView().getTabFolder()));

				memoTab.setControl(articleComposite);
				cbrowser.getTreeMouseListener().setActiveCategoryField(
						articleComposite.getCategoryField());
				cbrowser.getTreeMouseListener().updateSelectedCategory();
			}

			public void mouseDown(MouseEvent e) {

			}

			public void mouseUp(MouseEvent e) {

			}

		});
		
		//Custom drawing for Windows
		Listener paintListener = new Listener() {

			public void handleEvent(Event event) {
				switch (event.type) {
				case SWT.MeasureItem: {
					TableItem item = (TableItem) event.item;
					String text = getText(item, event.index);
					Point size = event.gc.textExtent(text);
					event.width = size.x;
					event.height = Math.max(event.height, size.y);
					break;
				}
				case SWT.PaintItem: {
					TableItem item = (TableItem) event.item;
					String text = getText(item, event.index);
					Point size = event.gc.textExtent(text);
					int offset2 = event.index == 0 ? Math.max(0,
							(event.height - size.y) / 2) : 0;
					event.gc.drawText(text, event.x, event.y + offset2, true);
					break;
				}
				case SWT.EraseItem: {
					event.detail &= ~SWT.FOREGROUND;
					break;
				}
				}
			}

			String getText(TableItem item, int column) {
				String text = item.getText(column);
				if (column != 0) {
					int index = searchResulttable.indexOf(item);
					if ((index + column) % 3 == 1) {
						text += "\nnew line";
					}
					if ((index + column) % 3 == 2) {
						text += "\nnew line\nnew line";
					}
				}
				return text;
			}
		};
		searchResulttable.addListener(SWT.MeasureItem, paintListener);
		searchResulttable.addListener(SWT.PaintItem, paintListener);
		searchResulttable.addListener(SWT.EraseItem, paintListener);
	}

	public Vector<Memo> memos;
	
	

	public void layout() {
		super.layout();
		
		searchResulttable.removeAll();
		if (memos.isEmpty()) {
			TableItem item = new TableItem(searchResulttable, SWT.MULTI);
			item.setText("Keine Memos gefunden.");
			return;
		}

		for (Memo memo : memos) {
			memo.update();
			if (memo.getiD() != null) {
				memo.loadFiles();
				TableItem item = new TableItem(searchResulttable, SWT.MULTI);
				item.setText(0, memo.getTitle()
						+ "\n"
						+ memo.getTagsAsString()
						+ "\n"
						+ memo.getPreviewContent()
						+ "\n"
						+ memo.getTimestamp()
						+ " Autor: "
						+ memo.getAuthor()
						+ (memo.getFiles().size() > 0 ? " Dateien: "
								+ memo.getFiles().size() : ""));
				item.setData(memo);
			}
		}
	}

	public void addResults(Vector<Memo> memos) {
		this.memos = memos;
		this.layout();
		// if (memos.isEmpty()) {
		// TableItem item = new TableItem(searchResulttable, SWT.MULTI);
		// item.setText("Keine Memos gefunden.");
		// return;
		// }
		//			
		// for (Memo memo : memos) {
		// memo.loadFiles();
		// TableItem item = new TableItem(searchResulttable, SWT.MULTI);
		// item.setText(0, memo.getTitle() + "\n" + memo.getTagsAsString()
		// + "\n" + memo.getPreviewContent() + "\n"
		// + memo.getTimestamp() + " Autor: " + memo.getAuthor() +
		// (memo.getFiles().size() > 0 ? " Dateien: " + memo.getFiles().size() :
		// ""));
		// item.setData(memo);
		// }
	}

	private GridLayout createGridLayout(int numColumns) {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = numColumns;
		return gridLayout;
	}
}