/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.rights.Grantee;

public class Charset
implements SchemaObject {
    public static final int[][] uppercaseLetters = new int[][]{{65, 90}};
    public static final int[][] unquotedIdentifier = new int[][]{{48, 57}, {65, 90}, {95, 95}};
    public static final int[][] basicIdentifier = new int[][]{{48, 57}, {65, 90}, {95, 95}, {97, 122}};
    HsqlNameManager.HsqlName name;
    public HsqlNameManager.HsqlName base;
    int[][] ranges;

    public Charset(HsqlNameManager.HsqlName name) {
        this.name = name;
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        OrderedHashSet set = new OrderedHashSet();
        set.add(this.base);
        return set;
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE").append(' ').append("CHARACTER").append(' ').append("SET").append(' ');
        sb.append(this.name.getSchemaQualifiedStatementName());
        sb.append(' ').append("AS").append(' ').append("GET");
        sb.append(' ').append(this.base.getSchemaQualifiedStatementName());
        return sb.toString();
    }

    public static boolean isInSet(String value, int[][] ranges) {
        int length = value.length();
        block0: for (int index = 0; index < length; ++index) {
            char ch = value.charAt(index);
            for (int i = 0; i < ranges.length; ++i) {
                if (ch > ranges[i][1]) continue;
                if (ch >= ranges[i][0]) continue block0;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean startsWith(String value, int[][] ranges) {
        char ch = value.charAt(0);
        for (int i = 0; i < ranges.length; ++i) {
            if (ch > ranges[i][1]) continue;
            return ch >= ranges[i][0];
        }
        return false;
    }

    public static Charset getDefaultInstance() {
        return SqlInvariants.UTF16;
    }
}

