/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.rowio.RowOutputTextLog;
import org.hsqldb.scriptio.ScriptWriterBase;

public class ScriptWriterText
extends ScriptWriterBase {
    RowOutputTextLog rowOut;
    public static byte[] BYTES_LINE_SEP;
    static byte[] BYTES_COMMIT;
    static byte[] BYTES_INSERT_INTO;
    static byte[] BYTES_VALUES;
    static byte[] BYTES_TERM;
    static byte[] BYTES_DELETE_FROM;
    static byte[] BYTES_WHERE;
    static byte[] BYTES_SEQUENCE;
    static byte[] BYTES_SEQUENCE_MID;
    static byte[] BYTES_C_ID_INIT;
    static byte[] BYTES_C_ID_TERM;
    static byte[] BYTES_SCHEMA;

    public ScriptWriterText(Database db, String file, boolean includeCachedData, boolean newFile, boolean isDump) {
        super(db, file, includeCachedData, newFile, isDump);
    }

    @Override
    protected void initBuffers() {
        this.rowOut = new RowOutputTextLog();
    }

    @Override
    protected void writeDataTerm() throws IOException {
    }

    @Override
    protected void addSessionId(Session session) throws IOException {
        if (session == null) {
            return;
        }
        if (session != this.currentSession) {
            this.rowOut.write(BYTES_C_ID_INIT);
            this.rowOut.writeLong(session.getId());
            this.rowOut.write(BYTES_C_ID_TERM);
            this.currentSession = session;
        }
        if (this.schemaToLog != session.loggedSchema) {
            this.writeSchemaStatement(this.schemaToLog);
            session.loggedSchema = this.schemaToLog;
        }
    }

    private void writeSchemaStatement(HsqlNameManager.HsqlName schema) {
        this.rowOut.write(BYTES_SCHEMA);
        this.rowOut.writeString(schema.statementName);
        this.rowOut.write(BYTES_LINE_SEP);
    }

    @Override
    public void writeLogStatement(Session session, String s) throws IOException {
        this.schemaToLog = session.currentSchema;
        this.busyWriting = true;
        this.rowOut.reset();
        this.addSessionId(session);
        this.rowOut.writeString(s);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.byteCount += (long)this.rowOut.size();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    @Override
    protected void writeRow(Session session, Table table, Object[] data) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.busyWriting = true;
        this.rowOut.reset();
        this.rowOut.setMode(0);
        this.addSessionId(session);
        this.rowOut.write(BYTES_INSERT_INTO);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_VALUES);
        this.rowOut.writeData(data, table.getColumnTypes());
        this.rowOut.write(BYTES_TERM);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.byteCount += (long)this.rowOut.size();
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    @Override
    protected void writeTableInit(Table t) throws IOException {
        if (t.isEmpty(this.currentSession)) {
            return;
        }
        if (this.schemaToLog == this.currentSession.loggedSchema) {
            return;
        }
        this.rowOut.reset();
        this.writeSchemaStatement(t.getName().schema);
        this.writeRowOutToFile();
        this.currentSession.loggedSchema = this.schemaToLog;
    }

    @Override
    public void writeInsertStatement(Session session, Table table, Object[] data) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.writeRow(session, table, data);
    }

    @Override
    public void writeDeleteStatement(Session session, Table table, Object[] data) throws IOException {
        this.schemaToLog = table.getName().schema;
        this.busyWriting = true;
        this.rowOut.reset();
        this.rowOut.setMode(1);
        this.addSessionId(session);
        this.rowOut.write(BYTES_DELETE_FROM);
        this.rowOut.writeString(table.getName().statementName);
        this.rowOut.write(BYTES_WHERE);
        this.rowOut.writeData(table.getColumnCount(), table.getColumnTypes(), data, table.columnList, table.getPrimaryKey());
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.byteCount += (long)this.rowOut.size();
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    @Override
    public void writeSequenceStatement(Session session, NumberSequence seq) throws IOException {
        this.schemaToLog = seq.getName().schema;
        this.busyWriting = true;
        this.rowOut.reset();
        this.addSessionId(session);
        this.rowOut.write(BYTES_SEQUENCE);
        this.rowOut.writeString(seq.getSchemaName().statementName);
        this.rowOut.write(46);
        this.rowOut.writeString(seq.getName().statementName);
        this.rowOut.write(BYTES_SEQUENCE_MID);
        this.rowOut.writeLong(seq.peek());
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.byteCount += (long)this.rowOut.size();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync) {
            this.sync();
        }
    }

    @Override
    public void writeCommitStatement(Session session) throws IOException {
        this.busyWriting = true;
        this.rowOut.reset();
        this.addSessionId(session);
        this.rowOut.write(BYTES_COMMIT);
        this.rowOut.write(BYTES_LINE_SEP);
        this.writeRowOutToFile();
        this.byteCount += (long)this.rowOut.size();
        this.needsSync = true;
        this.busyWriting = false;
        if (this.forceSync || this.writeDelay == 0) {
            this.sync();
        }
    }

    protected void finalize() {
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeRowOutToFile() throws IOException {
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
        }
    }

    static {
        String sLineSep = System.getProperty("line.separator", "\n");
        try {
            BYTES_LINE_SEP = sLineSep.getBytes();
            BYTES_COMMIT = "COMMIT".getBytes("ISO-8859-1");
            BYTES_INSERT_INTO = "INSERT INTO ".getBytes("ISO-8859-1");
            BYTES_VALUES = " VALUES(".getBytes("ISO-8859-1");
            BYTES_TERM = ")".getBytes("ISO-8859-1");
            BYTES_DELETE_FROM = "DELETE FROM ".getBytes("ISO-8859-1");
            BYTES_WHERE = " WHERE ".getBytes("ISO-8859-1");
            BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes("ISO-8859-1");
            BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes("ISO-8859-1");
            BYTES_C_ID_INIT = "/*C".getBytes("ISO-8859-1");
            BYTES_C_ID_TERM = "*/".getBytes("ISO-8859-1");
            BYTES_SCHEMA = "SET SCHEMA ".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Error.runtimeError(401, "ScriptWriterText");
        }
    }
}

