/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import org.hsqldb.Row;
import org.hsqldb.persist.Crypto;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.types.Type;

public class RowOutputBinaryEncode
extends RowOutputBinary {
    final Crypto crypto;

    public RowOutputBinaryEncode(Crypto crypto, int initialSize, int scale) {
        super(initialSize, scale);
        this.crypto = crypto;
    }

    @Override
    public void writeData(Object[] data, Type[] types) {
        if (this.crypto == null) {
            super.writeData(data, types);
        } else {
            int start = this.count;
            this.writeInt(0);
            super.writeData(data, types);
            int origLength = this.count - start - 4;
            int newLength = this.crypto.encode(this.buffer, start + 4, origLength, this.buffer, start + 4);
            this.writeIntData(newLength, start);
            this.count = start + 4 + newLength;
        }
    }

    @Override
    public int getSize(Row row) {
        int size = super.getSize(row);
        if (this.crypto != null) {
            size = this.crypto.getEncodedSize(size - 4) + 8;
        }
        return size;
    }
}

