/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rights;

import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;

public final class UserManager {
    private HashMappedList userList;
    private GranteeManager granteeManager;

    public UserManager(Database database) {
        this.granteeManager = database.getGranteeManager();
        this.userList = new HashMappedList();
    }

    public User createUser(HsqlNameManager.HsqlName name, String password) {
        User user = this.granteeManager.addUser(name);
        user.setPassword(password);
        boolean success = this.userList.add(name.name, user);
        if (!success) {
            throw Error.error(4003, name.statementName);
        }
        return user;
    }

    public void dropUser(String name) {
        boolean reservedUser = GranteeManager.isReserved(name);
        if (reservedUser) {
            throw Error.error(4002, name);
        }
        boolean result = this.granteeManager.removeGrantee(name);
        if (!result) {
            throw Error.error(4001, name);
        }
        User user = (User)this.userList.remove(name);
        if (user == null) {
            throw Error.error(4001, name);
        }
    }

    public void createSAUser() {
        HsqlNameManager.HsqlName name = this.granteeManager.database.nameManager.newHsqlName("SA", false, 11);
        this.createUser(name, "");
        this.granteeManager.grant(name.name, "DBA", this.granteeManager.getDBARole());
    }

    public User getUser(String name, String password) {
        if (name == null) {
            name = "";
        }
        if (password == null) {
            password = "";
        }
        User user = this.get(name);
        user.checkPassword(password);
        return user;
    }

    public HashMappedList getUsers() {
        return this.userList;
    }

    public boolean exists(String name) {
        return this.userList.get(name) != null;
    }

    public User get(String name) {
        User user = (User)this.userList.get(name);
        if (user == null) {
            throw Error.error(4001, name);
        }
        return user;
    }

    public HsqlArrayList listVisibleUsers(Session session) {
        HsqlArrayList list = new HsqlArrayList();
        boolean isAdmin = session.isAdmin();
        String sessionName = session.getUsername();
        if (this.userList == null || this.userList.size() == 0) {
            return list;
        }
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            if (user == null) continue;
            String userName = user.getNameString();
            if (isAdmin) {
                list.add(user);
                continue;
            }
            if (!sessionName.equals(userName)) continue;
            list.add(user);
        }
        return list;
    }

    public User getSysUser() {
        return GranteeManager.systemAuthorisation;
    }

    public synchronized void removeSchemaReference(String schemaName) {
        for (int i = 0; i < this.userList.size(); ++i) {
            User user = (User)this.userList.get(i);
            HsqlNameManager.HsqlName schema = user.getInitialSchema();
            if (schema == null || !schemaName.equals(schema.name)) continue;
            user.setInitialSchema(null);
        }
    }

    public String[] getInitialSchemaSQL() {
        HsqlArrayList list = new HsqlArrayList(this.userList.size());
        for (int i = 0; i < this.userList.size(); ++i) {
            HsqlNameManager.HsqlName name;
            User user = (User)this.userList.get(i);
            if (user.isSystem || (name = user.getInitialSchema()) == null) continue;
            list.add(user.getInitialSchemaSQL());
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }
}

