/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.Crypto;
import org.hsqldb.result.Result;
import org.hsqldb.scriptio.ScriptReaderBase;
import org.hsqldb.scriptio.ScriptReaderDecode;
import org.hsqldb.scriptio.ScriptReaderText;

public class ScriptRunner {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runScript(Database database, String logFilename) {
        IntKeyHashMap sessionMap = new IntKeyHashMap();
        Session current = null;
        int currentId = 0;
        database.setReferentialIntegrity(false);
        ScriptReaderBase scr = null;
        StatementDML dummy = new StatementDML(81, 2004, null);
        try {
            StopWatch sw = new StopWatch();
            Crypto crypto = database.logger.getCrypto();
            scr = crypto == null ? new ScriptReaderText(database, logFilename) : new ScriptReaderDecode(database, logFilename, crypto, true);
            while (scr.readLoggedStatement(current)) {
                int sessionId = scr.getSessionNumber();
                if ((current == null || currentId != sessionId) && (current = (Session)sessionMap.get(currentId = sessionId)) == null) {
                    current = database.getSessionManager().newSession(database, database.getUserManager().getSysUser(), false, true, null, 0);
                    sessionMap.put(currentId, current);
                }
                if (current.isClosed()) {
                    sessionMap.remove(currentId);
                    continue;
                }
                Result result = null;
                int statementType = scr.getStatementType();
                switch (statementType) {
                    case 1: {
                        String statement = scr.getLoggedStatement();
                        result = current.executeDirectStatement(statement);
                        if (result == null || !result.isError()) break;
                        if (result.getException() != null) {
                            throw result.getException();
                        }
                        throw Error.error(result);
                    }
                    case 4: {
                        current.commit(false);
                        break;
                    }
                    case 3: {
                        current.beginAction(dummy);
                        Object[] data = scr.getData();
                        scr.getCurrentTable().insertNoCheckFromLog(current, data);
                        current.endAction(Result.updateOneResult);
                        break;
                    }
                    case 2: {
                        current.beginAction(dummy);
                        Object[] data = scr.getData();
                        scr.getCurrentTable().deleteNoCheckFromLog(current, data);
                        current.endAction(Result.updateOneResult);
                        break;
                    }
                    case 6: {
                        current.setSchema(scr.getCurrentSchema());
                    }
                }
                if (!current.isClosed()) continue;
                sessionMap.remove(currentId);
            }
        }
        catch (Throwable e) {
            if (e instanceof EOFException) {
            } else {
                if (e instanceof OutOfMemoryError) {
                    database.logger.logSevereEvent("out of memory processing " + logFilename + " line: " + scr.getLineNumber(), e);
                    throw Error.error(72);
                }
                database.logger.logSevereEvent(logFilename + " line: " + scr.getLineNumber(), e);
            }
        }
        finally {
            if (scr != null) {
                scr.close();
            }
            database.getSessionManager().closeAllSessions();
            database.setReferentialIntegrity(true);
        }
    }
}

