/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.TransactionManager;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;
    Table table;
    TransactionManager txManager;

    public RowStoreAVLDisk(PersistentStoreCollection manager, DataFileCache cache, Table table) {
        this.manager = manager;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = cache;
        if (cache != null) {
            this.rowOut = cache.rowOut.clone();
        }
        manager.setStore(table, this);
        this.txManager = table.database.txManager;
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    @Override
    public void set(CachedObject object) {
        Row row = (Row)object;
        this.txManager.setTransactionInfo(row);
    }

    @Override
    public CachedObject get(int key) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, false);
        return object;
    }

    @Override
    public CachedObject getKeep(int key) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, true);
        return object;
    }

    @Override
    public CachedObject get(int key, boolean keep) {
        CachedObject object = this.cache.get(key, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public CachedObject get(CachedObject object, boolean keep) {
        object = this.cache.get(object, (PersistentStore)this, keep);
        return object;
    }

    @Override
    public int getStorageSize(int i) {
        return this.cache.get(i, (PersistentStore)this, false).getStorageSize();
    }

    @Override
    public void add(CachedObject object) {
        int size = object.getRealSize(this.rowOut);
        size = this.rowOut.getStorageSize(size);
        object.setStorageSize(size);
        this.cache.add(object);
    }

    @Override
    public CachedObject get(RowInputInterface in) {
        try {
            return new RowAVLDisk((TableBase)this.table, in);
        }
        catch (IOException e) {
            throw Error.error(129, e);
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object) {
        RowAVLDisk row = new RowAVLDisk((TableBase)this.table, (Object[])object);
        this.add(row);
        if (session != null) {
            RowAction.addAction(session, (byte)1, this.table, row);
        }
        return row;
    }

    @Override
    public void removeAll() {
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(int i) {
        this.cache.remove(i, this);
    }

    @Override
    public void removePersistence(int i) {
    }

    @Override
    public void release(int i) {
        this.cache.release(i);
    }

    @Override
    public void commitPersistence(CachedObject row) {
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache cache) {
        this.cache = cache;
    }

    @Override
    public void release() {
        ArrayUtil.fillArray(this.accessorList, null);
        this.cache = null;
    }

    @Override
    public void setAccessor(Index key, CachedObject accessor) {
        Index index = key;
        this.accessorList[index.getPosition()] = accessor;
    }

    @Override
    public CachedObject getAccessor(Index key) {
        NodeAVL node = (NodeAVL)this.accessorList[key.getPosition()];
        if (node == null) {
            return null;
        }
        if (!node.isInMemory()) {
            RowAVL row = (RowAVL)this.get(node.getPos(), false);
            node = row.getNode(key.getPosition());
            this.accessorList[key.getPosition()] = node;
        }
        return node;
    }

    @Override
    public void setAccessor(Index key, int accessor) {
        CachedObject object = this.get(accessor, false);
        if (object != null) {
            NodeAVL node = ((RowAVL)object).getNode(key.getPosition());
            object = node;
        }
        this.setAccessor(key, object);
    }

    @Override
    public void resetAccessorKeys(Index[] keys) {
        if (this.indexList.length == 0 || this.indexList[0] == null || this.accessorList[0] == null) {
            this.indexList = keys;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(401, "RowStoreAVLDisk");
    }

    @Override
    public CachedObject getNewInstance(int size) {
        return null;
    }

    @Override
    public void lock() {
        this.cache.writeLock.lock();
    }

    @Override
    public void unlock() {
        this.cache.writeLock.unlock();
    }
}

