/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCBlob
implements Blob {
    public static final long MIN_POS = 1L;
    public static final long MAX_POS = 0x80000000L;
    private volatile byte[] data;
    private final boolean createdByConnection;
    private boolean getBinaryStreamUsesCopy;

    @Override
    public long length() throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        return ldata.length;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        int dlen = ldata.length;
        if (pos < 1L || pos > 1L + (long)dlen) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        if (length < 0 || (long)length > (long)dlen - --pos) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        byte[] out = new byte[length];
        System.arraycopy(ldata, (int)pos, out, 0, length);
        return out;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        return new ByteArrayInputStream(ldata);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        int dlen = ldata.length;
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        int plen = pattern.length;
        if (plen == 0 || --start > (long)(dlen - plen)) {
            return -1L;
        }
        int stop = dlen - plen;
        byte b0 = pattern[0];
        block0: for (int i = (int)start; i <= stop; ++i) {
            if (ldata[i] != b0) continue;
            int len = plen;
            int doffset = i;
            int poffset = 0;
            boolean match = true;
            while (len-- > 0) {
                if (ldata[doffset++] == pattern[poffset++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        int dlen = ldata.length;
        if (start < 1L) {
            throw Util.outOfRangeArgument("start: " + start);
        }
        if (start > (long)dlen || pattern == null) {
            return -1L;
        }
        long plen = pattern.length();
        if (plen == 0L || --start > (long)dlen - plen) {
            return -1L;
        }
        int iplen = (int)plen;
        byte[] bap = pattern instanceof JDBCBlob ? ((JDBCBlob)pattern).data() : pattern.getBytes(1L, iplen);
        int stop = dlen - iplen;
        byte b0 = bap[0];
        block0: for (int i = (int)start; i <= stop; ++i) {
            if (ldata[i] != b0) continue;
            int len = iplen;
            int doffset = i;
            int poffset = 0;
            while (len-- > 0) {
                if (ldata[doffset++] == bap[poffset++]) continue;
                continue block0;
            }
            return i + 1;
        }
        return -1L;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        if (bytes == null) {
            throw Util.nullArgument("bytes");
        }
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        if (bytes == null) {
            throw Util.nullArgument("bytes");
        }
        if (offset < 0 || offset > bytes.length) {
            throw Util.outOfRangeArgument("offset: " + offset);
        }
        if (len > bytes.length - offset) {
            throw Util.outOfRangeArgument("len: " + len);
        }
        if (pos < 1L || pos > 1L + (long)(Integer.MAX_VALUE - len)) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        byte[] ldata = this.data;
        this.checkValid(ldata);
        int dlen = ldata.length;
        if (--pos + (long)len > (long)dlen) {
            byte[] temp = new byte[(int)pos + len];
            System.arraycopy(ldata, 0, temp, 0, dlen);
            ldata = temp;
            temp = null;
        }
        System.arraycopy(bytes, offset, ldata, (int)pos, len);
        this.checkValid(this.data);
        this.data = ldata;
        return len;
    }

    @Override
    public OutputStream setBinaryStream(final long pos) throws SQLException {
        if (!this.createdByConnection) {
            throw Util.notSupported();
        }
        if (pos < 1L || pos > 0x80000000L) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        this.checkValid(this.data);
        return new ByteArrayOutputStream(){

            @Override
            public synchronized void close() throws IOException {
                try {
                    JDBCBlob.this.setBytes(pos, this.toByteArray());
                }
                catch (SQLException se) {
                    throw JavaSystem.toIOException(se);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long len) throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        if (len < 0L || len > (long)ldata.length) {
            throw Util.outOfRangeArgument("len: " + len);
        }
        if (len == (long)ldata.length) {
            return;
        }
        byte[] newData = new byte[(int)len];
        System.arraycopy(ldata, 0, newData, 0, (int)len);
        this.checkValid(this.data);
        this.data = newData;
    }

    @Override
    public void free() throws SQLException {
        this.data = null;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        int dlen = ldata.length;
        if (pos < 1L || pos > (long)dlen) {
            throw Util.outOfRangeArgument("pos: " + pos);
        }
        if (length < 0L || length > (long)dlen - --pos) {
            throw Util.outOfRangeArgument("length: " + length);
        }
        if (pos == 0L && length == (long)dlen) {
            return new ByteArrayInputStream(ldata);
        }
        byte[] out = new byte[(int)length];
        System.arraycopy(ldata, (int)pos, out, 0, (int)length);
        return new ByteArrayInputStream(out);
    }

    public void setGetBinaryStreamUsesCopy(boolean b) {
        this.getBinaryStreamUsesCopy = b;
    }

    public boolean isGetBinaryStreamUsesCopy() {
        return this.getBinaryStreamUsesCopy;
    }

    public JDBCBlob(byte[] data) throws SQLException {
        this.init(data);
        this.createdByConnection = false;
    }

    protected JDBCBlob() {
        this.data = new byte[0];
        this.createdByConnection = true;
    }

    protected void init(byte[] data) throws SQLException {
        if (data == null) {
            throw Util.nullArgument();
        }
        this.data = data;
    }

    protected void checkValid(Object data) {
        if (data == null) {
            throw new RuntimeException("null data");
        }
    }

    protected byte[] data() throws SQLException {
        byte[] ldata = this.data;
        this.checkValid(ldata);
        return ldata;
    }
}

