/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionAggregate;
import org.hsqldb.ExpressionArithmetic;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLike;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.ExpressionValue;
import org.hsqldb.FunctionCustom;
import org.hsqldb.FunctionSQL;
import org.hsqldb.FunctionSQLInvoked;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserBase;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementQuery;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.store.BaseHashMap;
import org.hsqldb.store.BitMap;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Charset;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;
import org.hsqldb.types.Types;

public class ParserDQL
extends ParserBase {
    protected Database database;
    protected Session session;
    protected final CompileContext compileContext;
    HsqlException lastError;

    ParserDQL(Session session, Scanner t) {
        super(t);
        this.session = session;
        this.database = session.getDatabase();
        this.compileContext = new CompileContext(session);
    }

    @Override
    void reset(String sql) {
        super.reset(sql);
        this.compileContext.reset();
        this.lastError = null;
    }

    void checkIsSchemaObjectName() {
        if (this.database.sqlEnforceNames) {
            this.checkIsNonReservedIdentifier();
        } else {
            this.checkIsNonCoreReservedIdentifier();
        }
    }

    Type readTypeDefinition(boolean includeUserTypes) {
        int typeNumber = Integer.MIN_VALUE;
        boolean hasLength = false;
        boolean hasScale = false;
        this.checkIsIdentifier();
        if (this.token.namePrefix == null) {
            typeNumber = Type.getTypeNr(this.token.tokenString);
        }
        if (typeNumber == Integer.MIN_VALUE) {
            if (includeUserTypes) {
                this.checkIsSchemaObjectName();
                String schemaName = this.session.getSchemaName(this.token.namePrefix);
                Type type = this.database.schemaManager.getDomain(this.token.tokenString, schemaName, false);
                if (type != null) {
                    this.read();
                    return type;
                }
            }
            throw Error.error(5509, this.token.tokenString);
        }
        this.read();
        switch (typeNumber) {
            case 1: {
                if (this.token.tokenType == 311) {
                    this.read();
                    typeNumber = 12;
                    break;
                }
                if (this.token.tokenType != 145) break;
                this.readThis(452);
                this.read();
                typeNumber = 40;
                break;
            }
            case 8: {
                if (this.token.tokenType != 210) break;
                this.read();
                break;
            }
            case 60: {
                if (this.token.tokenType == 311) {
                    this.read();
                    typeNumber = 61;
                    break;
                }
                if (this.token.tokenType != 145) break;
                this.readThis(452);
                this.read();
                typeNumber = 30;
                break;
            }
            case 14: {
                if (this.token.tokenType != 311) break;
                this.read();
                typeNumber = 15;
                break;
            }
            case 10: {
                return this.readIntervalType(false);
            }
        }
        long length = typeNumber == 93 ? 6L : 0L;
        int scale = 0;
        if (Types.requiresPrecision(typeNumber) && this.token.tokenType != 695 && this.database.sqlEnforceSize) {
            throw Error.error(5599, Type.getDefaultType(typeNumber).getNameString());
        }
        if (Types.acceptsPrecision(typeNumber)) {
            if (this.token.tokenType == 695) {
                int multiplier = 1;
                this.read();
                block7 : switch (this.token.tokenType) {
                    case 745: {
                        if (this.token.dataType.typeCode == 4 || this.token.dataType.typeCode == 25) break;
                        throw this.unexpectedToken();
                    }
                    case 752: {
                        if (typeNumber == 30 || typeNumber == 40) {
                            switch (this.token.lobMultiplierType) {
                                case 426: {
                                    multiplier = 1024;
                                    break block7;
                                }
                                case 434: {
                                    multiplier = 0x100000;
                                    break block7;
                                }
                                case 405: {
                                    multiplier = 0x40000000;
                                    break block7;
                                }
                            }
                            throw this.unexpectedToken();
                        }
                        throw this.unexpectedToken(this.token.getFullString());
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                hasLength = true;
                length = ((Number)this.token.tokenValue).longValue();
                if (length < 0L || length == 0L && !Types.acceptsZeroPrecision(typeNumber)) {
                    throw Error.error(5592);
                }
                length *= (long)multiplier;
                this.read();
                if (typeNumber == 1 || typeNumber == 12 || typeNumber == 40) {
                    if (this.token.tokenType == 355) {
                        this.read();
                    } else if (this.token.tokenType == 453) {
                        this.read();
                        length /= 2L;
                    }
                }
                if (Types.acceptsScaleCreateParam(typeNumber) && this.token.tokenType == 684) {
                    this.read();
                    scale = this.readInteger();
                    if (scale < 0) {
                        throw Error.error(5592);
                    }
                    hasScale = true;
                }
                this.readThis(682);
            } else if (typeNumber == 14) {
                length = 1L;
            } else if (typeNumber == 30 || typeNumber == 40) {
                length = 0x1000000L;
            } else if (this.database.sqlEnforceSize && (typeNumber == 1 || typeNumber == 60)) {
                length = 1L;
            }
            if (typeNumber == 93 || typeNumber == 92) {
                if (length > 9L) {
                    throw Error.error(5592);
                }
                scale = (int)length;
                length = 0L;
                if (this.token.tokenType == 317) {
                    this.read();
                    this.readThis(279);
                    this.readThis(546);
                    typeNumber = typeNumber == 93 ? 95 : 94;
                } else if (this.token.tokenType == 319) {
                    this.read();
                    this.readThis(279);
                    this.readThis(546);
                }
            }
        }
        switch (typeNumber) {
            case -1: {
                typeNumber = 12;
                if (hasLength) break;
                length = 0x100000L;
                break;
            }
            case -4: {
                typeNumber = 61;
                if (hasLength) break;
                length = 0x100000L;
                break;
            }
            case 1: 
            case 12: {
                if (hasLength || this.database.sqlEnforceSize) break;
                length = 32768L;
                break;
            }
            case 2: 
            case 3: {
                if (hasLength || hasScale || this.database.sqlEnforceSize) break;
                length = 100L;
                scale = 10;
            }
        }
        Type typeObject = Type.getType(typeNumber, 0, length, scale);
        if (typeObject.isCharacterType() && this.token.tokenType == 34) {
            this.read();
            this.readThis(252);
            this.checkIsSchemaObjectName();
            String schemaName = this.session.getSchemaName(this.token.namePrefix);
            Charset charset = (Charset)this.database.schemaManager.getSchemaObject(this.token.tokenString, schemaName, 14);
            this.read();
        }
        return typeObject;
    }

    void readSimpleColumnNames(OrderedHashSet columns, RangeVariable rangeVar) {
        do {
            ColumnSchema col = this.readSimpleColumnName(rangeVar);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5579, col.getName().name);
        } while (this.readIfThis(684));
        if (this.token.tokenType != 682) {
            throw this.unexpectedToken();
        }
    }

    void readColumnNames(OrderedHashSet columns, RangeVariable[] rangeVars) {
        do {
            ColumnSchema col = this.readColumnName(rangeVars);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5579, col.getName().name);
        } while (this.readIfThis(684));
        if (this.token.tokenType != 682) {
            throw this.unexpectedToken();
        }
    }

    void readColumnNamesForSelectInto(OrderedHashSet columns, RangeVariable[] rangeVars) {
        do {
            ColumnSchema col = this.readColumnName(rangeVars);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5579, col.getName().name);
        } while (this.readIfThis(684));
        if (this.token.tokenType != 114) {
            throw this.unexpectedToken();
        }
    }

    void readSimpleColumnNames(OrderedHashSet columns, Table table) {
        do {
            ColumnSchema col = this.readSimpleColumnName(table);
            if (columns.add(col.getName().name)) continue;
            throw Error.error(5577, col.getName().name);
        } while (this.readIfThis(684));
        if (this.token.tokenType != 682) {
            throw this.unexpectedToken();
        }
    }

    HsqlNameManager.HsqlName[] readColumnNames(HsqlNameManager.HsqlName tableName) {
        BitMap quotedFlags = new BitMap(32);
        OrderedHashSet set = this.readColumnNames(quotedFlags, false);
        HsqlNameManager.HsqlName[] colList = new HsqlNameManager.HsqlName[set.size()];
        for (int i = 0; i < colList.length; ++i) {
            String name = (String)set.get(i);
            boolean quoted = quotedFlags.isSet(i);
            colList[i] = this.database.nameManager.newHsqlName(tableName.schema, name, quoted, 9, tableName);
        }
        return colList;
    }

    OrderedHashSet readColumnNames(boolean readAscDesc) {
        return this.readColumnNames(null, readAscDesc);
    }

    OrderedHashSet readColumnNames(BitMap quotedFlags, boolean readAscDesc) {
        this.readThis(695);
        OrderedHashSet set = this.readColumnNameList(quotedFlags, readAscDesc);
        this.readThis(682);
        return set;
    }

    OrderedHashSet readColumnNameList(BitMap quotedFlags, boolean readAscDesc) {
        int i = 0;
        OrderedHashSet set = new OrderedHashSet();
        do {
            if (this.session.isProcessingScript) {
                if (!this.isSimpleName()) {
                    this.token.isDelimitedIdentifier = true;
                }
            } else {
                this.checkIsSimpleName();
            }
            if (!set.add(this.token.tokenString)) {
                throw Error.error(5577, this.token.tokenString);
            }
            if (quotedFlags != null && this.isDelimitedIdentifier()) {
                quotedFlags.set(i);
            }
            this.read();
            ++i;
            if (!readAscDesc || this.token.tokenType != 338 && this.token.tokenType != 389) continue;
            this.read();
        } while (this.readIfThis(684));
        return set;
    }

    SubQuery getViewSubquery(View v) {
        SubQuery sq = v.viewSubQuery;
        for (int i = 0; i < v.viewSubqueries.length; ++i) {
            this.compileContext.subQueryList.add(v.viewSubqueries[i]);
        }
        return sq;
    }

    int XreadUnionType() {
        int unionType = 0;
        switch (this.token.tokenType) {
            case 296: {
                this.read();
                unionType = 1;
                if (this.token.tokenType == 2) {
                    unionType = 2;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 84) break;
                this.read();
                break;
            }
            case 136: {
                this.read();
                unionType = 3;
                if (this.token.tokenType == 2) {
                    unionType = 4;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 84) break;
                this.read();
                break;
            }
            case 97: 
            case 584: {
                this.read();
                unionType = 6;
                if (this.token.tokenType == 2) {
                    unionType = 5;
                    this.read();
                    break;
                }
                if (this.token.tokenType != 84) break;
                this.read();
                break;
            }
        }
        return unionType;
    }

    void XreadUnionCorrespondingClause(QueryExpression queryExpression) {
        if (this.token.tokenType == 50) {
            this.read();
            queryExpression.setUnionCorresoponding();
            if (this.token.tokenType == 23) {
                this.read();
                OrderedHashSet names = this.readColumnNames(false);
                queryExpression.setUnionCorrespondingColumns(names);
            }
        }
    }

    QueryExpression XreadQueryExpression() {
        if (this.token.tokenType == 317) {
            throw super.unsupportedFeature();
        }
        QueryExpression queryExpression = this.XreadQueryExpressionBody();
        SortAndSlice sortAndSlice = this.XreadOrderByExpression();
        if (queryExpression.sortAndSlice == null) {
            queryExpression.addSortAndSlice(sortAndSlice);
        } else if (queryExpression.sortAndSlice.hasLimit()) {
            if (sortAndSlice.hasLimit()) {
                throw Error.error(5549);
            }
            for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                Expression e = (Expression)sortAndSlice.exprList.get(i);
                queryExpression.sortAndSlice.addOrderExpression(e);
            }
        } else {
            queryExpression.addSortAndSlice(sortAndSlice);
        }
        return queryExpression;
    }

    QueryExpression XreadQueryExpressionBody() {
        QueryExpression queryExpression = this.XreadQueryTerm();
        block3: while (true) {
            switch (this.token.tokenType) {
                case 97: 
                case 296: 
                case 584: {
                    queryExpression = this.XreadSetOperation(queryExpression);
                    continue block3;
                }
            }
            break;
        }
        return queryExpression;
    }

    QueryExpression XreadQueryTerm() {
        QueryExpression queryExpression = this.XreadQueryPrimary();
        while (this.token.tokenType == 136) {
            queryExpression = this.XreadSetOperation(queryExpression);
        }
        return queryExpression;
    }

    private QueryExpression XreadSetOperation(QueryExpression queryExpression) {
        queryExpression = new QueryExpression(this.compileContext, queryExpression);
        int unionType = this.XreadUnionType();
        this.XreadUnionCorrespondingClause(queryExpression);
        QueryExpression rightQueryExpression = this.XreadQueryTerm();
        queryExpression.addUnion(rightQueryExpression, unionType);
        return queryExpression;
    }

    QueryExpression XreadQueryPrimary() {
        switch (this.token.tokenType) {
            case 249: 
            case 276: 
            case 306: {
                QuerySpecification select = this.XreadSimpleTable();
                return select;
            }
            case 695: {
                this.read();
                QueryExpression queryExpression = this.XreadQueryExpressionBody();
                SortAndSlice sortAndSlice = this.XreadOrderByExpression();
                this.readThis(682);
                if (queryExpression.sortAndSlice == null) {
                    queryExpression.addSortAndSlice(sortAndSlice);
                } else if (queryExpression.sortAndSlice.hasLimit()) {
                    if (sortAndSlice.hasLimit()) {
                        throw Error.error(5549);
                    }
                    for (int i = 0; i < sortAndSlice.exprList.size(); ++i) {
                        Expression e = (Expression)sortAndSlice.exprList.get(i);
                        queryExpression.sortAndSlice.addOrderExpression(e);
                    }
                } else {
                    queryExpression.addSortAndSlice(sortAndSlice);
                }
                return queryExpression;
            }
        }
        throw this.unexpectedToken();
    }

    QuerySpecification XreadSimpleTable() {
        QuerySpecification select;
        switch (this.token.tokenType) {
            case 276: {
                this.read();
                Table table = this.readTableName();
                select = new QuerySpecification(this.session, table, this.compileContext);
                break;
            }
            case 306: {
                this.read();
                SubQuery sq = this.XreadRowValueExpressionList();
                select = new QuerySpecification(this.session, sq.getTable(), this.compileContext);
                break;
            }
            case 249: {
                select = this.XreadQuerySpecification();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        return select;
    }

    QuerySpecification XreadQuerySpecification() {
        QuerySpecification select = this.XreadSelect();
        this.XreadTableExpression(select);
        return select;
    }

    void XreadTableExpression(QuerySpecification select) {
        this.XreadFromClause(select);
        this.readWhereGroupHaving(select);
    }

    QuerySpecification XreadSelect() {
        QuerySpecification select;
        block7: {
            SortAndSlice sortAndSlice;
            select = new QuerySpecification(this.compileContext);
            this.readThis(249);
            if ((this.token.tokenType == 670 || this.token.tokenType == 578) && (sortAndSlice = this.XreadTopOrLimit()) != null) {
                select.addSortAndSlice(sortAndSlice);
            }
            if (this.token.tokenType == 84) {
                select.isDistinctSelect = true;
                this.read();
            } else if (this.token.tokenType == 2) {
                this.read();
            }
            do {
                Expression e = this.XreadValueExpression();
                if (this.token.tokenType == 9) {
                    this.read();
                    this.checkIsNonCoreReservedIdentifier();
                }
                if (this.isNonCoreReservedIdentifier()) {
                    e.setAlias(HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier()));
                    this.read();
                }
                select.addSelectColumnExpression(e);
                if (this.token.tokenType == 114 || this.token.tokenType == 139) break block7;
            } while (this.readIfThis(684));
            throw this.unexpectedToken();
        }
        return select;
    }

    void XreadFromClause(QuerySpecification select) {
        this.readThis(114);
        do {
            this.XreadTableReference(select);
        } while (this.readIfThis(684));
    }

    void XreadTableReference(QuerySpecification select) {
        boolean natural = false;
        RangeVariable range = this.readTableOrSubquery();
        select.addRangeVariable(range);
        block16: while (true) {
            int type = this.token.tokenType;
            boolean left = false;
            boolean right = false;
            boolean end = false;
            type = this.token.tokenType;
            switch (this.token.tokenType) {
                case 130: {
                    this.read();
                    this.readThis(142);
                    break;
                }
                case 55: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(142);
                    break;
                }
                case 296: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    int position = this.getPosition();
                    this.read();
                    if (this.token.tokenType == 142) {
                        this.read();
                        break;
                    }
                    this.rewind(position);
                    end = true;
                    break;
                }
                case 174: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    natural = true;
                    continue block16;
                }
                case 151: {
                    this.read();
                    this.readIfThis(198);
                    this.readThis(142);
                    left = true;
                    break;
                }
                case 238: {
                    this.read();
                    this.readIfThis(198);
                    this.readThis(142);
                    right = true;
                    break;
                }
                case 115: {
                    this.read();
                    this.readIfThis(198);
                    this.readThis(142);
                    left = true;
                    right = true;
                    break;
                }
                case 142: {
                    this.read();
                    type = 130;
                    break;
                }
                case 684: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    type = 55;
                    break;
                }
                default: {
                    if (natural) {
                        throw this.unexpectedToken();
                    }
                    end = true;
                }
            }
            if (end) break;
            range = this.readTableOrSubquery();
            Expression condition = null;
            switch (type) {
                case 55: {
                    select.addRangeVariable(range);
                    break;
                }
                case 296: {
                    select.addRangeVariable(range);
                    condition = Expression.EXPR_FALSE;
                    range.setJoinType(true, true);
                    break;
                }
                case 115: 
                case 130: 
                case 151: 
                case 238: {
                    OrderedHashSet columns;
                    if (natural) {
                        columns = range.getUniqueColumnNameSet();
                        condition = select.getEquiJoinExpressions(columns, range, false);
                        select.addRangeVariable(range);
                    } else if (this.token.tokenType == 304) {
                        this.read();
                        columns = new OrderedHashSet();
                        this.readThis(695);
                        this.readSimpleColumnNames(columns, range);
                        this.readThis(682);
                        condition = select.getEquiJoinExpressions(columns, range, true);
                        select.addRangeVariable(range);
                    } else if (this.token.tokenType == 192) {
                        this.read();
                        condition = this.XreadBooleanValueExpression();
                        select.addRangeVariable(range);
                    } else {
                        throw Error.error(5581);
                    }
                    range.setJoinType(left, right);
                }
            }
            range.addJoinCondition(condition);
            natural = false;
        }
    }

    Expression getRowExpression(OrderedHashSet columnNames) {
        Expression[] elements = new Expression[columnNames.size()];
        for (int i = 0; i < elements.length; ++i) {
            String name = (String)columnNames.get(i);
            elements[i] = new ExpressionColumn(null, null, name);
        }
        return new Expression(25, elements);
    }

    void readWhereGroupHaving(QuerySpecification select) {
        Expression e;
        if (this.token.tokenType == 314) {
            this.read();
            e = this.XreadBooleanValueExpression();
            select.addQueryCondition(e);
        }
        if (this.token.tokenType == 121) {
            this.read();
            this.readThis(23);
            while (true) {
                e = this.XreadValueExpression();
                select.addGroupByColumnExpression(e);
                if (this.token.tokenType != 684) break;
                this.read();
            }
        }
        if (this.token.tokenType == 124) {
            this.read();
            e = this.XreadBooleanValueExpression();
            select.addHavingExpression(e);
        }
    }

    SortAndSlice XreadOrderByExpression() {
        SortAndSlice sortAndSlice = null;
        if (this.token.tokenType == 196) {
            this.read();
            this.readThis(23);
            sortAndSlice = this.XreadOrderBy();
        }
        if (this.token.tokenType == 578 || this.token.tokenType == 106 || this.token.tokenType == 190) {
            if (sortAndSlice == null) {
                sortAndSlice = new SortAndSlice();
            }
            this.XreadLimit(sortAndSlice);
        }
        return sortAndSlice == null ? SortAndSlice.noSort : sortAndSlice;
    }

    private SortAndSlice XreadTopOrLimit() {
        int position;
        Expression e1 = null;
        Expression e2 = null;
        if (this.token.tokenType == 578) {
            position = this.getPosition();
            this.read();
            e1 = this.XreadSimpleValueSpecificationOrNull();
            if (e1 == null) {
                super.rewind(position);
                return null;
            }
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                throw Error.error(5565, 153);
            }
        } else if (this.token.tokenType == 670) {
            position = this.getPosition();
            this.read();
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                super.rewind(position);
                return null;
            }
            e1 = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        boolean valid = true;
        if (e1.isParam()) {
            e1.setDataType(this.session, Type.SQL_INTEGER);
        } else {
            boolean bl = valid = e1.getDataType().typeCode == 4 && (Integer)e1.getValue(null) >= 0;
        }
        if (e2.isParam()) {
            e2.setDataType(this.session, Type.SQL_INTEGER);
        } else {
            valid &= e2.getDataType().typeCode == 4 && (Integer)e2.getValue(null) >= 0;
        }
        if (valid) {
            SortAndSlice sortAndSlice = new SortAndSlice();
            sortAndSlice.addLimitCondition(new ExpressionOp(95, e1, e2));
            return sortAndSlice;
        }
        throw Error.error(5565, 153);
    }

    private void XreadLimit(SortAndSlice sortAndSlice) {
        Expression e1 = null;
        Expression e2 = null;
        if (this.token.tokenType == 190) {
            this.read();
            e1 = this.XreadSimpleValueSpecificationOrNull();
            if (e1 == null) {
                throw Error.error(5565, 153);
            }
        }
        if (this.token.tokenType == 578) {
            this.read();
            e2 = this.XreadSimpleValueSpecificationOrNull();
            if (e2 == null) {
                throw Error.error(5565, 153);
            }
            if (e1 == null && this.token.tokenType == 190) {
                this.read();
                e1 = this.XreadSimpleValueSpecificationOrNull();
            }
        } else if (this.token.tokenType == 106) {
            this.read();
            if (this.token.tokenType == 401 || this.token.tokenType == 447) {
                this.read();
            }
            if ((e2 = this.XreadSimpleValueSpecificationOrNull()) == null) {
                e2 = new ExpressionValue(ValuePool.INTEGER_1, Type.SQL_INTEGER);
            }
            if (this.token.tokenType == 241 || this.token.tokenType == 243) {
                this.read();
            }
            this.readThis(193);
        }
        if (e1 == null) {
            e1 = new ExpressionValue(ValuePool.INTEGER_0, Type.SQL_INTEGER);
        }
        boolean valid = true;
        if (e1.isParam()) {
            e1.setDataType(this.session, Type.SQL_INTEGER);
        } else {
            boolean bl = valid = e1.getDataType().typeCode == 4 && (Integer)e1.getValue(null) >= 0;
        }
        if (e2.isParam()) {
            e2.setDataType(this.session, Type.SQL_INTEGER);
        } else {
            valid &= e2.getDataType().typeCode == 4 && (Integer)e2.getValue(null) >= 0;
        }
        if (valid) {
            sortAndSlice.addLimitCondition(new ExpressionOp(95, e1, e2));
            return;
        }
        throw Error.error(5565, 153);
    }

    private SortAndSlice XreadOrderBy() {
        SortAndSlice sortAndSlice = new SortAndSlice();
        while (true) {
            Expression e = this.XreadValueExpression();
            ExpressionOrderBy o = new ExpressionOrderBy(e);
            if (this.token.tokenType == 389) {
                o.setDescending();
                this.read();
            } else if (this.token.tokenType == 338) {
                this.read();
            }
            if (this.token.tokenType == 450) {
                this.read();
                if (this.token.tokenType == 401) {
                    this.read();
                } else if (this.token.tokenType == 430) {
                    this.read();
                    o.setNullsLast();
                } else {
                    throw this.unexpectedToken();
                }
            }
            sortAndSlice.addOrderExpression(o);
            if (this.token.tokenType != 684) break;
            this.read();
        }
        return sortAndSlice;
    }

    protected RangeVariable readSimpleRangeVariable(int operation) {
        Table table = this.readTableName();
        HsqlNameManager.SimpleName alias = null;
        if (operation != 19) {
            if (this.token.tokenType == 9) {
                this.read();
                this.checkIsNonCoreReservedIdentifier();
            }
            if (this.isNonCoreReservedIdentifier()) {
                alias = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
                this.read();
            }
        }
        if (table.isView) {
            switch (operation) {
                case 128: {
                    if (table.isUpdatable() && table.isInsertable()) break;
                    throw Error.error(5545);
                }
                case 19: 
                case 82: {
                    if (table.isUpdatable()) break;
                    throw Error.error(5545);
                }
            }
            SubQuery sq = this.getViewSubquery((View)table);
            table = sq.getTable();
        }
        RangeVariable range = new RangeVariable(table, alias, null, null, this.compileContext);
        return range;
    }

    protected RangeVariable readTableOrSubquery() {
        Table table = null;
        HsqlNameManager.SimpleName alias = null;
        BaseHashMap columnList = null;
        BitMap columnNameQuoted = null;
        HsqlNameManager.SimpleName[] columnNameList = null;
        if (this.token.tokenType == 695) {
            Expression e = this.XreadTableSubqueryOrJoinedTable();
            table = e.subQuery.getTable();
        } else {
            table = this.readTableName();
            if (table.isView()) {
                SubQuery sq = this.getViewSubquery((View)table);
                table = sq.getTable();
            }
        }
        boolean hasAs = false;
        if (this.token.tokenType == 9) {
            this.read();
            this.checkIsNonCoreReservedIdentifier();
            hasAs = true;
        }
        if (this.isNonCoreReservedIdentifier()) {
            boolean limit = this.token.tokenType == 578 || this.token.tokenType == 190;
            int position = this.getPosition();
            alias = HsqlNameManager.getSimpleName(this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            if (this.token.tokenType == 695) {
                columnNameQuoted = new BitMap(32);
                columnList = this.readColumnNames(columnNameQuoted, false);
            } else if (!hasAs && limit && (this.token.tokenType == 697 || this.token.tokenType == 745)) {
                alias = null;
                this.rewind(position);
            }
        }
        if (columnList != null) {
            if (table.getColumnCount() != columnList.size()) {
                throw Error.error(5593);
            }
            columnNameList = new HsqlNameManager.SimpleName[columnList.size()];
            for (int i = 0; i < columnList.size(); ++i) {
                HsqlNameManager.SimpleName name;
                columnNameList[i] = name = HsqlNameManager.getSimpleName((String)((OrderedHashSet)columnList).get(i), columnNameQuoted.isSet(i));
            }
        }
        RangeVariable range = new RangeVariable(table, alias, (OrderedHashSet)columnList, columnNameList, this.compileContext);
        return range;
    }

    private Expression readAggregate() {
        int tokenT = this.token.tokenType;
        this.read();
        this.readThis(695);
        Expression e = this.readAggregateExpression(tokenT);
        this.readThis(682);
        return e;
    }

    private Expression readAggregateExpression(int tokenT) {
        int type = ParserDQL.getExpressionType(tokenT);
        boolean distinct = false;
        boolean all = false;
        if (this.token.tokenType == 84) {
            distinct = true;
            this.read();
        } else if (this.token.tokenType == 2) {
            all = true;
            this.read();
        }
        Expression e = this.XreadValueExpression();
        switch (type) {
            case 71: {
                if (e.getType() != 97) break;
                if (((ExpressionColumn)e).tableName != null) {
                    throw this.unexpectedToken();
                }
                if (all || distinct) {
                    throw this.unexpectedToken();
                }
                e.opType = 9;
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                if (!all && !distinct) break;
                throw Error.error(5582, all ? "ALL" : "DISTINCT");
            }
            default: {
                if (e.getType() != 9) break;
                throw this.unexpectedToken();
            }
        }
        ExpressionAggregate aggregateExp = new ExpressionAggregate(type, distinct, e);
        return aggregateExp;
    }

    Expression XreadValueSpecificationOrNull() {
        Expression e = null;
        boolean minus = false;
        switch (this.token.tokenType) {
            case 696: {
                this.read();
                break;
            }
            case 693: {
                this.read();
                minus = true;
            }
        }
        e = this.XreadUnsignedValueSpecificationOrNull();
        if (e == null) {
            return null;
        }
        if (minus) {
            e = new ExpressionArithmetic(31, e);
        }
        return e;
    }

    Expression XreadUnsignedValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 292: {
                this.read();
                return Expression.EXPR_TRUE;
            }
            case 105: {
                this.read();
                return Expression.EXPR_FALSE;
            }
            case 77: {
                if (!this.compileContext.contextuallyTypedExpression) break;
                this.read();
                ExpressionColumn e = new ExpressionColumn(4);
                return e;
            }
            case 184: {
                ExpressionValue e = new ExpressionValue(null, null);
                this.read();
                return e;
            }
            case 745: {
                ExpressionValue e = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return e;
            }
            case 746: 
            case 747: {
                if (!this.token.isHostParameter) {
                    return null;
                }
            }
            case 697: {
                ExpressionColumn e = new ExpressionColumn(8);
                this.compileContext.parameters.add(e);
                this.read();
                return e;
            }
            case 358: {
                return this.XreadCurrentCollationSpec();
            }
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 251: 
            case 275: 
            case 303: 
            case 305: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    return null;
                }
                return this.readSQLFunction(function);
            }
        }
        return null;
    }

    Expression XreadSimpleValueSpecificationOrNull() {
        switch (this.token.tokenType) {
            case 745: {
                ExpressionValue e = new ExpressionValue(this.token.tokenValue, this.token.dataType);
                this.read();
                return e;
            }
            case 697: {
                ExpressionColumn e = new ExpressionColumn(8);
                this.compileContext.parameters.add(e);
                this.read();
                return e;
            }
        }
        return null;
    }

    Expression XreadAllTypesValueExpressionPrimary(boolean boole) {
        Expression e = null;
        switch (this.token.tokenType) {
            case 100: 
            case 297: {
                if (!boole) break;
                return this.XreadPredicate();
            }
            case 241: {
                if (boole) break;
                this.read();
                this.readThis(695);
                e = this.XreadRowElementList(true);
                this.readThis(682);
                break;
            }
            default: {
                e = this.XreadSimpleValueExpressionPrimary();
            }
        }
        if (e == null && this.token.tokenType == 695) {
            this.read();
            e = this.XreadRowElementList(true);
            this.readThis(682);
        }
        if (boole && e != null) {
            e = this.XreadPredicateRightPart(e);
        }
        return e;
    }

    Expression XreadValueExpressionPrimary() {
        Expression e = this.XreadSimpleValueExpressionPrimary();
        if (e != null) {
            return e;
        }
        if (this.token.tokenType != 695) {
            return null;
        }
        this.read();
        e = this.XreadValueExpression();
        this.readThis(682);
        return e;
    }

    Expression XreadSimpleValueExpressionPrimary() {
        Expression e = this.XreadUnsignedValueSpecificationOrNull();
        if (e != null) {
            return e;
        }
        switch (this.token.tokenType) {
            case 695: {
                int position = this.getPosition();
                this.read();
                int subqueryPosition = this.getPosition();
                this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 249: 
                    case 276: 
                    case 306: {
                        SubQuery sq = null;
                        this.rewind(subqueryPosition);
                        try {
                            sq = this.XreadSubqueryBody(false, 21);
                            this.readThis(682);
                        }
                        catch (HsqlException ex) {
                            this.compileContext.resetSubQueryLevel();
                            ex.setLevel(this.compileContext.subQueryDepth);
                            if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                                this.lastError = ex;
                            }
                            this.rewind(position);
                            return null;
                        }
                        if (!sq.queryExpression.isSingleColumn()) {
                            throw Error.error(1000);
                        }
                        return new Expression(21, sq);
                    }
                }
                this.rewind(position);
                return null;
            }
            case 681: {
                e = new ExpressionColumn(this.token.namePrePrefix, this.token.namePrefix);
                this.recordExpressionForToken((ExpressionColumn)e);
                this.read();
                return e;
            }
            case 558: {
                return this.readCaseWhenExpression();
            }
            case 28: {
                return this.readCaseExpression();
            }
            case 185: {
                return this.readNullIfExpression();
            }
            case 39: 
            case 631: {
                return this.readCoalesceExpression();
            }
            case 29: 
            case 48: {
                return this.readCastExpression();
            }
            case 71: 
            case 138: 
            case 279: 
            case 280: {
                e = this.readDateTimeIntervalLiteral();
                if (e == null) break;
                return e;
            }
            case 6: 
            case 15: 
            case 51: 
            case 96: 
            case 161: 
            case 166: 
            case 256: 
            case 267: 
            case 268: 
            case 272: 
            case 307: 
            case 308: {
                return this.readAggregate();
            }
            case 447: {
                return this.readSequenceExpression();
            }
            case 151: 
            case 238: {
                break;
            }
            default: {
                if (!this.isCoreReservedKey()) break;
                throw this.unexpectedToken();
            }
        }
        return this.readColumnOrFunctionExpression();
    }

    Expression XreadAllTypesPrimary(boolean boole) {
        Expression e = null;
        switch (this.token.tokenType) {
            case 1: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 102: 
            case 104: 
            case 110: 
            case 154: 
            case 159: 
            case 168: 
            case 180: 
            case 187: 
            case 188: 
            case 201: 
            case 207: 
            case 208: 
            case 209: 
            case 263: 
            case 270: 
            case 271: 
            case 286: 
            case 290: 
            case 302: 
            case 315: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw this.unsupportedFeature();
                }
                e = this.readSQLFunction(function);
                if (e != null) break;
            }
            default: {
                e = this.XreadAllTypesValueExpressionPrimary(boole);
            }
        }
        e = this.XreadModifier(e);
        return e;
    }

    Expression XreadModifier(Expression e) {
        switch (this.token.tokenType) {
            case 12: {
                this.read();
                Expression e1 = null;
                if (this.token.tokenType == 155) {
                    this.read();
                } else {
                    this.readThis(279);
                    this.readThis(546);
                    e1 = this.XreadValueExpressionPrimary();
                    switch (this.token.tokenType) {
                        case 72: 
                        case 126: 
                        case 167: 
                        case 171: 
                        case 248: 
                        case 321: {
                            IntervalType type = this.readIntervalType(false);
                            if (e1.getType() == 33) {
                                e1.dataType = type;
                                break;
                            }
                            e1 = new ExpressionOp(e1, type);
                        }
                    }
                }
                e = new ExpressionOp(92, e, e1);
                break;
            }
            case 72: 
            case 126: 
            case 167: 
            case 171: 
            case 248: 
            case 321: {
                IntervalType type = this.readIntervalType(true);
                if (e.getType() == 33) {
                    e.dataType = type;
                    break;
                }
                e = new ExpressionOp(e, type);
                break;
            }
            case 40: {
                this.read();
                SchemaObject schemaObject = this.database.schemaManager.getSchemaObject(this.token.namePrefix, this.token.tokenString, 15);
            }
        }
        return e;
    }

    Expression XreadValueExpressionWithContext() {
        this.compileContext.contextuallyTypedExpression = true;
        Expression e = this.XreadValueExpressionOrNull();
        this.compileContext.contextuallyTypedExpression = false;
        return e;
    }

    Expression XreadValueExpressionOrNull() {
        return this.XreadAllTypesCommonValueExpression(true);
    }

    Expression XreadValueExpression() {
        return this.XreadAllTypesCommonValueExpression(true);
    }

    Expression XreadRowOrCommonValueExpression() {
        return this.XreadAllTypesCommonValueExpression(false);
    }

    Expression XreadAllTypesCommonValueExpression(boolean boole) {
        Expression e = this.XreadAllTypesTerm(boole);
        int type = 0;
        boolean end = false;
        while (true) {
            switch (this.token.tokenType) {
                case 696: {
                    type = 32;
                    boole = false;
                    break;
                }
                case 693: {
                    type = 33;
                    boole = false;
                    break;
                }
                case 685: {
                    type = 36;
                    boole = false;
                    break;
                }
                case 195: {
                    if (boole) {
                        type = 50;
                        break;
                    }
                }
                default: {
                    end = true;
                }
            }
            if (end) break;
            this.read();
            Expression a = e;
            e = this.XreadAllTypesTerm(boole);
            e = boole ? new ExpressionLogical(type, a, e) : new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadAllTypesTerm(boolean boole) {
        Expression e = this.XreadAllTypesFactor(boole);
        int type = 0;
        boolean end = false;
        while (true) {
            switch (this.token.tokenType) {
                case 681: {
                    type = 34;
                    boole = false;
                    break;
                }
                case 686: {
                    type = 35;
                    boole = false;
                    break;
                }
                case 5: {
                    if (boole) {
                        type = 49;
                        break;
                    }
                }
                default: {
                    end = true;
                }
            }
            if (end) break;
            this.read();
            Expression a = e;
            e = this.XreadAllTypesFactor(boole);
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = boole ? new ExpressionLogical(type, a, e) : new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadAllTypesFactor(boolean boole) {
        boolean minus = false;
        boolean not = false;
        boolean unknown = false;
        switch (this.token.tokenType) {
            case 696: {
                this.read();
                boole = false;
                break;
            }
            case 693: {
                this.read();
                boole = false;
                minus = true;
                break;
            }
            case 181: {
                if (!boole) break;
                this.read();
                not = true;
            }
        }
        Expression e = this.XreadAllTypesPrimary(boole);
        if (boole && this.token.tokenType == 140) {
            this.read();
            if (this.token.tokenType == 181) {
                this.read();
                boolean bl = not = !not;
            }
            if (this.token.tokenType == 292) {
                this.read();
            } else if (this.token.tokenType == 105) {
                this.read();
                not = !not;
            } else if (this.token.tokenType == 298) {
                this.read();
                unknown = true;
            } else {
                throw this.unexpectedToken();
            }
        }
        if (unknown) {
            e = new ExpressionLogical(47, e);
        } else if (minus) {
            e = new ExpressionArithmetic(31, e);
        } else if (not) {
            e = new ExpressionLogical(48, e);
        }
        return e;
    }

    Expression XreadStringValueExpression() {
        return this.XreadCharacterValueExpression();
    }

    Expression XreadCharacterValueExpression() {
        Expression e = this.XreadCharacterPrimary();
        SchemaObject collation = this.readCollateClauseOrNull();
        while (this.token.tokenType == 685) {
            this.read();
            Expression a = e;
            e = this.XreadCharacterPrimary();
            collation = this.readCollateClauseOrNull();
            e = new ExpressionArithmetic(36, a, e);
        }
        return e;
    }

    Expression XreadCharacterPrimary() {
        switch (this.token.tokenType) {
            case 159: 
            case 201: 
            case 270: 
            case 290: 
            case 302: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                Expression e = this.readSQLFunction(function);
                if (e == null) break;
                return e;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericPrimary() {
        switch (this.token.tokenType) {
            case 1: 
            case 26: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 102: 
            case 104: 
            case 110: 
            case 154: 
            case 168: 
            case 188: 
            case 207: 
            case 209: 
            case 263: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw super.unexpectedToken();
                }
                Expression e = this.readSQLFunction(function);
                if (e == null) break;
                return e;
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadNumericValueExpression() {
        Expression e = this.XreadTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 696) {
                type = 32;
            } else {
                if (this.token.tokenType != 693) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadTerm() {
        Expression e = this.XreadFactor();
        while (true) {
            int type;
            if (this.token.tokenType == 681) {
                type = 34;
            } else {
                if (this.token.tokenType != 686) break;
                type = 35;
            }
            this.read();
            Expression a = e;
            e = this.XreadFactor();
            if (e == null) {
                throw this.unexpectedToken();
            }
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadFactor() {
        boolean minus = false;
        if (this.token.tokenType == 696) {
            this.read();
        } else if (this.token.tokenType == 693) {
            this.read();
            minus = true;
        }
        Expression e = this.XreadNumericPrimary();
        if (e == null) {
            return null;
        }
        if (minus) {
            e = new ExpressionArithmetic(31, e);
        }
        return e;
    }

    Expression XreadDatetimeValueExpression() {
        Expression e = this.XreadDateTimeIntervalTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 696) {
                type = 32;
            } else {
                if (this.token.tokenType != 693) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadDateTimeIntervalTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadIntervalValueExpression() {
        Expression e = this.XreadDateTimeIntervalTerm();
        while (true) {
            int type;
            if (this.token.tokenType == 696) {
                type = 32;
            } else {
                if (this.token.tokenType != 693) break;
                type = 33;
            }
            this.read();
            Expression a = e;
            e = this.XreadDateTimeIntervalTerm();
            e = new ExpressionArithmetic(type, a, e);
        }
        return e;
    }

    Expression XreadDateTimeIntervalTerm() {
        switch (this.token.tokenType) {
            case 1: 
            case 60: 
            case 65: 
            case 66: 
            case 156: 
            case 157: {
                FunctionSQL function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                if (function == null) {
                    throw super.unexpectedToken();
                }
                return this.readSQLFunction(function);
            }
        }
        return this.XreadValueExpressionPrimary();
    }

    Expression XreadDateTimeValueFunctionOrNull() {
        FunctionSQL function = null;
        switch (this.token.tokenType) {
            case 60: 
            case 65: 
            case 66: 
            case 156: 
            case 157: {
                function = FunctionSQL.newSQLFunction(this.token.tokenString, this.compileContext);
                break;
            }
            case 646: 
            case 669: {
                function = FunctionCustom.newCustomFunction(this.token.tokenString, this.token.tokenType);
                break;
            }
            default: {
                return null;
            }
        }
        if (function == null) {
            throw super.unexpectedToken();
        }
        return this.readSQLFunction(function);
    }

    Expression XreadBooleanValueExpression() {
        try {
            Expression e = this.XreadBooleanTermOrNull();
            if (e == null) {
                throw Error.error(5568);
            }
            while (this.token.tokenType == 195) {
                int type = 50;
                this.read();
                Expression a = e;
                e = this.XreadBooleanTermOrNull();
                e = new ExpressionLogical(type, a, e);
            }
            if (e == null) {
                throw Error.error(5568);
            }
            return e;
        }
        catch (HsqlException ex) {
            ex.setLevel(this.compileContext.subQueryDepth);
            if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                this.lastError = ex;
            }
            throw this.lastError;
        }
    }

    Expression XreadBooleanTermOrNull() {
        Expression e = this.XreadBooleanFactorOrNull();
        while (this.token.tokenType == 5) {
            int type = 49;
            this.read();
            Expression a = e;
            e = this.XreadBooleanFactorOrNull();
            e = new ExpressionLogical(type, a, e);
        }
        return e;
    }

    Expression XreadBooleanFactorOrNull() {
        Expression e;
        boolean not = false;
        boolean unknown = false;
        if (this.token.tokenType == 181) {
            this.read();
            not = true;
        }
        if ((e = this.XreadBooleanPrimaryOrNull()) == null) {
            return null;
        }
        if (this.token.tokenType == 140) {
            this.read();
            if (this.token.tokenType == 181) {
                this.read();
                boolean bl = not = !not;
            }
            if (this.token.tokenType == 292) {
                this.read();
            } else if (this.token.tokenType == 105) {
                not = !not;
                this.read();
            } else if (this.token.tokenType == 298) {
                unknown = true;
                this.read();
            } else {
                throw this.unexpectedToken();
            }
        }
        if (unknown) {
            e = new ExpressionLogical(47, e);
        }
        if (not) {
            e = new ExpressionLogical(48, e);
        }
        return e;
    }

    Expression XreadBooleanPrimaryOrNull() {
        int position;
        Expression e = null;
        switch (this.token.tokenType) {
            case 100: 
            case 297: {
                return this.XreadPredicate();
            }
            case 241: {
                this.read();
                this.readThis(695);
                e = this.XreadRowElementList(true);
                this.readThis(682);
                break;
            }
            default: {
                position = this.getPosition();
                try {
                    e = this.XreadAllTypesCommonValueExpression(false);
                    break;
                }
                catch (HsqlException ex) {
                    ex.setLevel(this.compileContext.subQueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                        this.lastError = ex;
                    }
                    this.rewind(position);
                }
            }
        }
        if (e == null && this.token.tokenType == 695) {
            this.read();
            position = this.getPosition();
            try {
                e = this.XreadRowElementList(true);
                this.readThis(682);
            }
            catch (HsqlException ex) {
                ex.setLevel(this.compileContext.subQueryDepth);
                if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                    this.lastError = ex;
                }
                this.rewind(position);
                e = this.XreadBooleanValueExpression();
                this.readThis(682);
            }
        }
        if (e != null) {
            e = this.XreadPredicateRightPart(e);
        }
        return e;
    }

    Expression XreadBooleanPredicand() {
        if (this.token.tokenType == 695) {
            this.read();
            Expression e = this.XreadBooleanValueExpression();
            this.readThis(682);
            return e;
        }
        return this.XreadSimpleValueExpressionPrimary();
    }

    Expression XreadPredicate() {
        switch (this.token.tokenType) {
            case 100: {
                this.read();
                Expression s = this.XreadTableSubqueryForPredicate(55);
                return new ExpressionLogical(55, s);
            }
            case 297: {
                this.read();
                Expression s = this.XreadTableSubqueryForPredicate(57);
                return new ExpressionLogical(57, s);
            }
        }
        Expression a = this.XreadRowValuePredicand();
        return this.XreadPredicateRightPart(a);
    }

    Expression XreadPredicateRightPart(Expression l) {
        boolean hasNot = false;
        ExpressionLogical e = null;
        if (this.token.tokenType == 181) {
            this.read();
            hasNot = true;
        }
        block0 : switch (this.token.tokenType) {
            case 140: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (this.token.tokenType == 181) {
                    hasNot = true;
                    this.read();
                }
                if (this.token.tokenType == 84) {
                    this.read();
                    this.readThis(114);
                    Expression r = this.XreadRowValuePredicand();
                    e = new ExpressionLogical(58, l, r);
                    hasNot = !hasNot;
                    break;
                }
                if (this.token.tokenType == 184 || this.token.tokenType == 298) {
                    this.read();
                    e = new ExpressionLogical(47, l);
                    break;
                }
                throw this.unexpectedToken();
            }
            case 152: {
                e = this.XreadLikePredicateRightPart(l);
                e.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 17: {
                e = this.XreadBetweenPredicateRightPart(l);
                break;
            }
            case 128: {
                e = this.XreadInPredicateRightPart(l);
                e.noOptimisation = this.isCheckOrTriggerCondition;
                break;
            }
            case 200: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                e = this.XreadOverlapsPredicateRightPart(l);
                break;
            }
            case 396: 
            case 680: 
            case 690: 
            case 691: 
            case 692: 
            case 694: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                int type = ParserDQL.getExpressionType(this.token.tokenType);
                this.read();
                switch (this.token.tokenType) {
                    case 2: 
                    case 6: 
                    case 256: {
                        e = this.XreadQuantifiedComparisonRightPart(type, l);
                        break block0;
                    }
                }
                Expression row = this.XreadRowValuePredicand();
                e = new ExpressionLogical(type, l, row);
                break;
            }
            case 160: {
                e = this.XreadMatchPredicateRightPart(l);
                break;
            }
            default: {
                if (hasNot) {
                    throw this.unexpectedToken();
                }
                return l;
            }
        }
        if (hasNot) {
            e = new ExpressionLogical(48, (Expression)e);
        }
        return e;
    }

    private ExpressionLogical XreadBetweenPredicateRightPart(Expression a) {
        boolean symmetric = false;
        this.read();
        if (this.token.tokenType == 11) {
            this.read();
        } else if (this.token.tokenType == 273) {
            symmetric = true;
            this.read();
        }
        Expression left = this.XreadRowValuePredicand();
        this.readThis(5);
        Expression right = this.XreadRowValuePredicand();
        if (a.isParam() && left.isParam()) {
            throw Error.error(5567);
        }
        if (a.isParam() && right.isParam()) {
            throw Error.error(5567);
        }
        ExpressionLogical l = new ExpressionLogical(42, a, left);
        ExpressionLogical r = new ExpressionLogical(45, a, right);
        ExpressionLogical leftToRight = new ExpressionLogical(49, l, r);
        if (symmetric) {
            l = new ExpressionLogical(45, a, left);
            r = new ExpressionLogical(42, a, right);
            ExpressionLogical rightToLeft = new ExpressionLogical(49, l, r);
            return new ExpressionLogical(50, leftToRight, rightToLeft);
        }
        return leftToRight;
    }

    private ExpressionLogical XreadQuantifiedComparisonRightPart(int exprType, Expression l) {
        Expression e;
        int tokenT = this.token.tokenType;
        int exprSubType = 0;
        switch (this.token.tokenType) {
            case 6: 
            case 256: {
                exprSubType = 52;
                break;
            }
            case 2: {
                exprSubType = 51;
                break;
            }
            default: {
                throw Error.runtimeError(401, "ParserDQL");
            }
        }
        this.read();
        this.readThis(695);
        int position = this.getPosition();
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 249: 
            case 276: 
            case 306: {
                this.rewind(position);
                SubQuery sq = this.XreadSubqueryBody(false, 54);
                e = new Expression(23, sq);
                this.readThis(682);
                break;
            }
            default: {
                this.rewind(position);
                e = this.readAggregateExpression(tokenT);
                this.readThis(682);
            }
        }
        ExpressionLogical r = new ExpressionLogical(exprType, l, e);
        r.exprSubType = exprSubType;
        return r;
    }

    private ExpressionLogical XreadInPredicateRightPart(Expression l) {
        ExpressionLogical r;
        int degree = l.getDegree();
        Expression e = null;
        this.read();
        this.readThis(695);
        int position = this.getPosition();
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 249: 
            case 276: 
            case 306: {
                this.rewind(position);
                SubQuery sq = this.XreadSubqueryBody(false, 54);
                e = new Expression(23, sq);
                this.readThis(682);
                break;
            }
            default: {
                this.rewind(position);
                e = this.XreadInValueListConstructor(degree);
                this.readThis(682);
            }
        }
        if (this.isCheckOrTriggerCondition) {
            r = new ExpressionLogical(54, l, e);
        } else {
            r = new ExpressionLogical(41, l, e);
            r.exprSubType = 52;
        }
        return r;
    }

    Expression XreadInValueList(int degree) {
        HsqlArrayList list = new HsqlArrayList();
        while (true) {
            Expression e;
            if ((e = this.XreadValueExpression()).getType() != 25) {
                e = new Expression(25, new Expression[]{e});
            }
            list.add(e);
            if (this.token.tokenType != 684) break;
            this.read();
        }
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        Expression e = new Expression(26, array);
        for (int i = 0; i < array.length; ++i) {
            Expression[] args;
            if (array[i].getType() != 25) {
                array[i] = new Expression(25, new Expression[]{array[i]});
            }
            if ((args = array[i].nodes).length != degree) {
                throw this.unexpectedToken();
            }
            for (int j = 0; j < degree; ++j) {
                if (args[j].getType() != 25) continue;
                throw this.unexpectedToken();
            }
        }
        return e;
    }

    private ExpressionLogical XreadLikePredicateRightPart(Expression a) {
        this.read();
        Expression b = this.XreadStringValueExpression();
        Expression escape = null;
        if (this.token.tokenString.equals("ESCAPE")) {
            this.read();
            escape = this.XreadStringValueExpression();
        }
        return new ExpressionLike(a, b, escape, this.isCheckOrTriggerCondition);
    }

    private ExpressionLogical XreadMatchPredicateRightPart(Expression a) {
        boolean isUnique = false;
        int matchType = 59;
        this.read();
        if (this.token.tokenType == 297) {
            this.read();
            isUnique = true;
        }
        if (this.token.tokenType == 509) {
            this.read();
            matchType = isUnique ? 62 : 59;
        } else if (this.token.tokenType == 469) {
            this.read();
            matchType = isUnique ? 63 : 60;
        } else if (this.token.tokenType == 115) {
            this.read();
            matchType = isUnique ? 64 : 61;
        }
        int mode = isUnique ? 23 : 54;
        Expression s = this.XreadTableSubqueryForPredicate(mode);
        return new ExpressionLogical(matchType, a, s);
    }

    private ExpressionLogical XreadOverlapsPredicateRightPart(Expression l) {
        if (l.getType() != 25) {
            throw Error.error(5564);
        }
        if (l.nodes.length != 2) {
            throw Error.error(5564);
        }
        this.read();
        if (this.token.tokenType != 695) {
            throw this.unexpectedToken();
        }
        Expression r = this.XreadRowValuePredicand();
        if (r.nodes.length != 2) {
            throw Error.error(5564);
        }
        return new ExpressionLogical(56, l, r);
    }

    Expression XreadRowValueExpression() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadTableRowValueConstructor() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        return this.XreadRowValueSpecialCase();
    }

    Expression XreadRowValuePredicand() {
        return this.XreadRowOrCommonValueExpression();
    }

    Expression XreadRowValueSpecialCase() {
        return this.XreadSimpleValueExpressionPrimary();
    }

    Expression XreadRowValueConstructor() {
        Expression e = this.XreadExplicitRowValueConstructorOrNull();
        if (e != null) {
            return e;
        }
        e = this.XreadRowOrCommonValueExpression();
        if (e != null) {
            return e;
        }
        return this.XreadBooleanValueExpression();
    }

    Expression XreadExplicitRowValueConstructorOrNull() {
        switch (this.token.tokenType) {
            case 695: {
                this.read();
                int position = this.getPosition();
                int brackets = this.readOpenBrackets();
                switch (this.token.tokenType) {
                    case 249: 
                    case 276: 
                    case 306: {
                        this.rewind(position);
                        SubQuery sq = this.XreadSubqueryBody(false, 22);
                        this.readThis(682);
                        return new Expression(22, sq);
                    }
                }
                this.rewind(position);
                Expression e = this.XreadRowElementList(true);
                this.readThis(682);
                return e;
            }
            case 241: {
                this.read();
                this.readThis(695);
                Expression e = this.XreadRowElementList(false);
                this.readThis(682);
                return e;
            }
        }
        return null;
    }

    Expression XreadRowElementList(boolean multiple) {
        Expression e;
        HsqlArrayList list = new HsqlArrayList();
        while (true) {
            e = this.XreadValueExpression();
            list.add(e);
            if (this.token.tokenType != 684) break;
            this.read();
        }
        if (multiple && list.size() == 1) {
            return e;
        }
        Expression[] array = new Expression[list.size()];
        list.toArray(array);
        return new Expression(25, array);
    }

    Expression XreadCurrentCollationSpec() {
        throw Error.error(1500);
    }

    Expression XreadRowSubquery() {
        this.readThis(695);
        SubQuery sq = this.XreadSubqueryBody(false, 22);
        this.readThis(682);
        return new Expression(22, sq);
    }

    Expression XreadTableSubqueryForPredicate(int mode) {
        this.readThis(695);
        SubQuery sq = this.XreadSubqueryBody(false, mode);
        this.readThis(682);
        return new Expression(23, sq);
    }

    Expression XreadTableSubqueryOrJoinedTable() {
        boolean joinedTable = false;
        this.readThis(695);
        int position = this.getPosition();
        this.readOpenBrackets();
        switch (this.token.tokenType) {
            case 249: 
            case 276: 
            case 306: 
            case 317: {
                break;
            }
            default: {
                joinedTable = true;
            }
        }
        this.rewind(position);
        if (joinedTable) {
            SubQuery sq = this.XreadJoinedTableAsSubquery();
            this.readThis(682);
            return new Expression(23, sq);
        }
        SubQuery sq = this.XreadTableSubqueryBody();
        this.readThis(682);
        return new Expression(23, sq);
    }

    SubQuery XreadJoinedTableAsSubquery() {
        this.compileContext.subQueryDepth++;
        QueryExpression queryExpression = this.XreadJoinedTable();
        queryExpression.resolve(this.session);
        if (((QuerySpecification)queryExpression).rangeVariables.length < 2) {
            throw this.unexpectedTokenRequire("JOIN");
        }
        SubQuery sq = new SubQuery(this.database, this.compileContext.subQueryDepth, queryExpression, 23);
        sq.prepareTable(this.session);
        this.compileContext.subQueryDepth--;
        this.compileContext.subQueryList.add(sq);
        return sq;
    }

    QueryExpression XreadJoinedTable() {
        QuerySpecification select = new QuerySpecification(this.compileContext);
        ExpressionColumn e = new ExpressionColumn(97);
        select.addSelectColumnExpression(e);
        this.XreadTableReference(select);
        return select;
    }

    SubQuery XreadTableSubqueryBody() {
        SubQuery sq = this.XreadSubqueryBody(true, 23);
        sq.prepareTable(this.session);
        return sq;
    }

    SubQuery XreadSubqueryBody(boolean resolve, int mode) {
        this.compileContext.subQueryDepth++;
        QueryExpression queryExpression = this.XreadQueryExpression();
        if (resolve) {
            queryExpression.resolve(this.session);
        } else {
            queryExpression.resolveReferences(this.session);
        }
        SubQuery sq = new SubQuery(this.database, this.compileContext.subQueryDepth, queryExpression, mode);
        this.compileContext.subQueryList.add(sq);
        this.compileContext.subQueryDepth--;
        return sq;
    }

    SubQuery XreadViewSubquery(View view) {
        QueryExpression queryExpression;
        this.compileContext.subQueryDepth++;
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException e) {
            queryExpression = this.XreadJoinedTable();
        }
        queryExpression.setAsTopLevel();
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subQueryDepth, queryExpression, view);
        this.compileContext.subQueryList.add(sq);
        this.compileContext.subQueryDepth--;
        return sq;
    }

    SchemaObject readCollateClauseOrNull() {
        if (this.token.tokenType == 40) {
            this.read();
            SchemaObject collation = this.database.schemaManager.getSchemaObject(this.token.namePrefix, this.token.tokenString, 15);
            return collation;
        }
        return null;
    }

    Expression readRow() {
        Expression r = null;
        while (true) {
            Expression e = this.XreadValueExpressionWithContext();
            if (r == null) {
                r = e;
            } else if (r.getType() == 25) {
                if (e.getType() == 25 && r.nodes[0].getType() != 25) {
                    r = new Expression(25, new Expression[]{r, e});
                } else {
                    r.nodes = (Expression[])ArrayUtil.resizeArray(r.nodes, r.nodes.length + 1);
                    r.nodes[r.nodes.length - 1] = e;
                }
            } else {
                r = new Expression(25, new Expression[]{r, e});
            }
            if (this.token.tokenType != 684) break;
            this.read();
        }
        return r;
    }

    Expression XreadContextuallyTypedTable(int degree) {
        int i;
        Expression e = this.readRow();
        Expression[] list = e.nodes;
        boolean isTable = false;
        if (degree == 1) {
            if (e.getType() == 25) {
                e.opType = 26;
                for (int i2 = 0; i2 < list.length; ++i2) {
                    if (list[i2].getType() != 25) {
                        list[i2] = new Expression(25, new Expression[]{list[i2]});
                        continue;
                    }
                    if (list[i2].nodes.length == degree) continue;
                    throw Error.error(5564);
                }
                return e;
            }
            e = new Expression(25, new Expression[]{e});
            e = new Expression(26, new Expression[]{e});
            return e;
        }
        if (e.getType() != 25) {
            throw Error.error(5564);
        }
        for (i = 0; i < list.length; ++i) {
            if (list[i].getType() != 25) continue;
            isTable = true;
            break;
        }
        if (isTable) {
            e.opType = 26;
            for (i = 0; i < list.length; ++i) {
                if (list[i].getType() != 25) {
                    throw Error.error(5564);
                }
                Expression[] args = list[i].nodes;
                if (args.length != degree) {
                    throw Error.error(5564);
                }
                for (int j = 0; j < degree; ++j) {
                    if (args[j].getType() != 25) continue;
                    throw Error.error(5564);
                }
            }
        } else {
            if (list.length != degree) {
                throw Error.error(5564);
            }
            e = new Expression(26, new Expression[]{e});
        }
        return e;
    }

    private Expression XreadInValueListConstructor(int degree) {
        this.compileContext.subQueryDepth++;
        Expression e = this.XreadInValueList(degree);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subQueryDepth, e, 54);
        this.compileContext.subQueryList.add(sq);
        this.compileContext.subQueryDepth--;
        return e;
    }

    private SubQuery XreadRowValueExpressionList() {
        this.compileContext.subQueryDepth++;
        Expression e = this.XreadRowValueExpressionListBody();
        HsqlList unresolved = e.resolveColumnReferences(RangeVariable.emptyArray, null);
        ExpressionColumn.checkColumnsResolved(unresolved);
        e.resolveTypes(this.session, null);
        e.prepareTable(this.session, null, e.nodes[0].nodes.length);
        SubQuery sq = new SubQuery(this.database, this.compileContext.subQueryDepth, e, 26);
        sq.prepareTable(this.session);
        this.compileContext.subQueryList.add(sq);
        this.compileContext.subQueryDepth--;
        return sq;
    }

    Expression XreadRowValueExpressionListBody() {
        Expression r = null;
        while (true) {
            int brackets = this.readOpenBrackets();
            Expression e = this.readRow();
            this.readCloseBrackets(brackets);
            if (r == null) {
                r = new Expression(25, new Expression[]{e});
            } else {
                r.nodes = (Expression[])ArrayUtil.resizeArray(r.nodes, r.nodes.length + 1);
                r.nodes[r.nodes.length - 1] = e;
            }
            if (this.token.tokenType != 684) break;
            this.read();
        }
        Expression[] list = r.nodes;
        int degree = 1;
        if (list[0].getType() == 25) {
            degree = list[0].nodes.length;
        }
        r.opType = 26;
        for (int i = 0; i < list.length; ++i) {
            if (list[i].getType() == 25) {
                if (list[i].nodes.length == degree) continue;
                throw Error.error(5564);
            }
            if (degree != 1) {
                throw Error.error(5564);
            }
            list[i] = new Expression(25, new Expression[]{list[i]});
        }
        return r;
    }

    Expression readCaseExpression() {
        Expression predicand = null;
        this.read();
        if (this.token.tokenType != 312) {
            predicand = this.XreadRowValuePredicand();
        }
        return this.readCaseWhen(predicand);
    }

    private Expression readCaseWhen(Expression l) {
        this.readThis(312);
        Expression condition = null;
        if (l == null) {
            condition = this.XreadBooleanValueExpression();
        } else {
            while (true) {
                Expression newCondition;
                if (l == (newCondition = this.XreadPredicateRightPart(l))) {
                    newCondition = new ExpressionLogical(l, this.XreadRowValuePredicand());
                }
                condition = condition == null ? newCondition : new ExpressionLogical(50, condition, newCondition);
                if (this.token.tokenType != 684) break;
                this.read();
            }
        }
        this.readThis(278);
        Expression current = this.XreadValueExpression();
        Expression elseExpr = null;
        if (this.token.tokenType == 312) {
            elseExpr = this.readCaseWhen(l);
        } else if (this.token.tokenType == 91) {
            this.read();
            elseExpr = this.XreadValueExpression();
            this.readThis(93);
            this.readIfThis(28);
        } else {
            elseExpr = new ExpressionValue(null, Type.SQL_ALL_TYPES);
            this.readThis(93);
            this.readIfThis(28);
        }
        ExpressionOp alternatives = new ExpressionOp(96, current, elseExpr);
        ExpressionOp casewhen = new ExpressionOp(93, condition, alternatives);
        return casewhen;
    }

    private Expression readCaseWhenExpression() {
        Expression l = null;
        this.read();
        this.readThis(695);
        l = this.XreadBooleanValueExpression();
        this.readThis(684);
        Expression thenelse = this.XreadRowValueExpression();
        this.readThis(684);
        thenelse = new ExpressionOp(96, thenelse, this.XreadValueExpression());
        l = new ExpressionOp(93, l, thenelse);
        this.readThis(682);
        return l;
    }

    private Expression readCastExpression() {
        boolean isConvert = this.token.tokenType == 48;
        this.read();
        this.readThis(695);
        Expression l = this.XreadValueExpressionOrNull();
        if (isConvert) {
            this.readThis(684);
        } else {
            this.readThis(9);
        }
        Type typeObject = this.readTypeDefinition(true);
        if (l.isParam()) {
            l.setDataType(this.session, typeObject);
        }
        l = new ExpressionOp(l, typeObject);
        this.readThis(682);
        return l;
    }

    private Expression readColumnOrFunctionExpression() {
        Expression e;
        String name = this.token.tokenString;
        boolean isSimpleQuoted = this.isDelimitedSimpleName();
        String prefix = this.token.namePrefix;
        String prePrefix = this.token.namePrePrefix;
        String prePrePrefix = this.token.namePrePrePrefix;
        if (this.isUndelimitedSimpleName()) {
            Expression e2;
            FunctionSQL function = FunctionCustom.newCustomFunction(this.token.tokenString, this.token.tokenType);
            if (function != null) {
                int pos = this.getPosition();
                try {
                    e = this.readSQLFunction(function);
                    if (e != null) {
                        return e;
                    }
                }
                catch (HsqlException ex) {
                    ex.setLevel(this.compileContext.subQueryDepth);
                    if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                        this.lastError = ex;
                    }
                    this.rewind(pos);
                }
            } else if (this.isReservedKey() && (function = FunctionSQL.newSQLFunction(name, this.compileContext)) != null && (e2 = this.readSQLFunction(function)) != null) {
                return e2;
            }
        }
        this.read();
        if (this.token.tokenType != 695) {
            this.checkValidCatalogName(prePrePrefix);
            ExpressionColumn column = new ExpressionColumn(prePrefix, prefix, name);
            return column;
        }
        if (prePrePrefix != null) {
            throw Error.error(5551, prePrePrefix);
        }
        this.checkValidCatalogName(prePrefix);
        prefix = this.session.getSchemaName(prefix);
        RoutineSchema routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, prefix, 16);
        if (routineSchema == null && isSimpleQuoted) {
            HsqlNameManager.HsqlName schema = this.database.schemaManager.getDefaultSchemaHsqlName();
            routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, schema.name, 16);
            if (routineSchema == null) {
                Routine.createRoutines(this.session, schema, name);
                routineSchema = (RoutineSchema)this.database.schemaManager.findSchemaObject(name, schema.name, 16);
            }
        }
        if (routineSchema == null) {
            throw Error.error(5501, name);
        }
        HsqlArrayList list = new HsqlArrayList();
        this.readThis(695);
        if (this.token.tokenType == 682) {
            this.read();
        } else {
            while (true) {
                e = this.XreadValueExpression();
                list.add(e);
                if (this.token.tokenType != 684) break;
                this.read();
            }
            this.readThis(682);
        }
        FunctionSQLInvoked function = new FunctionSQLInvoked(routineSchema);
        Expression[] arguments = new Expression[list.size()];
        list.toArray(arguments);
        function.setArguments(arguments);
        this.compileContext.addRoutine(function);
        return function;
    }

    private Expression readNullIfExpression() {
        this.read();
        this.readThis(695);
        Expression c = this.XreadValueExpression();
        this.readThis(684);
        ExpressionOp thenelse = new ExpressionOp(96, new ExpressionValue(null, (Type)null), c);
        c = new ExpressionLogical(c, this.XreadValueExpression());
        c = new ExpressionOp(93, c, thenelse);
        this.readThis(682);
        return c;
    }

    private Expression readCoalesceExpression() {
        Expression current;
        ExpressionOp c = null;
        this.read();
        this.readThis(695);
        Expression leaf = null;
        while (true) {
            current = this.XreadValueExpression();
            if (leaf != null && this.token.tokenType == 682) break;
            ExpressionLogical condition = new ExpressionLogical(47, current);
            ExpressionOp alternatives = new ExpressionOp(96, new ExpressionValue(null, (Type)null), current);
            ExpressionOp casewhen = new ExpressionOp(93, condition, alternatives);
            if (c == null) {
                c = casewhen;
            } else {
                leaf.setLeftNode(casewhen);
            }
            leaf = alternatives;
            this.readThis(684);
        }
        this.readThis(682);
        leaf.setLeftNode(current);
        return c;
    }

    Expression readSQLFunction(FunctionSQL function) {
        int position = this.getPosition();
        this.read();
        short[] parseList = function.parseList;
        if (parseList.length == 0) {
            return function;
        }
        HsqlArrayList exprList = new HsqlArrayList();
        boolean isOpenBracket = this.token.tokenType == 695;
        try {
            this.readExpression(exprList, parseList, 0, parseList.length, false);
        }
        catch (HsqlException e) {
            if (!isOpenBracket) {
                this.rewind(position);
                return null;
            }
            if (function.parseListAlt == null) {
                throw e;
            }
            this.rewind(position);
            this.read();
            parseList = function.parseListAlt;
            exprList = new HsqlArrayList();
            this.readExpression(exprList, parseList, 0, parseList.length, false);
        }
        Expression[] expr = new Expression[exprList.size()];
        exprList.toArray(expr);
        function.setArguments(expr);
        return function.getFunctionExpression();
    }

    void readExpression(HsqlArrayList exprList, short[] parseList, int start, int count, boolean isOption) {
        block9: for (int i = start; i < start + count; ++i) {
            short exprType = parseList[i];
            switch (exprType) {
                case 697: {
                    Expression e = null;
                    e = this.XreadAllTypesCommonValueExpression(false);
                    exprList.add(e);
                    continue block9;
                }
                case 744: {
                    ExpressionValue e = null;
                    Integer value = this.readIntegerObject();
                    if (value < 0) {
                        throw Error.error(5592);
                    }
                    e = new ExpressionValue(value, Type.SQL_INTEGER);
                    exprList.add(e);
                    continue block9;
                }
                case 742: {
                    int expressionCount = exprList.size();
                    int position = this.getPosition();
                    int n = ++i;
                    ++i;
                    short elementCount = parseList[n];
                    int initialExprIndex = exprList.size();
                    try {
                        this.readExpression(exprList, parseList, i, elementCount, true);
                    }
                    catch (HsqlException ex) {
                        ex.setLevel(this.compileContext.subQueryDepth);
                        if (this.lastError == null || this.lastError.getLevel() < ex.getLevel()) {
                            this.lastError = ex;
                        }
                        this.rewind(position);
                        exprList.setSize(expressionCount);
                        for (int j = i; j < i + elementCount; ++j) {
                            if (parseList[j] != 697 && parseList[j] != 741 && parseList[j] != 744) continue;
                            exprList.add(null);
                        }
                        i += elementCount - 1;
                        continue block9;
                    }
                    if (initialExprIndex == exprList.size()) {
                        exprList.add(null);
                    }
                    i += elementCount - 1;
                    continue block9;
                }
                case 743: {
                    int initialExprIndex;
                    int n = ++i;
                    short elementCount = parseList[n];
                    int parseIndex = ++i;
                    do {
                        initialExprIndex = exprList.size();
                        this.readExpression(exprList, parseList, parseIndex, elementCount, true);
                    } while (exprList.size() != initialExprIndex);
                    i += elementCount - 1;
                    continue block9;
                }
                case 741: {
                    short elementCount = parseList[++i];
                    ExpressionValue e = null;
                    if (ArrayUtil.find(parseList, this.token.tokenType, i + 1, elementCount) == -1) {
                        if (!isOption) {
                            throw this.unexpectedToken();
                        }
                    } else {
                        e = new ExpressionValue(ValuePool.getInt(this.token.tokenType), Type.SQL_INTEGER);
                        this.read();
                    }
                    exprList.add(e);
                    i += elementCount;
                    continue block9;
                }
                default: {
                    if (this.token.tokenType != exprType) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    continue block9;
                }
            }
        }
    }

    private Expression readSequenceExpression() {
        this.read();
        this.readThis(305);
        this.readThis(111);
        this.checkIsSchemaObjectName();
        String schema = this.session.getSchemaName(this.token.namePrefix);
        NumberSequence sequence = this.database.schemaManager.getSequence(this.token.tokenString, schema, true);
        this.read();
        ExpressionColumn e = new ExpressionColumn(sequence);
        this.compileContext.addSequence(sequence);
        return e;
    }

    HsqlNameManager.HsqlName readNewSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), 2);
        this.read();
        return name;
    }

    HsqlNameManager.HsqlName readNewSchemaObjectName(int type, boolean checkSchema) {
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.isDelimitedIdentifier(), type);
        if (this.token.namePrefix != null) {
            switch (type) {
                case 1: 
                case 11: 
                case 21: 
                case 22: 
                case 24: {
                    throw this.unexpectedToken();
                }
                case 19: {
                    if (this.token.namePrePrefix == null && "MODULE".equals(this.token.namePrefix) && !this.token.isDelimitedPrefix) break;
                    throw this.unexpectedTokenRequire("MODULE");
                }
                case 2: {
                    this.checkValidCatalogName(this.token.namePrefix);
                    if (this.token.namePrePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                case 9: {
                    if (this.token.namePrefix == null) break;
                    throw this.tooManyIdentifiers();
                }
                default: {
                    HsqlNameManager.HsqlName schemaName;
                    this.checkValidCatalogName(this.token.namePrePrefix);
                    if (checkSchema) {
                        schemaName = this.session.getSchemaHsqlName(this.token.namePrefix);
                    } else {
                        schemaName = this.session.database.schemaManager.findSchemaHsqlName(this.token.namePrefix);
                        if (schemaName == null) {
                            schemaName = this.database.nameManager.newHsqlName(this.token.namePrefix, this.isDelimitedIdentifier(), 2);
                        }
                    }
                    hsqlName.setSchemaIfNull(schemaName);
                    break;
                }
            }
        }
        this.read();
        return hsqlName;
    }

    HsqlNameManager.HsqlName readNewDependentSchemaObjectName(HsqlNameManager.HsqlName parentName, int type) {
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(type, true);
        name.parent = parentName;
        name.setSchemaIfNull(parentName.schema);
        if (name.schema != null && parentName.schema != null && name.schema != parentName.schema) {
            throw Error.error(5505, this.token.namePrefix);
        }
        return name;
    }

    HsqlNameManager.HsqlName readSchemaName() {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrefix);
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.tokenString);
        this.read();
        return schema;
    }

    SchemaObject readSchemaObjectName(int type) {
        this.checkIsSchemaObjectName();
        this.checkValidCatalogName(this.token.namePrePrefix);
        SchemaObject object = this.database.schemaManager.getSchemaObject(this.token.tokenString, this.token.namePrefix, type);
        this.read();
        return object;
    }

    SchemaObject readSchemaObjectName(HsqlNameManager.HsqlName schemaName, int type) {
        this.checkIsSchemaObjectName();
        SchemaObject object = this.database.schemaManager.getSchemaObject(this.token.tokenString, schemaName.name, type);
        if (this.token.namePrefix != null) {
            if (!this.token.namePrefix.equals(schemaName.name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
            if (this.token.namePrePrefix != null && !this.token.namePrePrefix.equals(this.database.getCatalogName().name)) {
                throw Error.error(5505, this.token.namePrefix);
            }
        }
        this.read();
        return object;
    }

    Table readTableName() {
        this.checkIsIdentifier();
        if (this.token.namePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrefix);
        }
        Table table = this.database.schemaManager.getTable(this.session, this.token.tokenString, this.token.namePrefix);
        this.read();
        return table;
    }

    ColumnSchema readSimpleColumnName(RangeVariable rangeVar) {
        ColumnSchema column = null;
        this.checkIsIdentifier();
        if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        int index = rangeVar.findColumn(this.token.tokenString);
        if (index > -1 && rangeVar.resolvesTableName(this.token.namePrefix) && rangeVar.resolvesSchemaName(this.token.namePrePrefix)) {
            column = rangeVar.getTable().getColumn(index);
            this.read();
            return column;
        }
        throw Error.error(5501, this.token.tokenString);
    }

    ColumnSchema readSimpleColumnName(Table table) {
        this.checkIsIdentifier();
        if (this.token.namePrefix != null) {
            throw this.tooManyIdentifiers();
        }
        int index = table.findColumn(this.token.tokenString);
        if (index == -1) {
            throw Error.error(5501, this.token.tokenString);
        }
        ColumnSchema column = table.getColumn(index);
        this.read();
        return column;
    }

    ColumnSchema readColumnName(RangeVariable[] rangeVars) {
        ColumnSchema column = null;
        this.checkIsIdentifier();
        if (this.token.namePrePrePrefix != null) {
            this.checkValidCatalogName(this.token.namePrePrePrefix);
        }
        for (int i = 0; i < rangeVars.length; ++i) {
            int index = rangeVars[i].findColumn(this.token.tokenString);
            if (index <= -1 || !rangeVars[i].resolvesTableName(this.token.namePrefix) || !rangeVars[i].resolvesSchemaName(this.token.namePrePrefix)) continue;
            column = rangeVars[i].getColumn(index);
            this.read();
            return column;
        }
        throw Error.error(5501, this.token.tokenString);
    }

    StatementDMQL compileDeclareCursor() {
        boolean sensitivity = false;
        boolean scrollability = false;
        boolean holdability = false;
        boolean returnability = false;
        this.readThis(76);
        this.readNewSchemaObjectName(19, true);
        switch (this.token.tokenType) {
            case 250: {
                this.read();
                break;
            }
            case 132: {
                this.read();
                break;
            }
            case 10: {
                this.read();
            }
        }
        if (this.token.tokenType == 178) {
            this.readThis(246);
        } else if (this.token.tokenType == 246) {
            this.read();
        }
        this.readThis(69);
        for (int round = 0; round < 2; ++round) {
            if (this.token.tokenType == 317) {
                this.read();
                if (round == 0 && this.token.tokenType == 125) {
                    this.read();
                    continue;
                }
                this.readThis(235);
                ++round;
                continue;
            }
            if (this.token.tokenType != 319) continue;
            this.read();
            if (round == 0 && this.token.tokenType == 125) {
                this.read();
                continue;
            }
            this.readThis(235);
            ++round;
        }
        this.readThis(111);
        StatementDMQL cs = this.compileCursorSpecification();
        return cs;
    }

    StatementDMQL compileCursorSpecification() {
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setAsTopLevel();
        queryExpression.resolve(this.session);
        if (this.token.tokenType == 111) {
            this.read();
            if (this.token.tokenType == 479) {
                this.read();
                this.readThis(193);
            } else {
                this.readThis(301);
                if (this.token.tokenType == 189) {
                    this.readThis(189);
                    OrderedHashSet colNames = this.readColumnNameList(null, false);
                }
            }
        }
        StatementQuery cs = new StatementQuery(this.session, queryExpression, this.compileContext);
        return cs;
    }

    int readCloseBrackets(int limit) {
        int count;
        for (count = 0; count < limit && this.token.tokenType == 682; ++count) {
            this.read();
        }
        return count;
    }

    int readOpenBrackets() {
        int count = 0;
        while (this.token.tokenType == 695) {
            ++count;
            this.read();
        }
        return count;
    }

    void checkValidCatalogName(String name) {
        if (name != null && !name.equals(this.database.getCatalogName().name)) {
            throw Error.error(5501, name);
        }
    }

    public static final class CompileContext {
        private int subQueryDepth;
        private HsqlArrayList subQueryList = new HsqlArrayList(true);
        HsqlArrayList parameters = new HsqlArrayList(true);
        private HsqlArrayList usedSequences = new HsqlArrayList(true);
        private HsqlArrayList usedRoutines = new HsqlArrayList(true);
        private HsqlArrayList rangeVariables = new HsqlArrayList(true);
        Type currentDomain;
        boolean contextuallyTypedExpression;
        final Session session;
        private int rangeVarIndex = 0;

        public CompileContext(Session session) {
            this.session = session;
            this.reset();
        }

        public void reset() {
            this.rangeVarIndex = 0;
            this.rangeVariables.clear();
            this.subQueryList.clear();
            this.subQueryDepth = 0;
            this.parameters.clear();
            this.usedSequences.clear();
            this.usedRoutines.clear();
            this.currentDomain = null;
            this.contextuallyTypedExpression = false;
        }

        public void registerRangeVariable(RangeVariable range) {
            range.rangePosition = this.getNextRangeVarIndex();
            range.level = this.subQueryDepth;
            this.rangeVariables.add(range);
        }

        public int getNextRangeVarIndex() {
            return this.rangeVarIndex++;
        }

        public int getRangeVarCount() {
            return this.rangeVarIndex;
        }

        public RangeVariable[] getRangeVariables() {
            RangeVariable[] array = new RangeVariable[this.rangeVariables.size()];
            this.rangeVariables.toArray(array);
            return array;
        }

        public NumberSequence[] getSequences() {
            if (this.usedSequences.size() == 0) {
                return NumberSequence.emptyArray;
            }
            NumberSequence[] array = new NumberSequence[this.usedSequences.size()];
            this.usedSequences.toArray(array);
            return array;
        }

        public Routine[] getRoutines() {
            if (this.usedRoutines.size() == 0) {
                return Routine.emptyArray;
            }
            OrderedHashSet set = new OrderedHashSet();
            for (int i = 0; i < this.usedRoutines.size(); ++i) {
                FunctionSQLInvoked function = (FunctionSQLInvoked)this.usedRoutines.get(i);
                set.add(function.routine);
            }
            Object[] array = new Routine[set.size()];
            set.toArray(array);
            return array;
        }

        private void addSequence(NumberSequence sequence) {
            this.usedSequences.add(sequence);
        }

        void addRoutine(FunctionSQLInvoked function) {
            this.usedRoutines.add(function);
        }

        void resetSubQueryLevel() {
            int i;
            for (i = this.rangeVariables.size() - 1; i >= 0; --i) {
                RangeVariable range = (RangeVariable)this.rangeVariables.get(i);
                if (range.level <= this.subQueryDepth) {
                    this.rangeVarIndex = this.rangeVariables.size();
                    break;
                }
                this.rangeVariables.remove(i);
            }
            for (i = this.subQueryList.size() - 1; i >= 0; --i) {
                SubQuery subQuery = (SubQuery)this.subQueryList.get(i);
                if (subQuery.level <= this.subQueryDepth) break;
                this.subQueryList.remove(i);
            }
        }

        SubQuery[] getSubqueries() {
            if (this.subQueryList.size() == 0) {
                return SubQuery.emptySubqueryArray;
            }
            this.subQueryList.sort((SubQuery)this.subQueryList.get(0));
            SubQuery[] subqueries = new SubQuery[this.subQueryList.size()];
            this.subQueryList.toArray(subqueries);
            this.subQueryList.clear();
            for (int i = 0; i < subqueries.length; ++i) {
                subqueries[i].prepareTable(this.session);
            }
            return subqueries;
        }

        ExpressionColumn[] getParameters() {
            if (this.parameters.size() == 0) {
                return ExpressionColumn.emptyArray;
            }
            ExpressionColumn[] result = (ExpressionColumn[])this.parameters.toArray(new ExpressionColumn[this.parameters.size()]);
            this.parameters.clear();
            return result;
        }

        void clearParameters() {
            this.parameters.clear();
        }

        public OrderedHashSet getSchemaObjectNames() {
            int i;
            OrderedHashSet set = new OrderedHashSet();
            for (i = 0; i < this.usedSequences.size(); ++i) {
                NumberSequence sequence = (NumberSequence)this.usedSequences.get(i);
                set.add(sequence.getName());
            }
            for (i = 0; i < this.rangeVariables.size(); ++i) {
                RangeVariable range = (RangeVariable)this.rangeVariables.get(i);
                HsqlNameManager.HsqlName name = range.rangeTable.getName();
                if (name.schema != SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) {
                    set.add(range.rangeTable.getName());
                    set.addAll(range.getColumnNames());
                    continue;
                }
                if (name.type != 10) continue;
                set.addAll(range.getColumnNames());
            }
            Routine[] routines = this.getRoutines();
            for (int i2 = 0; i2 < routines.length; ++i2) {
                set.add(routines[i2].getSpecificName());
            }
            return set;
        }
    }
}

