package de.ugoe.cs.swe.memos.gui.menu;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

import de.ugoe.cs.swe.memos.Utils;
import de.ugoe.cs.swe.memos.database.DBUtility;
import de.ugoe.cs.swe.memos.database.DatabaseException;
import de.ugoe.cs.swe.memos.datamodel.Category;

public class deleteCHandler implements IHandler, Listener {
	private static boolean enabled = true;

	public static void setEnabled(boolean state) {
		enabled = state;
	}

	@Override
	public void addHandlerListener(IHandlerListener handlerListener) {
		// TODO Auto-generated method stub

	}

	@Override
	public void dispose() {
		// TODO Auto-generated method stub

	}

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		deleteCategory();

		return null;
	}

	@Override
	public boolean isEnabled() {
		// TODO Auto-generated method stub
		return enabled;
	}

	@Override
	public boolean isHandled() {
		// TODO Auto-generated method stub
		return true;
	}

	@Override
	public void removeHandlerListener(IHandlerListener handlerListener) {
		// TODO Auto-generated method stub

	}

	@Override
	public void handleEvent(Event event) {
		if (event.type == SWT.Selection)
			deleteCategory();

	}

	private void deleteCategory() {
		Tree tree=getCategoryTree();
		TreeItem selection=tree.getSelection()[0];
		
		Category selectedCategory = (Category) tree.getSelection()[0].getData();
		DBUtility connect = DBUtility.getInstance();
		selectedCategory.loadChildrenFromDB();
		
		MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench()				
				.getActiveWorkbenchWindow().getShell(), SWT.ICON_WARNING
				| SWT.CANCEL | SWT.NO | SWT.YES);
		messageBox.setText("Achtung!");
		messageBox
				.setMessage("Soll der Inhalt der Kategorie in die nächsthöhere Kategorie verschoben werden?" +
						"\nAchtung: Bei \"Nein\" werden diese Kategorien gelöscht.");
		
		int buttonID = messageBox.open();		
		switch (buttonID) {
		case SWT.YES:
			// Löschen der Kategorie verschieben der Kinder!
			try {
				connect.deleteCategory(selectedCategory);
				for (Category c : selectedCategory.getChildCategories()) {
					TreeItem newI;
					
					if(selection.getParentItem()==null)
						newI = new TreeItem(tree,SWT.NONE);
					else
						newI=new TreeItem(selection.getParentItem(),SWT.NONE);
					
					newI.setData(c);
					newI.setText(c.getName());
					
					TreeItem newDummy=new TreeItem(newI,SWT.NONE);
					newDummy.setText("...");
					
					c.setParentCategory(selectedCategory.getParentCategory());
					c.setParentID(selectedCategory.getParentID());
				}
				getCategoryTree().deselectAll();
				selection.dispose();
			} catch (DatabaseException e) {
				// TODO Auto-generated catch block
				System.err.println("Error while removing Category from DB");
				e.printStackTrace();
			}
			break;

		case SWT.NO:			
			// Löschen der Kategorie und ihrer Kinder
			try {
				connect.deleteCategoryAndSubCategories(selectedCategory);
				getCategoryTree().deselectAll();
				selection.dispose();
			} catch (DatabaseException e) {
				
			}
			
			
			
			break;
		case SWT.CANCEL:
			break;
		}
	}

	private Tree getCategoryTree() {
		return Utils.getMainView().getCategoryBrowser().getCategoryTree();

	}

}
