package de.ugoe.cs.swe.memos.tests;

import static org.junit.Assert.*;

import java.util.Vector;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.swe.memos.database.DBUtility;
import de.ugoe.cs.swe.memos.database.DatabaseException;
import de.ugoe.cs.swe.memos.datamodel.Tag;
import de.ugoe.cs.swe.memos.search.TagCompletionText;

public class TestTagCompletion {

	private DBUtility db = DBUtility.getInstance();
	private Vector<Tag> tags = new Vector<Tag>();

	@Before
	public void setUp() {
		try {
			tags = db.queryTags();
		} catch (DatabaseException e) {
		}
	}

	@Test
	public void testGetCompletionList() {
		if (tags.size() > 0) {
			Tag toTest = new Tag("Test");
			for (Tag tag: tags) {
				if (tag.getName().length() <= 2)
					continue;
				toTest = tag;
			}

			String testWord = toTest.getName().substring(0, 2);

			Vector<String> completes = new TagCompletionText(new Composite(
					new Shell(), 0), 0, true, false)
					.getCompletionList(testWord);
			if (completes.indexOf(toTest.getName()) == -1)
				fail();
		}
	}
}
