package de.ugoe.cs.swe.memos.search;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.swt.widgets.Composite;

import de.ugoe.cs.swe.memos.database.DatabaseException;
import de.ugoe.cs.swe.memos.datamodel.Tag;

public class TagCompletionText extends CompletableText {
	
	public TagCompletionText(Composite parent, int style, boolean multiWords, boolean mustMatch) {
		super(parent, style, multiWords, mustMatch);
	}
	
	protected Vector<String> refreshItemList() {
		Vector<Tag> tagList = new Vector<Tag>();
		Vector<String> itemList = new Vector<String>();
		
		try {
			tagList = db.queryTags();
		}
		catch (DatabaseException e) {
			System.out.println(e.toString());
		}
		
		itemList.clear();
		
		// convert to string list, containing the names
		Iterator<Tag> tagIt = tagList.iterator();
		while (tagIt.hasNext()) {
			Tag tag = tagIt.next();
			itemList.add(tag.getName());
		}
		
		return itemList; 
	}	
}
