package de.ugoe.cs.swe.memos.gui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.ugoe.cs.swe.memos.SettingsManager;

public class ImportDialog extends Dialog {

	final SettingsManager sm = SettingsManager.getInstance();
	private Text importFilePath;
	private String importFile;
	private String importPath = sm.getImport_Path();

	public String getImportFile() {
		return importFile;
	}

	public String getImportPath() {
		return importPath;
	}

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 */
	public ImportDialog(Shell parentShell) {
		super(parentShell);
	}

	@Override
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText("Import");
	}

	/**
	 * Create contents of the dialog.
	 * 
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(null);
		{
			importFilePath = new Text(container, SWT.BORDER);
			importFilePath.setText(importPath);
			importFilePath.setBounds(29, 33, 483, 25);
		}
		{
			Label lblImportdatei = new Label(container, SWT.NONE);
			lblImportdatei.setBounds(29, 10, 350, 17);
			lblImportdatei
					.setText("Importdatei (Inhalt der DB wird komplett ersetzt!)");
		}
		{
			// choose file
			Button importButton = new Button(container, SWT.PUSH);
			importButton.setImage(new Image(Display.getCurrent(), getClass()
					.getResourceAsStream("/icons/folder.gif")));
			// importButton.setText("Auswählen...");
			importButton.setBounds(515, 33, 27, 27);

			importButton.addSelectionListener(new SelectionAdapter() {
				public void widgetSelected(SelectionEvent e) {
					FileDialog fileDialog = new FileDialog(getShell(), SWT.OPEN);
					fileDialog.setFilterPath(sm.getImport_Path());
					fileDialog
							.setText("Wählen Sie die Datei die importiert werden soll.");
					String[] fileextension = new String[] { "*.xml" };
					fileDialog.setFilterExtensions(fileextension);

					importPath = fileDialog.open();
					if (importPath == null) {
						importPath = sm.getImport_Path();
					}
					importFilePath.setText(importPath);
				}
			});
			//			
			// Button button = new Button(container, SWT.NONE);
			// button.setBounds(466, 52, 26, 29);
			// button.setText("New Button");
		}

		return container;
	}

	/**
	 * Create contents of the button bar.
	 * 
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, "Import", true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(582, 174);
	}

	public boolean close() {

		importFile = importFilePath.getText();

		// if(!importPath.toLowerCase().endsWith(".xml")){
		// Utils.showError("Sie müssen eine XML Datei für den Import ausgewählt haben!");
		// }

		return super.close();
	}

}
