package de.ugoe.cs.swe.memos.gui.dialogs;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;

import org.eclipse.swt.widgets.Shell;

import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;

import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

import de.ugoe.cs.swe.memos.SettingsManager;
import de.ugoe.cs.swe.memos.datamodel.Category;
import de.ugoe.cs.swe.memos.search.CategoryCompletionText;

import org.eclipse.nebula.widgets.datechooser.DateChooserCombo;

public class ExportDialog extends Dialog {

	final Calendar rightNow = Calendar.getInstance();
	final SettingsManager sm = SettingsManager.getInstance();

	private int authorFilter;
	private boolean useDateFilter, useCategoryFilter;
	private String exportFile;
	private Timestamp fromPointInTime, tillPointInTime;
	private Category activecategoryFilter;
	// Dialog Items
	private Combo authorFilterCombo;
	Button btnDatumsfilterBenutzen, btnCategoryFilterBenutzen;
	private CategoryCompletionText categoryFilter;
	private Text exportFilePath;
	private DateChooserCombo tillDate, fromDate;
	private DateTime fromTime, tillTime;

	// private Text text_2;

	public int getAuthorFilter() {
		// -1 no selection
		// 0 = alle Daten
		// 1 = alle meine Daten
		// 2 = alle fremden Daten
		if (this.authorFilter == -1)
			return 0;
		return this.authorFilter;
	}

	public boolean isUseCategoryFilter() {
		return useCategoryFilter;
	}

	public boolean isUseDateFilter() {
		return useDateFilter;
	}

	public String getExportFile() {
		return exportFile;
	}

	public Timestamp getFromPointInTime() {
		return fromPointInTime;
	}

	public Timestamp getTillPointInTime() {
		return tillPointInTime;
	}

	public Category getActivecategoryFilter() {
		return activecategoryFilter;
	}

	/**
	 * Create the dialog.
	 * 
	 * @param parentShell
	 */
	public ExportDialog(Shell parentShell) {
		super(parentShell);
	}

	@Override
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText("Export");
	}

	/**
	 * Create contents of the dialog.
	 * 
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		container.setLayout(null);
		{
			authorFilterCombo = new Combo(container, SWT.READ_ONLY);
			authorFilterCombo.setToolTipText("Autorenfilter");
			authorFilterCombo.setItems(new String[] { "alle Daten",
					"alle meine Daten", "alle fremden Daten" });
			authorFilterCombo.setBounds(44, 51, 204, 21);
			authorFilterCombo.select(0);
			authorFilterCombo.setText("Autorenfilter");
		}
		{
			btnDatumsfilterBenutzen = new Button(container, SWT.CHECK);
			btnDatumsfilterBenutzen.setBounds(461, 20, 185, 21);
			btnDatumsfilterBenutzen.setText("Datumsfilter benutzen");
		}
		// Textfield to adjust the CategoryCompletionText-field
		// {
		// text_2 = new Text(container, SWT.BORDER);
		// text_2.setBounds(44, 136, 346, 29);
		// }
		{
			btnCategoryFilterBenutzen = new Button(container, SWT.CHECK);
			btnCategoryFilterBenutzen.setText("Den Kategoriefilter benutzen?");
			btnCategoryFilterBenutzen.setBounds(44, 111, 230, 17);
		}
		{
			categoryFilter = new CategoryCompletionText(container, SWT.BORDER,
					false, true);
			categoryFilter.getTextField().setBounds(44, 136, 346, 29);
			categoryFilter.setEnabled(false);
		}
			btnCategoryFilterBenutzen.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				categoryFilter.setEnabled(btnCategoryFilterBenutzen.getSelection());

			}
		});

		{
			Label lblAutorenfilter = new Label(container, SWT.NONE);
			lblAutorenfilter.setBounds(44, 28, 204, 17);
			lblAutorenfilter.setText("Autorenfilter:");
		}

		{
			exportFilePath = new Text(container, SWT.BORDER);
			exportFilePath.setText(sm.getExport_Path()
					+ System.getProperty("file.separator") + "MYKLDG-"
					+ rightNow.get(Calendar.YEAR) + "-"
					+ (rightNow.get(Calendar.MONTH) + 1) + "-"
					+ rightNow.get(Calendar.DAY_OF_MONTH) + ".xml");
			exportFilePath.setBounds(44, 233, 346, 25);
		}
		{
			Label lblExportDatei = new Label(container, SWT.NONE);
			lblExportDatei.setBounds(44, 210, 106, 17);
			lblExportDatei.setText("Export Datei");
		}
		{// Button used for the Designeditor
			// Button btnT = new Button(container, SWT.NONE);
			// btnT.setBounds(393, 233, 24, 25);
			// btnT.setText("t");

		}

		// choose path
		Button exportButton = new Button(container, SWT.PUSH);
		exportButton.setImage(new Image(Display.getCurrent(), getClass()
				.getResourceAsStream("/icons/folder.gif")));
		// exportButton.setText("Auswählen...");
		exportButton.setBounds(393, 232, 27, 27);
		{
			tillDate = new DateChooserCombo(container, SWT.NONE);
			tillDate.setValue(new Date());
			tillDate.setBounds(461, 198, 147, 29);
			tillDate.setEnabled(false);
		}
		{
			fromDate = new DateChooserCombo(container, SWT.NONE);
			fromDate.setValue(new Date());
			fromDate.setBounds(461, 66, 147, 29);
			fromDate.setEnabled(false);
		}
		{
			fromTime = new DateTime(container, SWT.BORDER | SWT.TIME
					| SWT.SHORT);
			fromTime.setBounds(461, 101, 147, 29);
			fromTime.setEnabled(false);
		}
		{
			tillTime = new DateTime(container, SWT.BORDER | SWT.TIME
					| SWT.SHORT);
			tillTime.setBounds(461, 233, 147, 29);
			tillTime.setEnabled(false);
		}
		
		btnDatumsfilterBenutzen.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {

				tillDate.setEnabled(btnDatumsfilterBenutzen.getSelection());
				fromDate.setEnabled(btnDatumsfilterBenutzen.getSelection());
				fromTime.setEnabled(btnDatumsfilterBenutzen.getSelection());
				tillTime.setEnabled(btnDatumsfilterBenutzen.getSelection());

			}
		});
		{
			Label lblVon = new Label(container, SWT.NONE);
			lblVon.setBounds(461, 47, 68, 17);
			lblVon.setText("von:");
		}
		{
			Label lblBis = new Label(container, SWT.NONE);
			lblBis.setBounds(461, 179, 68, 17);
			lblBis.setText("bis:");
		}
		exportButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				DirectoryDialog directoryDialog = new DirectoryDialog(
						getShell(), SWT.OPEN);
				directoryDialog.setFilterPath(sm.getExport_Path());
				directoryDialog
						.setText("Wählen Sie den Ordner in dem die Exportdatei abgelegt werden soll");

				String exportPath = directoryDialog.open();
				if (exportPath == null) {
					exportPath = sm.getExport_Path();
				}
				System.out.println(exportPath);
				exportFilePath.setText(exportPath
						+ System.getProperty("file.separator") + "MYKLDG-"
						+ rightNow.get(Calendar.YEAR) + "-"
						+ (rightNow.get(Calendar.MONTH) + 1) + "-"
						+ rightNow.get(Calendar.DAY_OF_MONTH) + ".xml");
			}
		});

		return container;
	}

	/**
	 * Create contents of the button bar.
	 * 
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, "Export", true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(651, 380);
	}

	public boolean close() {
		authorFilter = authorFilterCombo.getSelectionIndex();
		activecategoryFilter = Category.byPath(categoryFilter.getTextField()
				.getText());
		useDateFilter = btnDatumsfilterBenutzen.getSelection();
		exportFile = exportFilePath.getText();
		useCategoryFilter = btnCategoryFilterBenutzen.getSelection();
		if (useDateFilter) {
			long fromDateMilliseconds = fromDate.getValue().getTime();
			fromDateMilliseconds += fromTime.getMinutes() * 60 * 1000;
			fromDateMilliseconds += fromTime.getHours() * 60 * 60 * 1000;
			fromPointInTime = new Timestamp(fromDateMilliseconds);

			long tillDateMilliseconds = tillDate.getValue().getTime();
			tillDateMilliseconds += tillTime.getMinutes() * 60 * 1000;
			tillDateMilliseconds += tillTime.getHours() * 60 * 60 * 1000;
			tillPointInTime = new Timestamp(tillDateMilliseconds);
		}

		return super.close();

	}

}
