package de.ugoe.cs.swe.memos.datamodel;

import java.util.Date;
import java.util.ArrayList;
import java.util.Vector;

import de.ugoe.cs.swe.memos.SettingsManager;
import de.ugoe.cs.swe.memos.database.DBUtility;
import de.ugoe.cs.swe.memos.database.DatabaseException;

public class Memo {
	private Long iD;
	private String title;
	private String content;
	private Date timestamp;
	private Long categoryID = null;
	private String lock;
	private String author;
	private boolean draft;
	private Date lockedAt;
	private Vector<Category> allCategories;
	
	public ArrayList<File> getFiles() {
		return Files;
	}

	public Vector<Category> getAllCategories(){
		return this.allCategories;
	}
	
	public void setAllCategories(Vector<Category> allCategories){
		this.allCategories = allCategories;
	}
	
	public void setFiles(ArrayList<File> files) {
		Files = files;
	}

	private ArrayList<File> Files=new ArrayList<File>();

	private Category category;
	private ArrayList<Tag> tags;

	public Long getCategoryID() {
		return this.categoryID;
	}

	public void setCategoryID(Long categoryID) {
		this.categoryID = categoryID;
	}

	public String getLock() {
		if (draft)
			return SettingsManager.getInstance().getUsername();
		return lock;
	}

	public void setLock(String lock) {
		this.lock = lock;
	}

	public Memo(String title, String content, Date timestamp, String author, Category category,
			ArrayList<Tag> tags) {
		this.title = title;
		this.content = content;
		this.timestamp = timestamp;
		this.categoryID = (category != null) ? category.getiD() : null;
		this.author = author;
		this.category = category;
		this.tags = tags;
	}

	public Memo(String title, Date timestamp, boolean draft) {
		this.title = title;
		this.timestamp = timestamp;
		this.draft = draft;
		this.tags = new ArrayList<Tag>();
	}

	public Memo(String title, boolean draft) {
		this.title = title;
		this.draft = draft;
		this.tags = new ArrayList<Tag>();
	}

	public Long getiD() {
		return iD;
	}

	public void setiD(Long iD) {
		this.iD = iD;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getPreviewContent() {
		if (content == null)
			return "";
		return filterHTMLTags(content.substring(0, Math.min(200, content.length())));
	}
	
	private String filterHTMLTags(String input) {
		//input = input.replaceAll("<(br|BR)>", "\n");
		return input.replaceAll("<[^>]*>", "");
	}

	public Date getTimestamp() {
		if (timestamp == null)
			return new Date(0);
		return timestamp;
	}

	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}

	public Category getCategory() {
		return category;
	}

	public void setCategory(Category cathegory) {
		this.category = cathegory;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public ArrayList<Tag> getTags() {
		if (tags == null)
			tags = new ArrayList<Tag>();
		return tags;
	}

	public void setTags(ArrayList<Tag> tags) {
		this.tags = tags;
	}

	public boolean isDraft() {
		return draft;
	}

	public void setDraft(boolean draft) {
		this.draft = draft;
	}

	public void setLockedAt(Date lockedAt) {
		this.lockedAt = lockedAt;
	}

	public Date getLockedAt() {
		return this.lockedAt;
	}

	public void loadTags() {
		DBUtility dB = DBUtility.getInstance();
		this.tags.clear();
		try {
			for (Tag t : dB.getTagsByMemo(this)) {
				this.tags.add(t);
			}
		} catch (DatabaseException e) {
			this.tags.clear();
		}

	}
	
	
	public void loadFiles() {
		DBUtility dB = DBUtility.getInstance();
		this.Files.clear();
		try {
			for (File f : dB.getFilesByMemo(this)) {
				this.Files.add(f);
			}
		} catch (DatabaseException e) {
			Files.clear();
		}

	}

	public String getTagsAsString() {
		String s = "";
		boolean first = true;
		for (Tag t : tags) {
			if (first)
			{
				s += t.getName();
				first=false;
			}
			else
				s += ", " + t.getName();
		}
		return s;
	}

	public void update() {
		
		DBUtility.getInstance().updateMemoFromDB(this);
		
	}
}
