package de.ugoe.cs.swe.memos.datamodel;

import java.util.ArrayList;
import java.util.Vector;

import de.ugoe.cs.swe.memos.database.DBUtility;
import de.ugoe.cs.swe.memos.database.DatabaseException;

public class Category {
	private Long id;
	private String name;
	private Long parentID;
	private Category parentCategory = null;
	private Vector<Category> childCategories;
	private ArrayList<Memo> memos;

	public Category(String name) {
		this.name = name;
		this.childCategories = new Vector<Category>();
		this.memos = new ArrayList<Memo>();
	}
	
	private static Category byPath(Vector<Category> children, String[] categories, int current) {
		for (Category cat : children) {
			if (current < categories.length - 1) {
				if (cat.getName().toUpperCase().equals(categories[current].toUpperCase())) {
					return byPath(cat.getChildCategories(), categories, ++current);
				}
			}
			else {
				if (cat.getName().toUpperCase().equals(categories[current].toUpperCase()))
					return cat;
			}
		}
		
		return null;
	}
	
	public static Category byPath(String path) {
		Vector<Category> categoryList = new Vector<Category>();
		try {
			categoryList = DBUtility.getInstance().queryCategories();
		} catch (DatabaseException e) {
			System.out.println(e.toString());
		}
		return byPath(categoryList, path.split("/"), 0);
		
	}
	
	public String getPath() {
		String path = this.name + "/";
		Category parentCategory = this.getParentCategory();
		
		while (parentCategory != null) {
			path = parentCategory.getName() + "/" + path;
			parentCategory = parentCategory.getParentCategory();
		}
		return path;
	}
	
	public void clearAllChildren(){
		this.childCategories.clear();
	}
	
	public void addChild(Category child){
		this.childCategories.add(child);
		child.setParentCategory(this);
		child.setParentID(id);
	}
	
	public Long getParentID() {
		return parentID;
	}

	public void setParentID(Long parentID) {
		this.parentID = parentID;
	}

	public Long getiD() {
		return id;
	}

	public void setiD(Long iD) {
		this.id = iD;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Category getParentCategory() {
		return parentCategory;
	}

	public void setParentCategory(Category parentCategory) {
		this.parentCategory = parentCategory;
	}

	public ArrayList<Memo> getMemos() {
		return memos;
	}

	public void setMemos(ArrayList<Memo> memos) {
		this.memos = memos;
	}
	
	public void loadMemosFromDB()
	{	DBUtility dB=DBUtility.getInstance();
		try {			
			memos = dB.getMemosByCategory(this);
		} catch (DatabaseException e) {
			e.printStackTrace();
			//TODO Fehlermeldung!!!!
			childCategories = new Vector<Category>() ;
		}
		
	}

	public Vector<Category> getChildCategories() {
		if(childCategories==null){
			childCategories = new Vector<Category>() ;
		}
		return childCategories;
	}
	
	public void loadChildrenFromDB()
	{	DBUtility dB=DBUtility.getInstance();
		try {
			dB.addChildrenToCategory(this);
		} catch (DatabaseException e) {
			e.printStackTrace();
			//TODO Fehlermeldung!!!!
			childCategories = new Vector<Category>() ;
		}
		
	}

	public void setChildCategories(Vector<Category> childCategories) {
		this.childCategories = childCategories;
	}

}
