package de.ugoe.cs.swe.memos;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import de.ugoe.cs.swe.memos.gui.mainview.ArticleComposite;
import de.ugoe.cs.swe.memos.gui.mainview.View;

public class Utils {
	public static View getMainView() {
		return (View) (PlatformUI.getWorkbench().getActiveWorkbenchWindow()
				.getActivePage()
				.findView("de.ugoe.cs.swe.memos.MainView"));
	}
	
	public static GridLayout createGridLayout(int numColumns) {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = numColumns;
		gridLayout.horizontalSpacing=3;
		gridLayout.marginWidth=3;
		return gridLayout;
	}
	
	public static GridLayout createGridLayout(int numColumns, int marginWidth,int height, int vert) {
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = numColumns;
		gridLayout.horizontalSpacing=3;
		gridLayout.marginWidth=marginWidth;
		gridLayout.marginHeight=height;
		gridLayout.verticalSpacing=vert;
		return gridLayout;
	}
	
	public static void createNewMemoTab() {
		CTabItem memoTab = Utils.getMainView().addTabItem("Neu");
		Utils.getMainView().SetTabItemActive(memoTab);
		ArticleComposite articleComposite = new ArticleComposite(Utils
				.getMainView().getTabFolder(), SWT.NONE, null, Utils
				.getMainView().getCatBrowser(), ArticleComposite.MODE.WRITE);
		articleComposite.setContent(Utils.getMainView().getSearchField()
				.getText());
		Utils.getMainView().getCatBrowser().getTreeMouseListener()
				.setActiveCategoryField(articleComposite.getCategoryField());
		memoTab.setControl(articleComposite);
		//memoTab.addDisposeListener(new DisposeArticleListene(Utils.getMainView().getTabFolder()));
	}
	
	public static void showError(Exception e) {
		showError(e.getMessage());
	}
	
	public static void showError(String message) {
		MessageBox errorMessage = new MessageBox(new Shell(), SWT.ICON_ERROR | SWT.OK);
		errorMessage.setText("Ein Fehler ist aufgetreten");
		errorMessage.setMessage(message);
		errorMessage.open();
	}
}
