/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.snippets;

import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.LayerManager;
import com.onpositive.richtexteditor.model.Logger;
import com.onpositive.richtexteditor.model.partitions.CompositeChange;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.viewer.IRichDocumentAutoStylingStrategy;
import com.onpositive.richtexteditor.viewer.RichTextViewer;
import com.onpositive.richtexteditor.viewer.RichTextViewerControlConfiguration;
import com.onpositive.richtexteditor.viewer.undo.RichViewerUndoManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StylingSample {
    protected static StylingSample instance;

    public static void main(String[] args) {
        instance = new StylingSample();
        instance.run();
    }

    void run() {
        Shell shell = new Shell();
        shell.setLayout((Layout)new GridLayout(1, true));
        RichTextViewer richTextViewer = new RichTextViewer((Composite)shell, 0){

            @Override
            public RichTextViewerControlConfiguration getConfiguration() {
                return new RichTextViewerControlConfiguration(){

                    @Override
                    protected void configureLayerManager(LayerManager manager) {
                        manager.addAutoStylingStrategy(new NumberStylingStrategy());
                        super.configureLayerManager(manager);
                    }
                };
            }
        };
        GridData layoutData = new GridData(1808);
        layoutData.minimumHeight = 300;
        richTextViewer.getControl().setLayoutData((Object)layoutData);
        Display display = shell.getDisplay();
        RichViewerUndoManager undoManager = new RichViewerUndoManager(40);
        undoManager.connect((ITextViewer)richTextViewer);
        richTextViewer.setUndoManager(undoManager);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private final class NumberStylingStrategy
    implements IRichDocumentAutoStylingStrategy {
        FontStyle numberStyle = new FontStyle(1, new RGB(0, 100, 200));

        private NumberStylingStrategy() {
        }

        @Override
        public void customizeStyleChanges(DocumentEvent event, CompositeChange change, PartitionDelta existingDelta) {
            try {
                if (event.fLength == 0 && event.fText.trim().length() == 0) {
                    int offset = event.getOffset() - event.fText.length();
                    boolean hasDigits = false;
                    int a = offset;
                    while (a > 0) {
                        IDocument document = event.getDocument();
                        char c = document.getChar(a);
                        if (Character.isDigit(c)) {
                            hasDigits = true;
                        } else {
                            if (Character.isWhitespace(c)) break;
                            hasDigits = false;
                        }
                        --a;
                    }
                    if (hasDigits) {
                        change.applyStyleTo(a, event.getOffset() - a, this.numberStyle);
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.log(e);
            }
        }
    }
}

