/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.resources;

import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.resources.DisposableFontRegistry;
import com.onpositive.richtexteditor.model.resources.FontStyleManager;
import java.util.ArrayList;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.FontData;

public class FontStyleData {
    protected ArrayList<FontStyle> fontStyles = new ArrayList();
    protected ArrayList<FontStyle> deletedStyles = new ArrayList();
    protected ArrayList<FontStyle> changedStyles = new ArrayList();
    protected ArrayList<FontStyle> addedStyles = new ArrayList();
    protected DisposableFontRegistry parentFontRegistry;
    protected DisposableFontRegistry resultFontRegistry;

    public FontStyleData(ArrayList<FontStyle> initialData, DisposableFontRegistry parentFontRegistry) {
        int i = 0;
        while (i < initialData.size()) {
            FontStyle fs = initialData.get(i);
            this.fontStyles.add((FontStyle)fs.clone());
            ++i;
        }
        this.parentFontRegistry = parentFontRegistry;
    }

    public ArrayList<FontStyle> getFontStyles() {
        return this.fontStyles;
    }

    public void setFontStyles(ArrayList<FontStyle> fontStyles) {
        this.fontStyles = fontStyles;
    }

    public ArrayList<FontStyle> getDeletedStyles() {
        return this.deletedStyles;
    }

    public DisposableFontRegistry getResultFontRegistry() {
        return this.resultFontRegistry;
    }

    public ArrayList<FontStyle> getAddedStyles() {
        return this.addedStyles;
    }

    public void setAddedStyles(ArrayList<FontStyle> addedStyles) {
        this.addedStyles = addedStyles;
    }

    public void setResultFontRegistry(DisposableFontRegistry resultFontRegistry) {
        this.resultFontRegistry = resultFontRegistry;
    }

    public FontRegistry getParentFontRegistry() {
        return this.parentFontRegistry;
    }

    public void setDeletedStyles(ArrayList<FontStyle> deletedStyles) {
        this.deletedStyles = deletedStyles;
    }

    public void addChangedStyle(FontStyle style) {
        if (this.changedStyles.indexOf(style) == -1) {
            this.changedStyles.add(style);
        }
    }

    public ArrayList<FontStyle> validateChangedStyles(FontStyleManager manager) {
        int i = 0;
        while (i < this.changedStyles.size()) {
            FontStyle fontStyle = this.changedStyles.get(i);
            FontStyle style2 = manager.getStyleMap().get(fontStyle.getFontDataName());
            if (style2 != null) {
                FontData[] oldFD = this.parentFontRegistry.getFontData(style2.getFontDataName());
                if (style2.equals(fontStyle) && oldFD[0].equals((Object)this.resultFontRegistry.getFontData(fontStyle.getFontDataName()))) {
                    this.changedStyles.remove(i--);
                }
            }
            ++i;
        }
        return this.changedStyles;
    }
}

